/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.event;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.wb.internal.core.model.property.event.ListenerInfo;
import org.eclipse.wb.internal.core.utils.GenericTypeResolver;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

final class ListenerMethodInfo {
    private final ListenerInfo m_listener;
    private final Method m_method;
    private final String m_signature;

    public ListenerMethodInfo(ListenerInfo listener, Method method) {
        this.m_listener = listener;
        this.m_method = method;
        this.m_signature = ReflectionUtils.getMethodSignature((Method)method);
    }

    public ListenerInfo getListener() {
        return this.m_listener;
    }

    public Method getMethod() {
        return this.m_method;
    }

    public String getSignature() {
        return this.m_signature;
    }

    public String getName() {
        return this.m_method.getName();
    }

    public boolean isAbstract() {
        return ReflectionUtils.isAbstract((Method)this.m_method);
    }

    public String getSignatureAST() {
        String name = this.m_method.getName();
        StringBuilder buffer = new StringBuilder();
        buffer.append(name);
        buffer.append('(');
        boolean firstParameter = true;
        String[] stringArray = this.getActualParameterTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String parameterType = stringArray[n2];
            if (firstParameter) {
                firstParameter = false;
            } else {
                buffer.append(',');
            }
            parameterType = StringUtils.substringBefore((String)parameterType, (String)"<");
            buffer.append(parameterType);
            ++n2;
        }
        buffer.append(')');
        return buffer.toString();
    }

    public String[] getActualParameterTypes() {
        Type[] genericTypes = this.m_method.getGenericParameterTypes();
        GenericTypeResolver resolver = this.m_listener.getResolver();
        return GenericsUtils.getTypeNames((GenericTypeResolver)resolver, (Type[])genericTypes);
    }
}

