
package org.eclipse.wb.core.databinding.xsd.component;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * 
 * <p>Java class for PropertyCategory</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="PropertyCategory">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="preferred"/>
 *     <enumeration value="normal"/>
 *     <enumeration value="advanced"/>
 *     <enumeration value="hidden"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "PropertyCategory", namespace = "http://www.eclipse.org/wb/WBPComponent")
@XmlEnum
public enum PropertyCategory {

    @XmlEnumValue("preferred")
    PREFERRED("preferred"),
    @XmlEnumValue("normal")
    NORMAL("normal"),
    @XmlEnumValue("advanced")
    ADVANCED("advanced"),
    @XmlEnumValue("hidden")
    HIDDEN("hidden");
    private final String value;

    PropertyCategory(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static PropertyCategory fromValue(String v) {
        for (PropertyCategory c: PropertyCategory.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
