/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.unittest.internal.ui;

import java.text.MessageFormat;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.unittest.internal.ui.Images;
import org.eclipse.unittest.internal.ui.Messages;

public class CounterPanel
extends Composite {
    protected Text fNumberOfErrors;
    protected Text fNumberOfFailures;
    protected Text fNumberOfRuns;
    protected Integer fTotal;
    protected int fIgnoredCount;
    protected int fAssumptionFailedCount;
    private final Image fErrorIcon = Images.createImage("ovr16/error_ovr.svg");
    private final Image fFailureIcon = Images.createImage("ovr16/failed_ovr.svg");

    public CounterPanel(Composite parent) {
        super(parent, 64);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 9;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.fNumberOfRuns = this.createLabel(Messages.CounterPanel_label_runs, null, " 0/0  ");
        this.fNumberOfErrors = this.createLabel(Messages.CounterPanel_label_errors, this.fErrorIcon, " 0 ");
        this.fNumberOfFailures = this.createLabel(Messages.CounterPanel_label_failures, this.fFailureIcon, " 0 ");
        this.addDisposeListener(e -> this.disposeIcons());
    }

    private void disposeIcons() {
        this.fErrorIcon.dispose();
        this.fFailureIcon.dispose();
    }

    private Text createLabel(String name, Image image, String init) {
        Label label = new Label((Composite)this, 0);
        if (image != null) {
            image.setBackground(label.getBackground());
            label.setImage(image);
        }
        label.setLayoutData((Object)new GridData(32));
        label = new Label((Composite)this, 0);
        label.setText(name);
        label.setLayoutData((Object)new GridData(32));
        Text value = new Text((Composite)this, 8);
        value.setText(init);
        CounterPanel.fixReadonlyTextBackground(value);
        value.setLayoutData((Object)new GridData(800));
        return value;
    }

    public void reset() {
        this.fTotal = null;
        this.setErrorValue(0);
        this.setFailureValue(0);
        this.setRunValue(0, 0, 0);
    }

    public void setTotal(Integer value) {
        this.fTotal = value;
    }

    public void setRunValue(int value, int ignoredCount, int assumptionFailureCount) {
        String runStringTooltip;
        String runString;
        String totalString;
        String string = totalString = this.fTotal == null ? "?" : this.fTotal.toString();
        if (ignoredCount == 0 && assumptionFailureCount == 0) {
            runStringTooltip = runString = MessageFormat.format(Messages.CounterPanel_runcount, Integer.toString(value), totalString);
        } else if (ignoredCount != 0 && assumptionFailureCount == 0) {
            runString = MessageFormat.format(Messages.CounterPanel_runcount_skipped, Integer.toString(value), totalString, Integer.toString(ignoredCount));
            runStringTooltip = MessageFormat.format(Messages.CounterPanel_runcount_ignored, Integer.toString(value), totalString, Integer.toString(ignoredCount));
        } else if (ignoredCount == 0 && assumptionFailureCount != 0) {
            runString = MessageFormat.format(Messages.CounterPanel_runcount_skipped, Integer.toString(value), totalString, Integer.toString(assumptionFailureCount));
            runStringTooltip = MessageFormat.format(Messages.CounterPanel_runcount_assumptionsFailed, Integer.toString(value), totalString, Integer.toString(assumptionFailureCount));
        } else {
            runString = MessageFormat.format(Messages.CounterPanel_runcount_skipped, Integer.toString(value), totalString, Integer.toString(ignoredCount + assumptionFailureCount));
            runStringTooltip = MessageFormat.format(Messages.CounterPanel_runcount_ignored_assumptionsFailed, Integer.toString(value), totalString, Integer.toString(ignoredCount), Integer.toString(assumptionFailureCount));
        }
        this.fNumberOfRuns.setText(runString);
        this.fNumberOfRuns.setToolTipText(runStringTooltip);
        if (this.fIgnoredCount == 0 && ignoredCount > 0 || this.fIgnoredCount != 0 && ignoredCount == 0) {
            this.layout();
        } else if (this.fAssumptionFailedCount == 0 && assumptionFailureCount > 0 || this.fAssumptionFailedCount != 0 && assumptionFailureCount == 0) {
            this.layout();
        } else {
            this.fNumberOfRuns.redraw();
            this.redraw();
        }
        this.fIgnoredCount = ignoredCount;
        this.fAssumptionFailedCount = assumptionFailureCount;
    }

    public void setErrorValue(int value) {
        this.fNumberOfErrors.setText(Integer.toString(value));
        this.redraw();
    }

    public void setFailureValue(int value) {
        this.fNumberOfFailures.setText(Integer.toString(value));
        this.redraw();
    }

    public static void fixReadonlyTextBackground(Text textField) {
        textField.setBackground(textField.getDisplay().getSystemColor(22));
    }
}

