/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.markdown.marked;

import java.util.regex.Matcher;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.utils.StringUtils;
import org.eclipse.tm4e.markdown.marked.BlockRules;
import org.eclipse.tm4e.markdown.marked.Options;
import org.eclipse.tm4e.markdown.marked.Token;
import org.eclipse.tm4e.markdown.marked.TokenType;
import org.eclipse.tm4e.markdown.marked.Tokens;

public class Lexer {
    private final BlockRules rules;
    private final Tokens tokens = new Tokens();
    private final Options options;

    public Lexer(@Nullable Options options) {
        Options options2 = this.options = options != null ? options : Options.DEFAULTS;
        this.rules = this.options.isGfm() ? (this.options.isTables() ? BlockRules.tables : BlockRules.gfm) : BlockRules.normal;
    }

    public static Tokens lex(String src, @Nullable Options options) {
        Lexer lexer = new Lexer(options);
        return lexer.lex(src);
    }

    private Tokens lex(String src) {
        src = src.replaceAll("\r\n|\r", "\n").replace("\t", "    ").replace("\u00a0", " ").replace("\u2424", "\n");
        return this.token(src, true);
    }

    private Tokens token(String src, boolean top) {
        return this.token(src, top, null);
    }

    private Tokens token(String src, boolean top, @Nullable Object bq) {
        src = src.replaceAll("^ +$", "");
        while (!StringUtils.isNullOrEmpty((String)src)) {
            String text;
            Matcher cap = this.rules.newline.exec(src);
            if (cap != null) {
                src = src.substring(cap.group(0).length());
                if (cap.group(0).length() > 1) {
                    this.tokens.add(new Token(TokenType.space));
                }
            }
            if ((cap = this.rules.fences.exec(src)) != null) {
                src = src.substring(cap.group(0).length());
                String lang = cap.group(2);
                String text2 = !StringUtils.isNullOrEmpty((String)cap.group(3)) ? cap.group(3) : "";
                this.tokens.add(new Token(TokenType.code, lang, text2));
                continue;
            }
            cap = this.rules.heading.exec(src);
            if (cap != null) {
                src = src.substring(cap.group(0).length());
                text = cap.group(2);
                int depth = cap.group(1).length();
                this.tokens.add(new Token(TokenType.heading, text, depth));
                continue;
            }
            cap = this.rules.lheading.exec(src);
            if (cap != null) {
                src = src.substring(cap.group(0).length());
                text = cap.group(1);
                int depth = cap.group(2).equals("=") ? 1 : 2;
                this.tokens.add(new Token(TokenType.heading, text, depth));
                continue;
            }
            cap = this.rules.hr.exec(src);
            if (cap != null) {
                src = src.substring(cap.group(0).length());
                this.tokens.add(new Token(TokenType.hr));
                continue;
            }
            if (!top || (cap = this.rules.paragraph.exec(src)) == null) continue;
            src = src.substring(cap.group(0).length());
            text = cap.group(1).charAt(cap.group(1).length() - 1) == '\n' ? cap.group(1) : cap.group(1);
            this.tokens.add(new Token(TokenType.paragraph, text));
        }
        return this.tokens;
    }
}

