/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.stdlib;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QVTOEnvironment;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.evaluator.EvaluationUtil;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractContextualOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractQVTStdlib;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandlerAdapter;
import org.eclipse.m2m.internal.qvt.oml.stdlib.ObjectOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.StdlibModuleOperations;
import org.eclipse.m2m.qvt.oml.util.MutableList;
import org.eclipse.m2m.qvt.oml.util.Utils;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.util.CollectionUtil;
import org.eclipse.ocl.util.ObjectUtil;
import org.eclipse.ocl.util.TypeUtil;

public class CollectionTypeOperations
extends AbstractContextualOperations {
    static final String AS_LIST_NAME = "asList";
    private static final CallHandler AS_SET = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof Collection) {
                return CollectionUtil.asSet((Collection)((Collection)source));
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static final CallHandler AS_ORDERED_SET = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof Collection) {
                return CollectionUtil.asOrderedSet((Collection)((Collection)source));
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static final CallHandler AS_SEQUENCE = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof Collection) {
                if (source instanceof MutableList) {
                    return CollectionUtil.createNewSequence((Collection)((Collection)source));
                }
                return CollectionUtil.asSequence((Collection)((Collection)source));
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static final CallHandler AS_BAG = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof Collection) {
                return CollectionUtil.asBag((Collection)((Collection)source));
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static final CallHandler AS_LIST = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof Collection) {
                return EvaluationUtil.asList((Collection)source);
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    static final CallHandler FLATTEN = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof Collection) {
                Collection self = (Collection)source;
                if (self instanceof LinkedHashSet) {
                    self = CollectionUtil.createNewSet((Collection)self);
                }
                MutableList result = CollectionUtil.flatten((Collection)self);
                if (source instanceof MutableList && (!(result instanceof MutableList) || source == result)) {
                    result = Utils.createList(result);
                }
                return result;
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static final CallHandler INCLUDES = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof Collection && args.length > 0) {
                if (args[0] == CallHandlerAdapter.getInvalidResult(evalEnv)) {
                    return CallHandlerAdapter.getInvalidResult(evalEnv);
                }
                return CollectionUtil.includes((Collection)((Collection)source), (Object)args[0]);
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static final CallHandler EXCLUDES = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof Collection && args.length > 0) {
                if (args[0] == CallHandlerAdapter.getInvalidResult(evalEnv)) {
                    return CallHandlerAdapter.getInvalidResult(evalEnv);
                }
                return CollectionUtil.excludes((Collection)((Collection)source), (Object)args[0]);
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static final CallHandler COUNT = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof Collection && args.length > 0) {
                if (args[0] == CallHandlerAdapter.getInvalidResult(evalEnv)) {
                    return CallHandlerAdapter.getInvalidResult(evalEnv);
                }
                return CollectionUtil.count((Collection)((Collection)source), (Object)args[0]);
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static final CallHandler INCLUDES_ALL = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof Collection && args.length > 0 && args[0] instanceof Collection) {
                return CollectionUtil.includesAll((Collection)((Collection)source), (Collection)((Collection)args[0]));
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static final CallHandler EXCLUDES_ALL = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof Collection && args.length > 0 && args[0] instanceof Collection) {
                return CollectionUtil.excludesAll((Collection)((Collection)source), (Collection)((Collection)args[0]));
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static final CallHandler EQUAL = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof Collection && args.length > 0) {
                if (args[0] == CallHandlerAdapter.getInvalidResult(evalEnv)) {
                    return CallHandlerAdapter.getInvalidResult(evalEnv);
                }
                return ObjectUtil.equal((Object)source, (Object)args[0]);
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static final CallHandler NOT_EQUAL = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof Collection && args.length > 0) {
                if (args[0] == CallHandlerAdapter.getInvalidResult(evalEnv)) {
                    return CallHandlerAdapter.getInvalidResult(evalEnv);
                }
                return !ObjectUtil.equal((Object)source, (Object)args[0]);
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };

    private CollectionTypeOperations(AbstractQVTStdlib library, EClassifier contextType) {
        super(library, contextType);
    }

    public static AbstractContextualOperations[] getAllOperations(AbstractQVTStdlib library) {
        QVTOEnvironment environment = library.getEnvironment();
        return new AbstractContextualOperations[]{new CollectionTypeOperations(library, (EClassifier)environment.getOCLStandardLibrary().getCollection())};
    }

    @Override
    protected AbstractContextualOperations.OperationProvider[] getOperations() {
        OCLStandardLibrary oclStdlib = this.getStdlib().getEnvironment().getOCLStandardLibrary();
        EClassifier collectionOfT2 = (EClassifier)TypeUtil.resolveCollectionType((Environment)this.getStdlib().getEnvironment(), (CollectionKind)CollectionKind.COLLECTION_LITERAL, (Object)((EClassifier)oclStdlib.getT2()));
        return new AbstractContextualOperations.OperationProvider[]{(AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(AS_SET, "asSet", (EClassifier)oclStdlib.getSet(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(AS_ORDERED_SET, "asOrderedSet", (EClassifier)oclStdlib.getOrderedSet(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(AS_SEQUENCE, "asSequence", (EClassifier)oclStdlib.getSequence(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(AS_BAG, "asBag", (EClassifier)oclStdlib.getBag(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(AS_LIST, AS_LIST_NAME, this.getStdlib().getList(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(FLATTEN, "flatten", collectionOfT2, new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(ObjectOperations.REPR, "repr", (EClassifier)oclStdlib.getString(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(StdlibModuleOperations.DUMP, "dump", (EClassifier)oclStdlib.getOclVoid(), new EClassifier[0]).deprecate(), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(INCLUDES, "includes", new String[]{"object"}, (EClassifier)oclStdlib.getBoolean(), (EClassifier)oclStdlib.getT2()), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(EXCLUDES, "excludes", new String[]{"object"}, (EClassifier)oclStdlib.getBoolean(), (EClassifier)oclStdlib.getT2()), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(COUNT, "count", new String[]{"object"}, (EClassifier)oclStdlib.getInteger(), (EClassifier)oclStdlib.getT2()), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(INCLUDES_ALL, "includesAll", new String[]{"c2"}, (EClassifier)oclStdlib.getBoolean(), collectionOfT2), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(EXCLUDES_ALL, "excludesAll", new String[]{"c2"}, (EClassifier)oclStdlib.getBoolean(), collectionOfT2), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(EQUAL, "=", new String[]{"c"}, (EClassifier)oclStdlib.getBoolean(), collectionOfT2), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(NOT_EQUAL, "<>", new String[]{"c"}, (EClassifier)oclStdlib.getBoolean(), collectionOfT2)};
    }
}

