/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.injectors.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.engine.injectors.Injector;
import org.eclipse.m2m.atl.engine.injectors.xml.ProtectedHandler;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMInteger;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModelElement;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLInjector
extends DefaultHandler
implements Injector {
    private static final boolean debug = false;
    private boolean keepWhitespace = true;
    private ASMModel extent;
    private Locator locator = null;
    private ASMModelElement current = null;
    private ASMModelElement root = null;
    private int errors;
    private int prevLineNumber = 1;
    private int prevColumnNumber = 1;
    private static Map parameterTypes = new HashMap();

    static {
        parameterTypes.put("keepWhitespace", "String");
    }

    @Override
    public Map getParameterTypes() {
        return parameterTypes;
    }

    @Override
    public ASMModelElement inject(ASMModel target, InputStream source, Map params) throws IOException {
        this.keepWhitespace = !"false".equals(params.get("keepWhitespace"));
        this.performImportation(null, target, source, null);
        return this.root;
    }

    @Override
    public ASMModelElement inject(ASMModel target, Reader source, Map params) throws IOException {
        this.keepWhitespace = !"false".equals(params.get("keepWhitespace"));
        this.performImportation(null, target, new InputSource(source), null);
        return this.root;
    }

    @Override
    public String getPrefix() {
        return "xml";
    }

    @Override
    public void performImportation(ASMModel format, ASMModel extent, InputStream in, String other) throws IOException {
        this.extent = extent;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            this.errors = 0;
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(in, (DefaultHandler)new ProtectedHandler(this));
        }
        catch (Throwable err) {
            ATLLogger.log((Level)Level.SEVERE, (String)err.getLocalizedMessage(), (Throwable)err);
        }
    }

    private void performImportation(ASMModel format, ASMModel extent, InputSource in, String other) {
        this.extent = extent;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            this.errors = 0;
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(in, (DefaultHandler)new ProtectedHandler(this));
        }
        catch (Throwable err) {
            ATLLogger.log((Level)Level.SEVERE, (String)err.getLocalizedMessage(), (Throwable)err);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        int end = start + length - 1;
        if (start > end) {
            return;
        }
        String value = new String(ch, start, length);
        if (!this.keepWhitespace) {
            value = value.trim();
        }
        if (value.length() > 0) {
            ASMModelElement attr = this.extent.newModelElement("Text");
            attr.set(null, "name", new ASMString("#text"));
            attr.set(null, "value", new ASMString(value));
            attr.set(null, "parent", this.current);
            if (this.locator != null) {
                if (this.locator.getLineNumber() != -1) {
                    int lineNumber = this.locator.getLineNumber();
                    attr.set(null, "startLine", new ASMInteger(this.prevLineNumber));
                    attr.set(null, "endLine", new ASMInteger(lineNumber));
                    this.prevLineNumber = lineNumber;
                }
                if (this.locator.getColumnNumber() != -1) {
                    int n = 0;
                    int columnNumber = this.locator.getColumnNumber() - n;
                    attr.set(null, "startColumn", new ASMInteger(this.prevColumnNumber));
                    attr.set(null, "endColumn", new ASMInteger(columnNumber));
                    this.prevColumnNumber = columnNumber;
                }
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        ASMModelElement parent = this.current;
        if (this.current == null) {
            this.current = this.root = this.extent.newModelElement("Root");
        } else {
            this.current = this.extent.newModelElement("Element");
            this.current.set(null, "parent", parent);
        }
        this.current.set(null, "name", new ASMString(qName));
        int i = 0;
        while (i < attributes.getLength()) {
            ASMModelElement attr = this.extent.newModelElement("Attribute");
            attr.set(null, "name", new ASMString(attributes.getQName(i)));
            attr.set(null, "value", new ASMString(attributes.getValue(i)));
            attr.set(null, "parent", this.current);
            ++i;
        }
        if (this.locator != null) {
            if (this.locator.getLineNumber() != -1) {
                this.current.set(null, "startLine", new ASMInteger(this.prevLineNumber));
                this.prevLineNumber = this.locator.getLineNumber();
            }
            if (this.locator.getColumnNumber() != -1) {
                this.current.set(null, "startColumn", new ASMInteger(this.prevColumnNumber));
                this.prevColumnNumber = this.locator.getColumnNumber();
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        ASMOclAny parent = this.current.get(null, "parent");
        if (this.locator != null) {
            if (this.locator.getLineNumber() != -1) {
                this.prevLineNumber = this.locator.getLineNumber();
                this.current.set(null, "endLine", new ASMInteger(this.prevLineNumber));
            }
            if (this.locator.getColumnNumber() != -1) {
                this.prevColumnNumber = this.locator.getColumnNumber();
                this.current.set(null, "endColumn", new ASMInteger(this.prevColumnNumber));
            }
        }
        this.current = parent instanceof ASMModelElement ? (ASMModelElement)parent : null;
    }

    @Override
    public void error(SAXParseException e) {
        ATLLogger.severe((String)("Error: line " + e.getLineNumber() + ":" + e.getColumnNumber() + ": " + e.getMessage()));
        ++this.errors;
    }

    @Override
    public void fatalError(SAXParseException e) {
        ATLLogger.severe((String)("Fatal error: line " + e.getLineNumber() + ":" + e.getColumnNumber() + ": " + e.getMessage()));
        ++this.errors;
    }
}

