/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.context;

import com.ibm.icu.util.StringTokenizer;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jst.ws.internal.context.ScenarioContext;
import org.eclipse.jst.ws.internal.context.ScenarioDefaults;
import org.eclipse.jst.ws.internal.context.TransientScenarioContext;
import org.eclipse.jst.ws.internal.ext.test.WebServiceTestExtension;
import org.eclipse.jst.ws.internal.ext.test.WebServiceTestRegistry;
import org.eclipse.jst.ws.internal.plugin.WebServicePlugin;
import org.eclipse.wst.command.internal.env.context.PersistentContext;

public class PersistentScenarioContext
extends PersistentContext
implements ScenarioContext {
    public PersistentScenarioContext() {
        super((Plugin)WebServicePlugin.getInstance());
    }

    public void load() {
        ScenarioDefaults defaults = new ScenarioDefaults();
        String[] ids = defaults.getWebServiceTestIds();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < ids.length) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(ids[i]);
            ++i;
        }
        String nonJavaTestService = defaults.getNonJavaTestServiceDefault();
        this.setDefaultStringIfNoDefault("webServiceTestTypes", sb.toString());
        this.setDefaultStringIfNoDefault("nonJavaTestService", nonJavaTestService);
        this.setDefaultStringIfNoDefault("clientWebServiceType", defaults.webserviceClientTypeDefault());
        this.setDefaultStringIfNoDefault("webServiceType", defaults.webserviceTypeIdDefault());
        this.setDefaultBooleanIfNoDefault("generateProxy", defaults.generateProxyDefault());
        this.setDefaultBooleanIfNoDefault("launchWebServiceExplorer", defaults.launchWebserviceExplorerDefault());
        this.setDefaultBooleanIfNoDefault("installWebService", defaults.installWebserviceDefault());
        this.setDefaultBooleanIfNoDefault("installClient", defaults.installClientDefault());
        this.setDefaultBooleanIfNoDefault("startWebService", defaults.startWebserviceDefault());
        this.setDefaultBooleanIfNoDefault("testWebService", defaults.testWebserviceDefault());
        this.setDefaultBooleanIfNoDefault("monitorWebService", defaults.getMonitorWebServiceDefault());
        this.setDefaultBooleanIfNoDefault("launchSample", defaults.launchSample());
        this.setDefaultIntIfNoDefault("generateWebService", defaults.serviceGenerationDefault());
        this.setDefaultIntIfNoDefault("generateClient", defaults.clientGenerationDefault());
    }

    @Override
    public String[] getNonJavaTestService() {
        WebServiceTestRegistry registry = WebServiceTestRegistry.getInstance();
        String[] ids = this.getWebServiceTestIds();
        Vector<String> newTestCases = new Vector<String>();
        int i = 0;
        while (i < ids.length) {
            WebServiceTestExtension wse = (WebServiceTestExtension)registry.getWebServiceExtensionsById(ids[i]);
            if (wse != null && wse.testWSDL()) {
                newTestCases.addElement(wse.getLabel());
            }
            ++i;
        }
        String[] wsdlTestArray = new String[newTestCases.size()];
        Enumeration e = newTestCases.elements();
        int i2 = 0;
        while (e.hasMoreElements()) {
            wsdlTestArray[i2] = (String)e.nextElement();
            ++i2;
        }
        return wsdlTestArray;
    }

    @Override
    public void setWebServiceTestIds(String[] ids) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < ids.length) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(ids[i]);
            ++i;
        }
        this.setValue("webServiceTestTypes", sb.toString());
    }

    private String[] getWebServiceTestIds(String value) {
        StringTokenizer st = new StringTokenizer(value, ",");
        String[] s = new String[st.countTokens()];
        int i = 0;
        while (i < s.length) {
            s[i] = WebServiceTestRegistry.getInstance().labelToId(st.nextToken());
            ++i;
        }
        return s;
    }

    @Override
    public String[] getWebServiceTestIds() {
        return this.getWebServiceTestIds(this.getValueAsString("webServiceTestTypes"));
    }

    public String[] getDefaultWebServiceTestIds() {
        return this.getWebServiceTestIds(this.getDefaultString("webServiceTestTypes"));
    }

    @Override
    public void setWebServiceTestTypes(String[] ids) {
    }

    @Override
    public String[] getWebServiceTestTypes() {
        WebServiceTestRegistry registry = WebServiceTestRegistry.getInstance();
        String[] ids = this.getWebServiceTestIds();
        Vector<String> labels = new Vector<String>();
        int i = 0;
        while (i < ids.length) {
            WebServiceTestExtension wse = (WebServiceTestExtension)registry.getWebServiceExtensionsById(ids[i]);
            if (wse != null) {
                labels.addElement(wse.getLabel());
            }
            ++i;
        }
        Object[] s = new String[labels.size()];
        labels.copyInto(s);
        return s;
    }

    @Override
    public ScenarioContext copy() {
        TransientScenarioContext context = new TransientScenarioContext();
        context.setWebServiceTestIds(this.getWebServiceTestIds());
        context.setWebServiceTestTypes(this.getWebServiceTestTypes());
        context.setNonJavaTestService(this.getNonJavaTestService());
        context.setClientWebServiceType(this.getClientWebServiceType());
        context.setWebServiceType(this.getWebServiceType());
        context.setLaunchWebServiceExplorer(this.getLaunchWebServiceExplorer());
        context.setStartWebService(this.getStartWebService());
        context.setGenerateProxy(this.getGenerateProxy());
        context.setTestWebService(this.getTestWebService());
        context.setMonitorWebService(this.getMonitorWebService());
        context.setLaunchSampleEnabled(this.isLaunchSampleEnabled());
        return context;
    }

    @Override
    public String getClientWebServiceType() {
        return this.getValueAsString("clientWebServiceType");
    }

    @Override
    public String getClientWebServiceTypeDefault() {
        return this.getDefaultString("clientWebServiceType");
    }

    @Override
    public boolean getGenerateProxy() {
        return this.getValueAsBoolean("generateProxy");
    }

    @Override
    public boolean getGenerateProxyDefault() {
        return this.getDefaultBoolean("generateProxy");
    }

    @Override
    public boolean getLaunchWebServiceExplorer() {
        return this.getValueAsBoolean("launchWebServiceExplorer");
    }

    @Override
    public boolean getLaunchWebServiceExplorerDefault() {
        return this.getDefaultBoolean("launchWebServiceExplorer");
    }

    @Override
    public boolean getStartWebService() {
        return this.getValueAsBoolean("startWebService");
    }

    @Override
    public boolean getStartWebServiceDefault() {
        return this.getDefaultBoolean("startWebService");
    }

    @Override
    public boolean getInstallWebService() {
        return this.getValueAsBoolean("installWebService");
    }

    @Override
    public boolean getInstallWebServiceDefault() {
        return this.getDefaultBoolean("installWebService");
    }

    @Override
    public boolean getInstallClient() {
        return this.getValueAsBoolean("installClient");
    }

    @Override
    public boolean getInstallClientDefault() {
        return this.getDefaultBoolean("installClient");
    }

    @Override
    public boolean getTestWebService() {
        return this.getValueAsBoolean("testWebService");
    }

    @Override
    public boolean getTestWebServiceDefault() {
        return this.getDefaultBoolean("testWebService");
    }

    @Override
    public String getWebServiceType() {
        return this.getValueAsString("webServiceType");
    }

    @Override
    public String getWebServiceTypeDefault() {
        return this.getDefaultString("webServiceType");
    }

    @Override
    public void setClientWebServiceType(String value) {
        this.setValue("clientWebServiceType", value);
    }

    @Override
    public void setGenerateProxy(boolean value) {
        this.setValue("generateProxy", value);
    }

    @Override
    public void setLaunchWebServiceExplorer(boolean value) {
        this.setValue("launchWebServiceExplorer", value);
    }

    @Override
    public void setInstallWebService(boolean value) {
        this.setValue("installWebService", value);
    }

    @Override
    public void setInstallClient(boolean value) {
        this.setValue("installClient", value);
    }

    @Override
    public void setStartWebService(boolean value) {
        this.setValue("startWebService", value);
    }

    @Override
    public void setTestWebService(boolean value) {
        this.setValue("testWebService", value);
    }

    @Override
    public void setWebServiceType(String value) {
        this.setValue("webServiceType", value);
    }

    @Override
    public boolean getMonitorWebService() {
        return this.getValueAsBoolean("monitorWebService");
    }

    @Override
    public boolean getMonitorWebServiceDefault() {
        return this.getDefaultBoolean("monitorWebService");
    }

    @Override
    public void setMonitorWebService(boolean value) {
        this.setValue("monitorWebService", value);
    }

    @Override
    public boolean getLaunchSampleEnabledDefault() {
        return this.getDefaultBoolean("launchSample");
    }

    @Override
    public boolean isLaunchSampleEnabled() {
        return this.getValueAsBoolean("launchSample");
    }

    @Override
    public void setLaunchSampleEnabled(boolean value) {
        this.setValue("launchSample", value);
    }

    @Override
    public int getGenerateWebService() {
        return this.getValueAsInt("generateWebService");
    }

    @Override
    public int getGenerateWebServiceDefault() {
        return this.getDefaultInt("generateWebService");
    }

    @Override
    public void setGenerateWebService(int value) {
        this.setValue("generateWebService", value);
    }

    @Override
    public int getGenerateClientDefault() {
        return this.getDefaultInt("generateClient");
    }

    @Override
    public int getGenerateClient() {
        return this.getValueAsInt("generateClient");
    }

    @Override
    public void setGenerateClient(int value) {
        this.setValue("generateClient", value);
    }
}

