/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.manipulation.CodeGeneration;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.corext.codemanipulation.AddDelegateMethodsOperation;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.RedundantNullnessTypeAnnotationsFilter;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterProfileManagerCore;
import org.eclipse.text.edits.TextEditGroup;

public final class StubUtility2Core {
    public static Predicate<IMethodBinding> IMPLEMENT_RECORD_SYNTHETICS = m -> m.isSyntheticRecordMethod();

    public static MethodDeclaration createImplementationStub(ICompilationUnit unit, ASTRewrite rewrite, ImportRewrite imports, ImportRewrite.ImportRewriteContext context, IMethodBinding binding, ITypeBinding targetType, CodeGenerationSettings settings, boolean inInterface, ASTNode astNode) throws CoreException {
        return StubUtility2Core.createImplementationStub(unit, rewrite, imports, context, binding, null, targetType, settings, inInterface, astNode);
    }

    public static MethodDeclaration createImplementationStub(ICompilationUnit unit, ASTRewrite rewrite, ImportRewrite imports, ImportRewrite.ImportRewriteContext context, IMethodBinding binding, String[] parameterNames, ITypeBinding targetType, CodeGenerationSettings settings, boolean inInterface, ASTNode astNode) throws CoreException {
        boolean skipOverride;
        String string;
        Assert.isNotNull((Object)imports);
        Assert.isNotNull((Object)rewrite);
        AST ast = rewrite.getAST();
        String type = Bindings.getTypeQualifiedName(targetType);
        IJavaProject javaProject = unit.getJavaProject();
        EnumSet<ImportRewrite.TypeLocation> nullnessDefault = null;
        if (astNode != null && "enabled".equals(javaProject.getOption("org.eclipse.jdt.core.compiler.annotation.nullanalysis", true))) {
            nullnessDefault = RedundantNullnessTypeAnnotationsFilter.determineNonNullByDefaultLocations(astNode, RedundantNullnessTypeAnnotationsFilter.determineNonNullByDefaultNames(javaProject));
        }
        MethodDeclaration decl = ast.newMethodDeclaration();
        decl.modifiers().addAll(StubUtility2Core.getImplementationModifiers(ast, binding, inInterface, imports, context, nullnessDefault));
        decl.setName(ast.newSimpleName(binding.getName()));
        decl.setConstructor(false);
        ITypeBinding bindingReturnType = binding.getReturnType();
        bindingReturnType = StubUtility2Core.replaceWildcardsAndCaptures(bindingReturnType);
        StubUtility2Core.createTypeParameters(imports, context, ast, binding, decl);
        decl.setReturnType2(imports.addImport(bindingReturnType, ast, context, ImportRewrite.TypeLocation.RETURN_TYPE));
        List<SingleVariableDeclaration> parameters = StubUtility2Core.createParameters(javaProject, imports, context, ast, binding, parameterNames, decl, nullnessDefault);
        StubUtility2Core.createThrownExceptions(decl, binding, imports, context, ast);
        String delimiter = unit.findRecommendedLineSeparator();
        int modifiers = binding.getModifiers();
        ITypeBinding declaringType = binding.getDeclaringClass();
        ITypeBinding typeObject = ast.resolveWellKnownType("java.lang.Object");
        if (!inInterface || declaringType != typeObject) {
            String placeHolder;
            Map<String, String> options = FormatterProfileManagerCore.getProjectSettings(javaProject);
            Block body = ast.newBlock();
            decl.setBody(body);
            String bodyStatement = "";
            if (Modifier.isAbstract((int)modifiers)) {
                Expression expression = ASTNodeFactory.newDefaultExpression(ast, decl.getReturnType2(), bindingReturnType, decl.getExtraDimensions());
                if (expression != null) {
                    ReturnStatement returnStatement = ast.newReturnStatement();
                    returnStatement.setExpression(expression);
                    bodyStatement = ASTNodes.asFormattedString((ASTNode)returnStatement, 0, delimiter, options);
                }
            } else {
                SuperMethodInvocation invocation = ast.newSuperMethodInvocation();
                if (declaringType.isInterface()) {
                    ITypeBinding supertype = Bindings.findImmediateSuperTypeInHierarchy(targetType, declaringType.getTypeDeclaration().getQualifiedName());
                    if (supertype == null) {
                        supertype = declaringType;
                    }
                    if (supertype.isInterface()) {
                        String qualifier = imports.addImport(supertype.getTypeDeclaration(), context);
                        Name name = ASTNodeFactory.newName(ast, qualifier);
                        invocation.setQualifier(name);
                    }
                }
                invocation.setName(ast.newSimpleName(binding.getName()));
                SingleVariableDeclaration varDecl2 = null;
                for (SingleVariableDeclaration varDecl2 : parameters) {
                    invocation.arguments().add(ast.newSimpleName(varDecl2.getName().getIdentifier()));
                }
                SuperMethodInvocation expression = invocation;
                Type returnType = decl.getReturnType2();
                if (returnType instanceof PrimitiveType && ((PrimitiveType)returnType).getPrimitiveTypeCode().equals(PrimitiveType.VOID)) {
                    bodyStatement = ASTNodes.asFormattedString((ASTNode)ast.newExpressionStatement((Expression)expression), 0, delimiter, options);
                } else {
                    ReturnStatement returnStatement = ast.newReturnStatement();
                    returnStatement.setExpression((Expression)expression);
                    bodyStatement = ASTNodes.asFormattedString((ASTNode)returnStatement, 0, delimiter, options);
                }
            }
            if ((placeHolder = CodeGeneration.getMethodBodyContent(unit, type, binding.getName(), false, bodyStatement, delimiter)) != null) {
                ReturnStatement todoNode = (ReturnStatement)rewrite.createStringPlaceholder(placeHolder, 41);
                body.statements().add(todoNode);
            }
        }
        if (settings != null && settings.createComments && (string = CodeGeneration.getMethodComment(unit, type, decl, binding, delimiter)) != null) {
            Javadoc javadoc = (Javadoc)rewrite.createStringPlaceholder(string, 29);
            decl.setJavadoc(javadoc);
        }
        boolean bl = skipOverride = inInterface && declaringType == typeObject && !Modifier.isPublic((int)modifiers);
        if (!skipOverride) {
            StubUtility2Core.addOverrideAnnotation(settings, javaProject, rewrite, imports, decl, binding.getDeclaringClass().isInterface(), null);
        }
        return decl;
    }

    public static MethodDeclaration createConstructorStub(ICompilationUnit unit, ASTRewrite rewrite, ImportRewrite imports, ImportRewrite.ImportRewriteContext context, IMethodBinding binding, String type, int modifiers, boolean omitSuperForDefConst, boolean todo, CodeGenerationSettings settings) throws CoreException {
        return StubUtility2Core.createConstructorStub(unit, rewrite, imports, context, binding, type, modifiers, omitSuperForDefConst, todo, settings, FormatterProfileManagerCore.getProjectSettings(unit.getJavaProject()));
    }

    public static MethodDeclaration createConstructorStub(ICompilationUnit unit, ASTRewrite rewrite, ImportRewrite imports, ImportRewrite.ImportRewriteContext context, IMethodBinding binding, String type, int modifiers, boolean omitSuperForDefConst, boolean todo, CodeGenerationSettings settings, Map<String, String> formatSettings) throws CoreException {
        String string;
        AST ast = rewrite.getAST();
        MethodDeclaration decl = ast.newMethodDeclaration();
        decl.modifiers().addAll(ASTNodeFactory.newModifiers(ast, modifiers & 0xFFFFFBFF & 0xFFFFFEFF));
        decl.setName(ast.newSimpleName(type));
        decl.setConstructor(true);
        StubUtility2Core.createTypeParameters(imports, context, ast, binding, decl);
        List<SingleVariableDeclaration> parameters = StubUtility2Core.createParameters(unit.getJavaProject(), imports, context, ast, binding, null, decl);
        StubUtility2Core.createThrownExceptions(decl, binding, imports, context, ast);
        Block body = ast.newBlock();
        decl.setBody(body);
        String delimiter = StubUtility.getLineDelimiterUsed((IJavaElement)unit);
        String bodyStatement = "";
        if (!omitSuperForDefConst || !parameters.isEmpty()) {
            SuperConstructorInvocation invocation = ast.newSuperConstructorInvocation();
            SingleVariableDeclaration varDecl2 = null;
            for (SingleVariableDeclaration varDecl2 : parameters) {
                invocation.arguments().add(ast.newSimpleName(varDecl2.getName().getIdentifier()));
            }
            bodyStatement = ASTNodes.asFormattedString((ASTNode)invocation, 0, delimiter, formatSettings == null ? unit.getOptions(true) : formatSettings);
        }
        if (todo) {
            String placeHolder = CodeGeneration.getMethodBodyContent(unit, type, binding.getName(), true, bodyStatement, delimiter);
            if (placeHolder != null) {
                ReturnStatement todoNode = (ReturnStatement)rewrite.createStringPlaceholder(placeHolder, 41);
                body.statements().add(todoNode);
            }
        } else {
            ReturnStatement statementNode = (ReturnStatement)rewrite.createStringPlaceholder(bodyStatement, 41);
            body.statements().add(statementNode);
        }
        if (settings != null && settings.createComments && (string = CodeGeneration.getMethodComment(unit, type, decl, binding, delimiter)) != null) {
            Javadoc javadoc = (Javadoc)rewrite.createStringPlaceholder(string, 29);
            decl.setJavadoc(javadoc);
        }
        return decl;
    }

    public static MethodDeclaration createConstructorStub(ICompilationUnit unit, ASTRewrite rewrite, ImportRewrite imports, ImportRewrite.ImportRewriteContext context, ITypeBinding typeBinding, IMethodBinding superConstructor, IVariableBinding[] variableBindings, int modifiers, CodeGenerationSettings settings) throws CoreException {
        String string;
        IVariableBinding variableBinding;
        AST ast = rewrite.getAST();
        MethodDeclaration decl = ast.newMethodDeclaration();
        decl.modifiers().addAll(ASTNodeFactory.newModifiers(ast, modifiers & 0xFFFFFBFF & 0xFFFFFEFF));
        decl.setName(ast.newSimpleName(typeBinding.getName()));
        decl.setConstructor(true);
        List parameters = decl.parameters();
        if (superConstructor != null) {
            StubUtility2Core.createTypeParameters(imports, context, ast, superConstructor, decl);
            StubUtility2Core.createParameters(unit.getJavaProject(), imports, context, ast, superConstructor, null, decl);
            StubUtility2Core.createThrownExceptions(decl, superConstructor, imports, context, ast);
        }
        Block body = ast.newBlock();
        decl.setBody(body);
        String delimiter = StubUtility.getLineDelimiterUsed((IJavaElement)unit);
        if (superConstructor != null) {
            SuperConstructorInvocation invocation = ast.newSuperConstructorInvocation();
            SingleVariableDeclaration varDecl2 = null;
            for (SingleVariableDeclaration varDecl2 : parameters) {
                invocation.arguments().add(ast.newSimpleName(varDecl2.getName().getIdentifier()));
            }
            body.statements().add(invocation);
        }
        ArrayList<String> prohibited = new ArrayList<String>();
        for (SingleVariableDeclaration singleVariableDeclaration : parameters) {
            prohibited.add(singleVariableDeclaration.getName().getIdentifier());
        }
        String param = null;
        ArrayList<String> list = new ArrayList<String>(prohibited);
        String[] excluded = null;
        IVariableBinding[] iVariableBindingArray = variableBindings;
        int n = variableBindings.length;
        int n2 = 0;
        while (n2 < n) {
            variableBinding = iVariableBindingArray[n2];
            SingleVariableDeclaration var = ast.newSingleVariableDeclaration();
            var.setType(imports.addImport(variableBinding.getType(), ast, context, ImportRewrite.TypeLocation.PARAMETER));
            excluded = new String[list.size()];
            list.toArray(excluded);
            param = StubUtility2Core.suggestParameterName(unit, variableBinding, excluded);
            list.add(param);
            var.setName(ast.newSimpleName(param));
            parameters.add(var);
            ++n2;
        }
        list = new ArrayList(prohibited);
        iVariableBindingArray = variableBindings;
        n = variableBindings.length;
        n2 = 0;
        while (n2 < n) {
            variableBinding = iVariableBindingArray[n2];
            excluded = new String[list.size()];
            list.toArray(excluded);
            String paramName = StubUtility2Core.suggestParameterName(unit, variableBinding, excluded);
            list.add(paramName);
            String fieldName = variableBinding.getName();
            SimpleName expression = null;
            if (paramName.equals(fieldName) || settings.useKeywordThis) {
                FieldAccess access = ast.newFieldAccess();
                access.setExpression((Expression)ast.newThisExpression());
                access.setName(ast.newSimpleName(fieldName));
                expression = access;
            } else {
                expression = ast.newSimpleName(fieldName);
            }
            Assignment assignment = ast.newAssignment();
            assignment.setLeftHandSide((Expression)expression);
            assignment.setRightHandSide((Expression)ast.newSimpleName(paramName));
            assignment.setOperator(Assignment.Operator.ASSIGN);
            body.statements().add(ast.newExpressionStatement((Expression)assignment));
            ++n2;
        }
        if (settings != null && settings.createComments && (string = CodeGeneration.getMethodComment(unit, typeBinding.getName(), decl, superConstructor, delimiter)) != null) {
            Javadoc javadoc = (Javadoc)rewrite.createStringPlaceholder(string, 29);
            decl.setJavadoc(javadoc);
        }
        return decl;
    }

    public static MethodDeclaration createDelegationStub(ICompilationUnit unit, ASTRewrite rewrite, ImportRewrite imports, ImportRewrite.ImportRewriteContext context, IMethodBinding delegate, IVariableBinding delegatingField, CodeGenerationSettings settings) throws CoreException {
        Assert.isNotNull((Object)delegate);
        Assert.isNotNull((Object)delegatingField);
        Assert.isNotNull((Object)settings);
        AST ast = rewrite.getAST();
        MethodDeclaration decl = ast.newMethodDeclaration();
        decl.modifiers().addAll(ASTNodeFactory.newModifiers(ast, delegate.getModifiers() & 0xFFFEFFFF & 0xFFFFFFDF & 0xFFFFFBFF & 0xFFFFFEFF));
        decl.setName(ast.newSimpleName(delegate.getName()));
        decl.setConstructor(false);
        StubUtility2Core.createTypeParameters(imports, context, ast, delegate, decl);
        decl.setReturnType2(imports.addImport(delegate.getReturnType(), ast, context, ImportRewrite.TypeLocation.RETURN_TYPE));
        List<SingleVariableDeclaration> params = StubUtility2Core.createParameters(unit.getJavaProject(), imports, context, ast, delegate, null, decl);
        StubUtility2Core.createThrownExceptions(decl, delegate, imports, context, ast);
        Block body = ast.newBlock();
        decl.setBody(body);
        String delimiter = StubUtility.getLineDelimiterUsed((IJavaElement)unit);
        ReturnStatement statement = null;
        MethodInvocation invocation = ast.newMethodInvocation();
        invocation.setName(ast.newSimpleName(delegate.getName()));
        List arguments = invocation.arguments();
        for (SingleVariableDeclaration param : params) {
            arguments.add(ast.newSimpleName(param.getName().getIdentifier()));
        }
        if (settings.useKeywordThis) {
            FieldAccess access = ast.newFieldAccess();
            access.setExpression((Expression)ast.newThisExpression());
            access.setName(ast.newSimpleName(delegatingField.getName()));
            invocation.setExpression((Expression)access);
        } else {
            invocation.setExpression((Expression)ast.newSimpleName(delegatingField.getName()));
        }
        if (delegate.getReturnType().isPrimitive() && "void".equals(delegate.getReturnType().getName())) {
            statement = ast.newExpressionStatement((Expression)invocation);
        } else {
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression((Expression)invocation);
            statement = returnStatement;
        }
        body.statements().add(statement);
        ITypeBinding declaringType = delegatingField.getDeclaringClass();
        if (declaringType == null) {
            return decl;
        }
        String qualifiedName = declaringType.getQualifiedName();
        IPackageBinding packageBinding = declaringType.getPackage();
        if (packageBinding != null && packageBinding.getName().length() > 0 && qualifiedName.startsWith(packageBinding.getName())) {
            qualifiedName = qualifiedName.substring(packageBinding.getName().length());
        }
        if (settings.createComments) {
            delegate = delegate.getMethodDeclaration();
            String declaringClassQualifiedName = delegate.getDeclaringClass().getQualifiedName();
            String linkToMethodName = delegate.getName();
            String[] parameterTypesQualifiedNames = StubUtility.getParameterTypeNamesForSeeTag(delegate);
            String string = StubUtility.getMethodComment(unit, qualifiedName, decl, delegate.isDeprecated(), linkToMethodName, declaringClassQualifiedName, parameterTypesQualifiedNames, true, delimiter);
            if (string != null) {
                Javadoc javadoc = (Javadoc)rewrite.createStringPlaceholder(string, 29);
                decl.setJavadoc(javadoc);
            }
        }
        return decl;
    }

    public static MethodDeclaration createImplementationStubCore(ICompilationUnit unit, ASTRewrite rewrite, ImportRewrite imports, ImportRewrite.ImportRewriteContext context, IMethodBinding binding, ITypeBinding targetType, CodeGenerationSettings settings, boolean inInterface, ASTNode astNode, boolean snippetStringSupport) throws CoreException {
        return StubUtility2Core.createImplementationStubCore(unit, rewrite, imports, context, binding, null, targetType, settings, inInterface, astNode, snippetStringSupport);
    }

    public static MethodDeclaration createImplementationStubCore(ICompilationUnit unit, ASTRewrite rewrite, ImportRewrite imports, ImportRewrite.ImportRewriteContext context, IMethodBinding binding, String[] parameterNames, ITypeBinding targetType, CodeGenerationSettings settings, boolean inInterface, ASTNode astNode, boolean snippetStringSupport) throws CoreException {
        return StubUtility2Core.createImplementationStubCore(unit, rewrite, imports, context, binding, parameterNames, targetType, settings, inInterface, false, astNode, snippetStringSupport);
    }

    public static MethodDeclaration createImplementationStubCore(ICompilationUnit unit, ASTRewrite rewrite, ImportRewrite imports, ImportRewrite.ImportRewriteContext context, IMethodBinding binding, String[] parameterNames, ITypeBinding targetType, CodeGenerationSettings settings, boolean inInterface, boolean useAlternativeMethodBody, ASTNode astNode, boolean snippetStringSupport) throws CoreException {
        boolean skipOverride;
        String string;
        Assert.isNotNull((Object)imports);
        Assert.isNotNull((Object)rewrite);
        AST ast = rewrite.getAST();
        String type = Bindings.getTypeQualifiedName(targetType);
        IJavaProject javaProject = unit.getJavaProject();
        EnumSet<ImportRewrite.TypeLocation> nullnessDefault = null;
        if (astNode != null && "enabled".equals(javaProject.getOption("org.eclipse.jdt.core.compiler.annotation.nullanalysis", true))) {
            nullnessDefault = RedundantNullnessTypeAnnotationsFilter.determineNonNullByDefaultLocations(astNode, RedundantNullnessTypeAnnotationsFilter.determineNonNullByDefaultNames(javaProject));
        }
        MethodDeclaration decl = ast.newMethodDeclaration();
        decl.modifiers().addAll(StubUtility2Core.getImplementationModifiers(ast, binding, inInterface, imports, context, nullnessDefault));
        decl.setName(ast.newSimpleName(binding.getName()));
        decl.setConstructor(false);
        ITypeBinding bindingReturnType = binding.getReturnType();
        bindingReturnType = StubUtility2Core.replaceWildcardsAndCaptures(bindingReturnType);
        StubUtility2Core.createTypeParameters(imports, context, ast, binding, decl);
        decl.setReturnType2(imports.addImport(bindingReturnType, ast, context, ImportRewrite.TypeLocation.RETURN_TYPE));
        List<SingleVariableDeclaration> parameters = StubUtility2Core.createParameters(javaProject, imports, context, ast, binding, parameterNames, decl, nullnessDefault);
        StubUtility2Core.createThrownExceptions(decl, binding, imports, context, ast);
        String delimiter = unit.findRecommendedLineSeparator();
        int modifiers = binding.getModifiers();
        ITypeBinding declaringType = binding.getDeclaringClass();
        ITypeBinding typeObject = ast.resolveWellKnownType("java.lang.Object");
        if (!inInterface || declaringType != typeObject) {
            Map options = unit.getOptions(true);
            Block body = ast.newBlock();
            decl.setBody(body);
            String bodyStatement = "";
            if (Modifier.isAbstract((int)modifiers)) {
                Expression expression = ASTNodeFactory.newDefaultExpression(ast, decl.getReturnType2(), bindingReturnType, decl.getExtraDimensions());
                if (expression != null) {
                    ReturnStatement returnStatement = ast.newReturnStatement();
                    returnStatement.setExpression(expression);
                    bodyStatement = ASTNodes.asFormattedString((ASTNode)returnStatement, 0, delimiter, options);
                }
            } else {
                SuperMethodInvocation invocation = ast.newSuperMethodInvocation();
                if (declaringType.isInterface()) {
                    ITypeBinding supertype = Bindings.findImmediateSuperTypeInHierarchy(targetType, declaringType.getTypeDeclaration().getQualifiedName());
                    if (supertype == null) {
                        supertype = declaringType;
                    }
                    if (supertype.isInterface()) {
                        String qualifier = imports.addImport(supertype.getTypeDeclaration(), context);
                        Name name = ASTNodeFactory.newName(ast, qualifier);
                        invocation.setQualifier(name);
                    }
                }
                invocation.setName(ast.newSimpleName(binding.getName()));
                for (SingleVariableDeclaration varDecl : parameters) {
                    invocation.arguments().add(ast.newSimpleName(varDecl.getName().getIdentifier()));
                }
                SuperMethodInvocation expression = invocation;
                Type returnType = decl.getReturnType2();
                if (returnType instanceof PrimitiveType && ((PrimitiveType)returnType).getPrimitiveTypeCode().equals(PrimitiveType.VOID)) {
                    bodyStatement = ASTNodes.asFormattedString((ASTNode)ast.newExpressionStatement((Expression)expression), 0, delimiter, options);
                } else {
                    ReturnStatement returnStatement = ast.newReturnStatement();
                    returnStatement.setExpression((Expression)expression);
                    bodyStatement = ASTNodes.asFormattedString((ASTNode)returnStatement, 0, delimiter, options);
                }
            }
            if (bodyStatement != null) {
                StringBuilder placeHolder = new StringBuilder();
                if (snippetStringSupport) {
                    String ESCAPE_DOLLAR = "\\\\\\$";
                    String DOLLAR = "\\$";
                    bodyStatement = bodyStatement.replaceAll("\\$", "\\\\\\$");
                }
                String bodyContent = CodeGeneration.getMethodBodyContent(unit, type, binding.getName(), false, useAlternativeMethodBody, bodyStatement, delimiter);
                if (snippetStringSupport) {
                    placeHolder.append("${0");
                    if (bodyContent != null) {
                        placeHolder.append(":");
                        placeHolder.append(bodyContent);
                    }
                    placeHolder.append("}");
                } else if (bodyContent != null) {
                    placeHolder.append(bodyContent);
                }
                if (bodyContent != null || snippetStringSupport) {
                    ReturnStatement todoNode = (ReturnStatement)rewrite.createStringPlaceholder(placeHolder.toString(), 41);
                    body.statements().add(todoNode);
                }
            }
        }
        if (settings != null && settings.createComments && (string = CodeGeneration.getMethodComment(unit, type, decl, binding, delimiter)) != null) {
            Javadoc javadoc = (Javadoc)rewrite.createStringPlaceholder(string, 29);
            decl.setJavadoc(javadoc);
        }
        boolean bl = skipOverride = inInterface && declaringType == typeObject && !Modifier.isPublic((int)modifiers);
        if (!skipOverride) {
            StubUtility2Core.addOverrideAnnotation(settings, javaProject, rewrite, imports, decl, binding.getDeclaringClass().isInterface(), null);
        }
        return decl;
    }

    public static void createTypeParameters(ImportRewrite imports, ImportRewrite.ImportRewriteContext context, AST ast, IMethodBinding binding, MethodDeclaration decl) {
        List typeParameters = decl.typeParameters();
        ITypeBinding[] iTypeBindingArray = binding.getTypeParameters();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding curr = iTypeBindingArray[n2];
            TypeParameter newTypeParam = ast.newTypeParameter();
            newTypeParam.setName(ast.newSimpleName(curr.getName()));
            ITypeBinding[] typeBounds = curr.getTypeBounds();
            if (typeBounds.length != 1 || !"java.lang.Object".equals(typeBounds[0].getQualifiedName())) {
                List newTypeBounds = newTypeParam.typeBounds();
                ITypeBinding[] iTypeBindingArray2 = typeBounds;
                int n3 = typeBounds.length;
                int n4 = 0;
                while (n4 < n3) {
                    ITypeBinding typeBound = iTypeBindingArray2[n4];
                    newTypeBounds.add(imports.addImport(typeBound, ast, context, ImportRewrite.TypeLocation.TYPE_BOUND));
                    ++n4;
                }
            }
            typeParameters.add(newTypeParam);
            ++n2;
        }
    }

    public static List<SingleVariableDeclaration> createParameters(IJavaProject project, ImportRewrite imports, ImportRewrite.ImportRewriteContext context, AST ast, IMethodBinding binding, String[] paramNames, MethodDeclaration decl) {
        return StubUtility2Core.createParameters(project, imports, context, ast, binding, paramNames, decl, null);
    }

    public static List<SingleVariableDeclaration> createParameters(IJavaProject project, ImportRewrite imports, ImportRewrite.ImportRewriteContext context, AST ast, IMethodBinding binding, String[] paramNames, MethodDeclaration decl, EnumSet<ImportRewrite.TypeLocation> nullnessDefault) {
        List parameters = decl.parameters();
        ITypeBinding[] params = binding.getParameterTypes();
        if (paramNames == null || paramNames.length < params.length) {
            paramNames = StubUtility.suggestArgumentNames(project, binding);
        }
        int i = 0;
        while (i < params.length) {
            IAnnotationBinding[] annotations;
            SingleVariableDeclaration var = ast.newSingleVariableDeclaration();
            ITypeBinding type = params[i];
            type = StubUtility2Core.replaceWildcardsAndCaptures(type);
            if (binding.isVarargs() && type.isArray() && i == params.length - 1) {
                var.setVarargs(true);
                int dimensions = type.getDimensions();
                List[] dimensionAnnotations = new List[dimensions];
                int dim = 0;
                while (dim < dimensions) {
                    dimensionAnnotations[dim] = new ArrayList();
                    IAnnotationBinding[] iAnnotationBindingArray = type.getTypeAnnotations();
                    int n = iAnnotationBindingArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IAnnotationBinding annotation = iAnnotationBindingArray[n2];
                        dimensionAnnotations[dim].add(imports.addAnnotation(annotation, ast, context));
                        ++n2;
                    }
                    type = type.getComponentType();
                    ++dim;
                }
                Type elementType = imports.addImport(type, ast, context);
                if (dimensions == 1) {
                    var.setType(elementType);
                } else {
                    ArrayType arrayType = ast.newArrayType(elementType, dimensions - 1);
                    List dimensionNodes = arrayType.dimensions();
                    int dim2 = 0;
                    while (dim2 < dimensions - 1) {
                        Dimension dimension = (Dimension)dimensionNodes.get(dim2);
                        dimension.annotations().addAll(dimensionAnnotations[dim2]);
                        ++dim2;
                    }
                    var.setType((Type)arrayType);
                }
                List varargTypeAnnotations = dimensionAnnotations[dimensions - 1];
                var.varargsAnnotations().addAll(varargTypeAnnotations);
            } else {
                var.setType(imports.addImport(type, ast, context, ImportRewrite.TypeLocation.PARAMETER));
            }
            var.setName(ast.newSimpleName(paramNames[i]));
            IAnnotationBinding[] iAnnotationBindingArray = annotations = binding.getParameterAnnotations(i);
            int n = annotations.length;
            int n3 = 0;
            while (n3 < n) {
                IAnnotationBinding annotation = iAnnotationBindingArray[n3];
                if (StubUtility2Core.isCopyOnInheritAnnotation(annotation.getAnnotationType(), project, nullnessDefault, ImportRewrite.TypeLocation.PARAMETER)) {
                    var.modifiers().add(imports.addAnnotation(annotation, ast, context));
                }
                ++n3;
            }
            parameters.add(var);
            ++i;
        }
        return parameters;
    }

    public static void createThrownExceptions(MethodDeclaration decl, IMethodBinding method, ImportRewrite imports, ImportRewrite.ImportRewriteContext context, AST ast) {
        ITypeBinding[] excTypes = method.getExceptionTypes();
        if (ast.apiLevel() >= 8) {
            List thrownExceptions = decl.thrownExceptionTypes();
            ITypeBinding[] iTypeBindingArray = excTypes;
            int n = excTypes.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding t = iTypeBindingArray[n2];
                Type excType = imports.addImport(t, ast, context, ImportRewrite.TypeLocation.EXCEPTION);
                thrownExceptions.add(excType);
                ++n2;
            }
        } else {
            List<Name> thrownExceptions = StubUtility2Core.getThrownExceptions(decl);
            ITypeBinding[] iTypeBindingArray = excTypes;
            int n = excTypes.length;
            int n3 = 0;
            while (n3 < n) {
                ITypeBinding excType = iTypeBindingArray[n3];
                String excTypeName = imports.addImport(excType, context);
                thrownExceptions.add(ASTNodeFactory.newName(ast, excTypeName));
                ++n3;
            }
        }
    }

    @Deprecated
    private static List<Name> getThrownExceptions(MethodDeclaration decl) {
        return decl.thrownExceptions();
    }

    private static IMethodBinding findOverridingMethod(IMethodBinding method, List<IMethodBinding> allMethods) {
        for (IMethodBinding curr : allMethods) {
            if (!Bindings.areOverriddenMethods(curr, method) && !Bindings.isSubsignature(curr, method)) continue;
            return curr;
        }
        return null;
    }

    public static List<IExtendedModifier> getImplementationModifiers(AST ast, IMethodBinding method, boolean inInterface, ImportRewrite importRewrite, ImportRewrite.ImportRewriteContext context, EnumSet<ImportRewrite.TypeLocation> nullnessDefault) throws JavaModelException {
        IMethod iMethod;
        IJavaProject javaProject = importRewrite.getCompilationUnit().getJavaProject();
        int modifiers = method.getModifiers();
        if (inInterface) {
            if (Modifier.isAbstract((int)(modifiers = modifiers & 0xFFFFFFFB & 0xFFFFFFFE))) {
                modifiers |= 0x10000;
            }
        } else {
            modifiers &= 0xFFFEFFFF;
        }
        modifiers = modifiers & 0xFFFFFBFF & 0xFFFFFEFF & 0xFFFFFFFD;
        IAnnotationBinding[] annotations = method.getAnnotations();
        if (modifiers != 0 && annotations.length > 0 && (iMethod = (IMethod)method.getJavaElement()) != null && JavaElementUtil.isSourceAvailable((ISourceReference)iMethod)) {
            ASTParser parser = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
            parser.setSource(iMethod.getTypeRoot());
            parser.setIgnoreMethodBodies(true);
            CompilationUnit otherCU = (CompilationUnit)parser.createAST(null);
            ASTNode otherMethod = NodeFinder.perform((ASTNode)otherCU, (ISourceRange)iMethod.getSourceRange());
            if (otherMethod instanceof MethodDeclaration) {
                MethodDeclaration otherMD = (MethodDeclaration)otherMethod;
                ArrayList<IExtendedModifier> result = new ArrayList<IExtendedModifier>();
                List otherModifiers = otherMD.modifiers();
                block0: for (IExtendedModifier otherModifier : otherModifiers) {
                    if (otherModifier instanceof Modifier) {
                        int otherFlag = ((Modifier)otherModifier).getKeyword().toFlagValue();
                        if ((otherFlag & modifiers) == 0) continue;
                        modifiers = ~otherFlag & modifiers;
                        result.addAll(ast.newModifiers(otherFlag));
                        continue;
                    }
                    Annotation otherAnnotation = (Annotation)otherModifier;
                    String n = otherAnnotation.getTypeName().getFullyQualifiedName();
                    IAnnotationBinding[] iAnnotationBindingArray = annotations;
                    int n2 = annotations.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        IAnnotationBinding annotation = iAnnotationBindingArray[n3];
                        ITypeBinding otherAnnotationType = annotation.getAnnotationType();
                        String qn = otherAnnotationType.getQualifiedName();
                        if (qn.endsWith(n) && (qn.length() == n.length() || qn.charAt(qn.length() - n.length() - 1) == '.')) {
                            if (!StubUtility2Core.isCopyOnInheritAnnotation(otherAnnotationType, javaProject, nullnessDefault, ImportRewrite.TypeLocation.RETURN_TYPE)) continue block0;
                            result.add((IExtendedModifier)importRewrite.addAnnotation(annotation, ast, context));
                            continue block0;
                        }
                        ++n3;
                    }
                }
                result.addAll(ASTNodeFactory.newModifiers(ast, modifiers));
                return result;
            }
        }
        ArrayList<IExtendedModifier> result = new ArrayList<IExtendedModifier>();
        IAnnotationBinding[] iAnnotationBindingArray = annotations;
        int n = annotations.length;
        int n4 = 0;
        while (n4 < n) {
            IAnnotationBinding annotation = iAnnotationBindingArray[n4];
            if (StubUtility2Core.isCopyOnInheritAnnotation(annotation.getAnnotationType(), javaProject, nullnessDefault, ImportRewrite.TypeLocation.RETURN_TYPE)) {
                result.add((IExtendedModifier)importRewrite.addAnnotation(annotation, ast, context));
            }
            ++n4;
        }
        result.addAll(ASTNodeFactory.newModifiers(ast, modifiers));
        return result;
    }

    public static AddDelegateMethodsOperation.DelegateEntry[] getDelegatableMethods(ITypeBinding binding) {
        IMethodBinding[] typeMethods;
        ArrayList<AddDelegateMethodsOperation.DelegateEntry> tuples = new ArrayList<AddDelegateMethodsOperation.DelegateEntry>();
        ArrayList<IMethodBinding> declared = new ArrayList<IMethodBinding>();
        IMethodBinding[] iMethodBindingArray = typeMethods = binding.getDeclaredMethods();
        int n = typeMethods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding typeMethod = iMethodBindingArray[n2];
            if (!typeMethod.isSyntheticRecordMethod()) {
                declared.add(typeMethod);
            }
            ++n2;
        }
        iMethodBindingArray = binding.getDeclaredFields();
        n = iMethodBindingArray.length;
        n2 = 0;
        while (n2 < n) {
            IMethodBinding fieldBinding = iMethodBindingArray[n2];
            if (fieldBinding.isField() && !fieldBinding.isEnumConstant() && !fieldBinding.isSynthetic()) {
                StubUtility2Core.getDelegatableMethods(new ArrayList<IMethodBinding>(declared), (IVariableBinding)fieldBinding, fieldBinding.getType(), binding, tuples);
            }
            ++n2;
        }
        return tuples.toArray(new AddDelegateMethodsOperation.DelegateEntry[tuples.size()]);
    }

    private static void getDelegatableMethods(List<IMethodBinding> methods, IVariableBinding fieldBinding, ITypeBinding typeBinding, ITypeBinding binding, List<AddDelegateMethodsOperation.DelegateEntry> result) {
        block9: {
            boolean match;
            block7: {
                block8: {
                    match = false;
                    if (!typeBinding.isTypeVariable()) break block7;
                    ITypeBinding[] typeBounds = typeBinding.getTypeBounds();
                    if (typeBounds.length <= 0) break block8;
                    ITypeBinding[] iTypeBindingArray = typeBounds;
                    int n = typeBounds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITypeBinding typeBound = iTypeBindingArray[n2];
                        StubUtility2Core.getDelegatableMethods(methods, fieldBinding, typeBound, binding, result);
                        ++n2;
                    }
                    break block9;
                }
                ITypeBinding objectBinding = Bindings.findTypeInHierarchy(binding, "java.lang.Object");
                if (objectBinding == null) break block9;
                StubUtility2Core.getDelegatableMethods(methods, fieldBinding, objectBinding, binding, result);
                break block9;
            }
            IMethodBinding[] iMethodBindingArray = StubUtility2Core.getDelegateCandidates(typeBinding, binding);
            int n = iMethodBindingArray.length;
            int objectBinding = 0;
            while (objectBinding < n) {
                IMethodBinding candidate = iMethodBindingArray[objectBinding];
                match = false;
                IMethodBinding methodBinding = candidate;
                int offset = 0;
                while (offset < methods.size() && !match) {
                    if (Bindings.areOverriddenMethods(methods.get(offset), methodBinding)) {
                        match = true;
                    }
                    ++offset;
                }
                if (!match) {
                    result.add(new AddDelegateMethodsOperation.DelegateEntry(methodBinding, fieldBinding));
                    methods.add(methodBinding);
                }
                ++objectBinding;
            }
            ITypeBinding superclass = typeBinding.getSuperclass();
            if (superclass != null) {
                StubUtility2Core.getDelegatableMethods(methods, fieldBinding, superclass, binding, result);
            }
            ITypeBinding[] iTypeBindingArray = typeBinding.getInterfaces();
            int n3 = iTypeBindingArray.length;
            n = 0;
            while (n < n3) {
                ITypeBinding superInterface = iTypeBindingArray[n];
                StubUtility2Core.getDelegatableMethods(methods, fieldBinding, superInterface, binding, result);
                ++n;
            }
        }
    }

    private static IMethodBinding[] getDelegateCandidates(ITypeBinding binding, ITypeBinding hierarchy) {
        ArrayList<IMethodBinding> allMethods = new ArrayList<IMethodBinding>();
        boolean isInterface = binding.isInterface();
        IMethodBinding[] iMethodBindingArray = binding.getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding result;
            IMethodBinding typeMethod = iMethodBindingArray[n2];
            int modifiers = typeMethod.getModifiers();
            if (!(typeMethod.isConstructor() || Modifier.isStatic((int)modifiers) || !isInterface && !Modifier.isPublic((int)modifiers) || (result = Bindings.findOverriddenMethodInHierarchy(hierarchy, typeMethod)) != null && Flags.isFinal((int)result.getModifiers()) && !result.isSyntheticRecordMethod())) {
                ITypeBinding[] parameterBindings = typeMethod.getParameterTypes();
                boolean upper = false;
                ITypeBinding[] iTypeBindingArray = parameterBindings;
                int n3 = parameterBindings.length;
                int n4 = 0;
                while (n4 < n3) {
                    ITypeBinding parameterBinding = iTypeBindingArray[n4];
                    if (parameterBinding.isWildcardType() && parameterBinding.isUpperbound()) {
                        upper = true;
                    }
                    ++n4;
                }
                if (!upper) {
                    allMethods.add(typeMethod);
                }
            }
            ++n2;
        }
        return allMethods.toArray(new IMethodBinding[allMethods.size()]);
    }

    public static IMethodBinding[] getOverridableMethods(AST ast, ITypeBinding typeBinding, boolean isSubType) {
        IMethodBinding[] typeMethods;
        ArrayList<IMethodBinding> allMethods = new ArrayList<IMethodBinding>();
        IMethodBinding[] iMethodBindingArray = typeMethods = typeBinding.getDeclaredMethods();
        int n = typeMethods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding typeMethod = iMethodBindingArray[n2];
            int modifiers = typeMethod.getModifiers();
            if (!(typeMethod.isConstructor() || Modifier.isStatic((int)modifiers) || Modifier.isPrivate((int)modifiers) || typeMethod.isSyntheticRecordMethod())) {
                allMethods.add(typeMethod);
            }
            ++n2;
        }
        ITypeBinding clazz = typeBinding.getSuperclass();
        while (clazz != null) {
            IMethodBinding[] iMethodBindingArray2 = clazz.getDeclaredMethods();
            int n3 = iMethodBindingArray2.length;
            n = 0;
            while (n < n3) {
                IMethodBinding method = iMethodBindingArray2[n];
                int modifiers = method.getModifiers();
                if (!(method.isConstructor() || Modifier.isStatic((int)modifiers) || Modifier.isPrivate((int)modifiers) || StubUtility2Core.findOverridingMethod(method, allMethods) != null)) {
                    allMethods.add(method);
                }
                ++n;
            }
            clazz = clazz.getSuperclass();
        }
        clazz = typeBinding;
        while (clazz != null) {
            ITypeBinding[] iTypeBindingArray = clazz.getInterfaces();
            int n4 = iTypeBindingArray.length;
            n = 0;
            while (n < n4) {
                ITypeBinding superInterface = iTypeBindingArray[n];
                StubUtility2Core.getOverridableMethods(ast, superInterface, allMethods);
                ++n;
            }
            clazz = clazz.getSuperclass();
        }
        if (typeBinding.isInterface()) {
            StubUtility2Core.getOverridableMethods(ast, ast.resolveWellKnownType("java.lang.Object"), allMethods);
        }
        if (!isSubType) {
            allMethods.removeAll(Arrays.asList(typeMethods));
        }
        int index = allMethods.size() - 1;
        while (index >= 0) {
            IMethodBinding method = (IMethodBinding)allMethods.get(index);
            if (Modifier.isFinal((int)method.getModifiers())) {
                allMethods.remove(index);
            }
            --index;
        }
        return allMethods.toArray(new IMethodBinding[allMethods.size()]);
    }

    private static void getOverridableMethods(AST ast, ITypeBinding superBinding, List<IMethodBinding> allMethods) {
        IMethodBinding[] iMethodBindingArray = superBinding.getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding method = iMethodBindingArray[n2];
            int modifiers = method.getModifiers();
            if (!(method.isConstructor() || Modifier.isStatic((int)modifiers) || Modifier.isPrivate((int)modifiers) || StubUtility2Core.findOverridingMethod(method, allMethods) != null)) {
                allMethods.add(method);
            }
            ++n2;
        }
        iMethodBindingArray = superBinding.getInterfaces();
        n = iMethodBindingArray.length;
        n2 = 0;
        while (n2 < n) {
            IMethodBinding superInterface = iMethodBindingArray[n2];
            StubUtility2Core.getOverridableMethods(ast, (ITypeBinding)superInterface, allMethods);
            ++n2;
        }
    }

    private static String suggestParameterName(ICompilationUnit unit, IVariableBinding binding, String[] excluded) {
        String name = StubUtility.getBaseName(binding, unit.getJavaProject());
        return StubUtility.suggestArgumentName(unit.getJavaProject(), name, excluded);
    }

    public static Collection<IMethodBinding> getMethodsIn(ITypeBinding type, Predicate<IMethodBinding> ignoreTheseMethods) {
        Collection[] interfaceMethods;
        IMethodBinding[] declaredMethods;
        if (type == null) {
            return Collections.EMPTY_LIST;
        }
        if (ignoreTheseMethods == null) {
            ignoreTheseMethods = m -> false;
        }
        ArrayList<IMethodBinding> allMethods = new ArrayList<IMethodBinding>();
        IMethodBinding[] iMethodBindingArray = declaredMethods = type.getDeclaredMethods();
        int n = declaredMethods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding method = iMethodBindingArray[n2];
            if (!(StubUtility2Core.isStatic(method) || method.isConstructor() || StubUtility2Core.isPrivate(method) || ignoreTheseMethods.test(method))) {
                allMethods.add(method);
            }
            ++n2;
        }
        ITypeBinding[] interfaces = type.getInterfaces();
        if (!type.isInterface()) {
            Collection<IMethodBinding> superMethods = StubUtility2Core.getMethodsIn(type.getSuperclass(), ignoreTheseMethods);
            interfaceMethods = new Collection[interfaces.length + 1];
            interfaceMethods[interfaceMethods.length - 1] = superMethods;
            for (IMethodBinding method : superMethods) {
                if (!StubUtility2Core.isConcrete(method) || !Bindings.isVisibleInHierarchy(method, type.getPackage()) || StubUtility2Core.findSubSignatureMethod(method, allMethods) != null) continue;
                allMethods.add(method);
            }
        } else {
            interfaceMethods = new Collection[interfaces.length];
        }
        int i = 0;
        while (i < interfaces.length) {
            interfaceMethods[i] = StubUtility2Core.getMethodsIn(interfaces[i], ignoreTheseMethods);
            ++i;
        }
        ArrayList<IMethodBinding> allInterfaceMethods = new ArrayList<IMethodBinding>();
        int i2 = 0;
        while (i2 < interfaceMethods.length) {
            for (IMethodBinding method : interfaceMethods[i2]) {
                if (!StubUtility2Core.isDefault(method) && !StubUtility2Core.isAbstract(method)) continue;
                IMethodBinding previouslyFound = StubUtility2Core.findSubSignatureMethod(method, allMethods);
                IMethodBinding overridingFound = StubUtility2Core.findOverridingMethod(method, allMethods);
                if (previouslyFound != null || overridingFound != null && StubUtility2Core.isConcrete(overridingFound)) continue;
                IMethodBinding subSigMethod = StubUtility2Core.findSubSignatureMethod(method, allInterfaceMethods);
                IMethodBinding superSigMethod = StubUtility2Core.findSuperSignatureMethod(method, allInterfaceMethods);
                if (superSigMethod != null && method.overrides(superSigMethod)) {
                    allInterfaceMethods.remove(subSigMethod);
                    allInterfaceMethods.add(method);
                    continue;
                }
                if (subSigMethod != null && superSigMethod != null) {
                    if (subSigMethod.getReturnType().getErasure().isSubTypeCompatible(method.getReturnType().getErasure())) continue;
                    allInterfaceMethods.remove(subSigMethod);
                    allInterfaceMethods.add(method);
                    continue;
                }
                if (superSigMethod != null) {
                    allInterfaceMethods.remove(superSigMethod);
                    allInterfaceMethods.add(method);
                    continue;
                }
                if (subSigMethod != null) continue;
                allInterfaceMethods.add(method);
            }
            ++i2;
        }
        allMethods.addAll(allInterfaceMethods);
        return allMethods;
    }

    private static IMethodBinding findSubSignatureMethod(IMethodBinding method, Collection<IMethodBinding> methods) {
        for (IMethodBinding candidate : methods) {
            if (!candidate.getName().equals(method.getName()) || !candidate.isSubsignature(method)) continue;
            return candidate;
        }
        return null;
    }

    private static IMethodBinding findSuperSignatureMethod(IMethodBinding method, Collection<IMethodBinding> methods) {
        for (IMethodBinding candidate : methods) {
            if (!candidate.getName().equals(method.getName()) || !method.isSubsignature(candidate)) continue;
            return candidate;
        }
        return null;
    }

    private static boolean isStatic(IMethodBinding method) {
        return Modifier.isStatic((int)method.getModifiers());
    }

    private static boolean isPrivate(IMethodBinding method) {
        return Modifier.isPrivate((int)method.getModifiers());
    }

    private static boolean isAbstract(IMethodBinding method) {
        return Modifier.isAbstract((int)method.getModifiers());
    }

    private static boolean isDefault(IMethodBinding method) {
        return Modifier.isDefault((int)method.getModifiers());
    }

    private static boolean isConcrete(IMethodBinding method) {
        return !StubUtility2Core.isAbstract(method) && !StubUtility2Core.isDefault(method);
    }

    public static Predicate<IMethodBinding> ignoreAbstractsOfInput(ITypeBinding type) {
        return m -> StubUtility2Core.isAbstract(m) && type == m.getDeclaringClass();
    }

    public static IMethodBinding[] getUnimplementedMethods(ITypeBinding typeBinding, Predicate<IMethodBinding> ignoreTheseMethods) {
        ArrayList<IMethodBinding> abstractMethods = new ArrayList<IMethodBinding>();
        for (IMethodBinding method : StubUtility2Core.getMethodsIn(typeBinding, ignoreTheseMethods)) {
            if (!StubUtility2Core.isAbstract(method)) continue;
            abstractMethods.add(method);
        }
        return abstractMethods.toArray(new IMethodBinding[abstractMethods.size()]);
    }

    public static IMethodBinding[] getVisibleConstructors(ITypeBinding binding, boolean accountExisting, boolean proposeDefault) {
        IMethodBinding method;
        int n;
        int n2;
        IMethodBinding[] iMethodBindingArray;
        IMethodBinding[] methods;
        ArrayList constructorMethods = new ArrayList();
        ArrayList<IMethodBinding> existingConstructors = null;
        ITypeBinding superType = binding.getSuperclass();
        if (superType == null) {
            return new IMethodBinding[0];
        }
        if (accountExisting) {
            methods = binding.getDeclaredMethods();
            existingConstructors = new ArrayList<IMethodBinding>(methods.length);
            iMethodBindingArray = methods;
            n2 = methods.length;
            n = 0;
            while (n < n2) {
                method = iMethodBindingArray[n];
                if (method.isConstructor() && !method.isDefaultConstructor()) {
                    existingConstructors.add(method);
                }
                ++n;
            }
        }
        if (existingConstructors != null) {
            constructorMethods.addAll(existingConstructors);
        }
        methods = binding.getDeclaredMethods();
        iMethodBindingArray = superType.getDeclaredMethods();
        n2 = iMethodBindingArray.length;
        n = 0;
        while (n < n2) {
            method = iMethodBindingArray[n];
            if (method.isConstructor() && Bindings.isVisibleInHierarchy(method, binding.getPackage()) && (!accountExisting || !Bindings.containsSignatureEquivalentConstructor(methods, method))) {
                constructorMethods.add(method);
            }
            ++n;
        }
        if (existingConstructors != null) {
            constructorMethods.removeAll(existingConstructors);
        }
        if (constructorMethods.isEmpty()) {
            superType = binding;
            while (superType.getSuperclass() != null) {
                superType = superType.getSuperclass();
            }
            method = Bindings.findMethodInType(superType, "Object", new ITypeBinding[0]);
            if (!(method == null || !proposeDefault && accountExisting && existingConstructors != null && !existingConstructors.isEmpty() || accountExisting && Bindings.containsSignatureEquivalentConstructor(methods, method))) {
                constructorMethods.add(method);
            }
        }
        return constructorMethods.toArray(new IMethodBinding[constructorMethods.size()]);
    }

    public static ASTNode getNodeToInsertBefore(ListRewrite listRewrite, IJavaElement sibling) throws JavaModelException {
        if (sibling instanceof IMember) {
            ISourceRange sourceRange = ((IMember)sibling).getSourceRange();
            if (sourceRange == null) {
                return null;
            }
            int insertPos = sourceRange.getOffset();
            for (ASTNode curr : listRewrite.getOriginalList()) {
                if (curr.getStartPosition() < insertPos) continue;
                return curr;
            }
        }
        return null;
    }

    public static void addOverrideAnnotation(CodeGenerationSettings settings, IJavaProject project, ASTRewrite rewrite, ImportRewrite imports, MethodDeclaration methodDecl, boolean isDeclaringTypeInterface, TextEditGroup group) {
        if (isDeclaringTypeInterface && "disabled".equals(project.getOption("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotationForInterfaceMethodImplementation", true))) {
            return;
        }
        if (settings != null && settings.overrideAnnotation || !"ignore".equals(project.getOption("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", true))) {
            StubUtility2Core.createOverrideAnnotation(rewrite, imports, methodDecl, group);
        }
    }

    public static void createOverrideAnnotation(ASTRewrite rewrite, ImportRewrite imports, MethodDeclaration decl, TextEditGroup group) {
        if (StubUtility2Core.findAnnotation("java.lang.Override", decl.modifiers()) != null) {
            return;
        }
        AST ast = rewrite.getAST();
        ASTNode root = decl.getRoot();
        ContextSensitiveImportRewriteContext context = null;
        if (root instanceof CompilationUnit) {
            context = new ContextSensitiveImportRewriteContext((CompilationUnit)root, decl.getStartPosition(), imports);
        }
        MarkerAnnotation marker = ast.newMarkerAnnotation();
        marker.setTypeName(ast.newName(imports.addImport("java.lang.Override", (ImportRewrite.ImportRewriteContext)context)));
        rewrite.getListRewrite((ASTNode)decl, MethodDeclaration.MODIFIERS2_PROPERTY).insertFirst((ASTNode)marker, group);
    }

    public static boolean isCopyOnInheritAnnotation(ITypeBinding annotationType, IJavaProject project, EnumSet<ImportRewrite.TypeLocation> nullnessDefault, ImportRewrite.TypeLocation typeLocation) {
        if ("enabled".equals(project.getOption("org.eclipse.jdt.core.compiler.annotation.inheritNullAnnotations", true))) {
            return false;
        }
        if (nullnessDefault != null && Bindings.isNonNullAnnotation(annotationType, project)) {
            return !nullnessDefault.contains(typeLocation);
        }
        return Bindings.isAnyNullAnnotation(annotationType, project);
    }

    public static Annotation findAnnotation(String qualifiedTypeName, List<IExtendedModifier> modifiers) {
        for (IExtendedModifier curr : modifiers) {
            Annotation annot;
            ITypeBinding binding;
            if (!(curr instanceof Annotation) || (binding = (annot = (Annotation)curr).getTypeName().resolveTypeBinding()) == null || !qualifiedTypeName.equals(binding.getQualifiedName())) continue;
            return annot;
        }
        return null;
    }

    public static ITypeBinding replaceWildcardsAndCaptures(ITypeBinding type) {
        while (type.isWildcardType() || type.isCapture() || type.isArray() && type.getElementType().isCapture()) {
            ITypeBinding bound = type.getBound();
            ITypeBinding iTypeBinding = type = bound != null ? bound : type.getErasure();
        }
        return type;
    }

    private StubUtility2Core() {
    }
}

