/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.validation;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;

public class DiagnosticUtil {
    private final Map<Integer, String> severityStrings = Map.of(0, "OK", 4, "ERROR", 2, "WARNING", 1, "INFO", 8, "CANCEL");

    public List<Diagnostic> flatten(Diagnostic diagnostic) {
        ArrayList<Diagnostic> flattened = new ArrayList<Diagnostic>();
        this.traverseDiagnostic(flattened, diagnostic);
        return flattened;
    }

    public Iterable<Diagnostic> errors(Diagnostic diagnostic) {
        return Iterables.filter(this.flatten(diagnostic), input -> input.getSeverity() == 4);
    }

    protected void traverseDiagnostic(List<Diagnostic> diagnostics, Diagnostic diagnostic) {
        if (diagnostic.getChildren().isEmpty()) {
            diagnostics.add(diagnostic);
        } else {
            for (Diagnostic diagnosticChild : diagnostic.getChildren()) {
                this.traverseDiagnostic(diagnostics, diagnosticChild);
            }
        }
    }

    public String format(Diagnostic d) {
        return this.severityStrings.get(d.getSeverity()) + ": " + d.getMessage();
    }
}

