/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.formatting;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.formatting.IWhitespaceInformationProvider;
import org.eclipse.xtext.formatting2.FormatterPreferenceKeys;
import org.eclipse.xtext.formatting2.FormatterPreferenceValuesProvider;
import org.eclipse.xtext.preferences.IPreferenceValues;
import org.eclipse.xtext.preferences.IPreferenceValuesProvider;
import org.eclipse.xtext.preferences.PreferenceKey;
import org.eclipse.xtext.xbase.formatting2.XbaseFormatterPreferenceKeys;

public class XcoreFormatterPreferenceValuesProvider
extends FormatterPreferenceValuesProvider {
    @Inject
    private IWhitespaceInformationProvider whitespaceInfo;
    @Inject
    private IPreferenceValuesProvider valuesProvider;

    public IPreferenceValues getPreferenceValues(Resource resource) {
        final IPreferenceValues preferenceValues = this.internalGetRawPreferenceValues(resource);
        URI uri = resource.getURI();
        final String indent = this.whitespaceInfo.getIndentationInformation(uri).getIndentString();
        final String lineSep = this.whitespaceInfo.getLineSeparatorInformation(uri).getLineSeparator();
        return new IPreferenceValues(){

            public String getPreference(PreferenceKey key) {
                if (key == XbaseFormatterPreferenceKeys.whitespaceBetweenKeywordAndParenthesisSL) {
                    return "true";
                }
                if (key == FormatterPreferenceKeys.indentation) {
                    return indent;
                }
                if (key == FormatterPreferenceKeys.lineSeparator) {
                    return lineSep;
                }
                return preferenceValues.getPreference(key);
            }
        };
    }

    protected IPreferenceValues internalGetRawPreferenceValues(Resource resource) {
        return this.valuesProvider.getPreferenceValues(resource);
    }
}

