/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.transfer.ui;

import org.eclipse.emf.cdo.transfer.CDOTransfer;
import org.eclipse.emf.cdo.transfer.CDOTransferMapping;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.ui.UIUtil;

public class TransferContentProvider
implements ITreeContentProvider,
IListener {
    private TreeViewer viewer;
    private CDOTransferMapping input;

    public void notifyEvent(IEvent event) {
        if (this.viewer == null) {
            return;
        }
        if (event instanceof CDOTransfer.MappingEvent) {
            CDOTransfer.MappingEvent e = (CDOTransfer.MappingEvent)event;
            CDOTransferMapping mapping = e.getMapping();
            if (e.hasTreeImpact()) {
                UIUtil.refreshElement((StructuredViewer)this.viewer, (Object)mapping, (boolean)true);
            } else {
                UIUtil.refreshElement((StructuredViewer)this.viewer, (Object)mapping, (boolean)true);
            }
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TreeViewer)viewer;
        if (this.input != null) {
            this.input.getTransfer().removeListener((IListener)this);
        }
        if (newInput instanceof CDOTransferMapping) {
            this.input = (CDOTransferMapping)newInput;
            this.input.getTransfer().addListener((IListener)this);
        } else if (newInput == null) {
            this.input = null;
        } else {
            throw new IllegalArgumentException("Not a transfer mapping: " + String.valueOf(newInput));
        }
    }

    public void dispose() {
        if (this.input != null) {
            this.input.getTransfer().removeListener((IListener)this);
            this.input = null;
        }
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length != 0;
    }

    public Object[] getChildren(Object element) {
        if (element instanceof CDOTransferMapping) {
            CDOTransferMapping mapping = (CDOTransferMapping)element;
            return mapping.getChildren();
        }
        return CDOTransferMapping.NO_CHILDREN;
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    public Object getParent(Object element) {
        if (element == this.input) {
            return null;
        }
        if (element instanceof CDOTransferMapping) {
            CDOTransferMapping mapping = (CDOTransferMapping)element;
            return mapping.getParent();
        }
        return null;
    }
}

