/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.impl;

import org.eclipse.emf.cdo.common.branch.CDOBranchRef;
import org.eclipse.emf.cdo.lm.Change;
import org.eclipse.emf.cdo.lm.Delivery;
import org.eclipse.emf.cdo.lm.Dependency;
import org.eclipse.emf.cdo.lm.Drop;
import org.eclipse.emf.cdo.lm.DropType;
import org.eclipse.emf.cdo.lm.Impact;
import org.eclipse.emf.cdo.lm.LMFactory;
import org.eclipse.emf.cdo.lm.LMPackage;
import org.eclipse.emf.cdo.lm.Module;
import org.eclipse.emf.cdo.lm.ModuleType;
import org.eclipse.emf.cdo.lm.Process;
import org.eclipse.emf.cdo.lm.Stream;
import org.eclipse.emf.cdo.lm.StreamMode;
import org.eclipse.emf.cdo.lm.System;
import org.eclipse.emf.cdo.lm.impl.ChangeImpl;
import org.eclipse.emf.cdo.lm.impl.DeliveryImpl;
import org.eclipse.emf.cdo.lm.impl.DependencyImpl;
import org.eclipse.emf.cdo.lm.impl.DropImpl;
import org.eclipse.emf.cdo.lm.impl.DropTypeImpl;
import org.eclipse.emf.cdo.lm.impl.ModuleImpl;
import org.eclipse.emf.cdo.lm.impl.ModuleTypeImpl;
import org.eclipse.emf.cdo.lm.impl.ProcessImpl;
import org.eclipse.emf.cdo.lm.impl.StreamImpl;
import org.eclipse.emf.cdo.lm.impl.SystemImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.net4j.util.StringUtil;

public class LMFactoryImpl
extends EFactoryImpl
implements LMFactory {
    public static LMFactory init() {
        try {
            LMFactory theLMFactory = (LMFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/emf/CDO/lm/1.0.0");
            if (theLMFactory != null) {
                return theLMFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new LMFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 4: {
                return this.createSystem();
            }
            case 5: {
                return this.createProcess();
            }
            case 6: {
                return this.createModuleType();
            }
            case 7: {
                return this.createDropType();
            }
            case 8: {
                return this.createModule();
            }
            case 12: {
                return this.createStream();
            }
            case 13: {
                return this.createChange();
            }
            case 14: {
                return this.createDelivery();
            }
            case 15: {
                return this.createDrop();
            }
            case 16: {
                return this.createDependency();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 17: {
                return this.createImpactFromString(eDataType, initialValue);
            }
            case 18: {
                return this.createStreamModeFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 17: {
                return this.convertImpactToString(eDataType, instanceValue);
            }
            case 18: {
                return this.convertStreamModeToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public System createSystem() {
        SystemImpl system = new SystemImpl();
        return system;
    }

    @Override
    public Process createProcess() {
        ProcessImpl process = new ProcessImpl();
        return process;
    }

    @Override
    public DropType createDropType() {
        DropTypeImpl dropType = new DropTypeImpl();
        return dropType;
    }

    @Override
    public DropType createDropType(String name, boolean release) {
        DropType dropType = this.createDropType();
        dropType.setName(name);
        dropType.setRelease(release);
        return dropType;
    }

    @Override
    public Module createModule() {
        ModuleImpl module = new ModuleImpl();
        return module;
    }

    @Override
    public Dependency createDependency() {
        DependencyImpl dependency = new DependencyImpl();
        return dependency;
    }

    @Override
    public ModuleType createModuleType() {
        ModuleTypeImpl moduleType = new ModuleTypeImpl();
        return moduleType;
    }

    @Override
    public ModuleType createModuleType(String name) {
        ModuleType moduleType = this.createModuleType();
        moduleType.setName(name);
        return moduleType;
    }

    @Override
    public Stream createStream() {
        StreamImpl stream = new StreamImpl();
        return stream;
    }

    @Override
    public Stream createStream(int majorVersion, int minorVersion, String codeName) {
        Stream stream = this.createStream();
        stream.setMajorVersion(majorVersion);
        stream.setMinorVersion(minorVersion);
        stream.setDevelopmentBranch(CDOBranchRef.MAIN);
        if (!StringUtil.isEmpty((String)codeName)) {
            stream.setCodeName(codeName);
        }
        return stream;
    }

    @Override
    public Change createChange() {
        ChangeImpl change = new ChangeImpl();
        return change;
    }

    @Override
    public Delivery createDelivery() {
        DeliveryImpl delivery = new DeliveryImpl();
        return delivery;
    }

    @Override
    public Drop createDrop() {
        DropImpl drop = new DropImpl();
        return drop;
    }

    public Impact createImpactFromString(EDataType eDataType, String initialValue) {
        if (initialValue == null) {
            return null;
        }
        Impact result = Impact.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertImpactToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public StreamMode createStreamModeFromString(EDataType eDataType, String initialValue) {
        if (initialValue == null) {
            return null;
        }
        StreamMode result = StreamMode.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertStreamModeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public LMPackage getLMPackage() {
        return (LMPackage)this.getEPackage();
    }

    @Deprecated
    public static LMPackage getPackage() {
        return LMPackage.eINSTANCE;
    }
}

