/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.Stack;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class SelectionHistory {
    private Stack<ISourceRange> fHistory;
    private CEditor fEditor;
    private ISelectionChangedListener fSelectionListener;
    private int fSelectionChangeListenerCounter;

    public SelectionHistory(CEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
        this.fHistory = new Stack();
        this.fSelectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (SelectionHistory.this.fSelectionChangeListenerCounter == 0) {
                    SelectionHistory.this.flush();
                }
            }
        };
        this.fEditor.getSelectionProvider().addSelectionChangedListener(this.fSelectionListener);
    }

    public boolean isEmpty() {
        return this.fHistory.isEmpty();
    }

    public void remember(ISourceRange range) {
        this.fHistory.push(range);
    }

    public ISourceRange getLast() {
        if (this.isEmpty()) {
            return null;
        }
        ISourceRange result = this.fHistory.pop();
        return result;
    }

    public void flush() {
        if (this.fHistory.isEmpty()) {
            return;
        }
        this.fHistory.clear();
    }

    public void ignoreSelectionChanges() {
        ++this.fSelectionChangeListenerCounter;
    }

    public void listenToSelectionChanges() {
        --this.fSelectionChangeListenerCounter;
    }

    public void dispose() {
        this.fEditor.getSelectionProvider().removeSelectionChangedListener(this.fSelectionListener);
    }
}

