/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.util.color;

import com.google.common.base.Preconditions;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;

public final class ColorUtils {
    private static final String DECORATIONS_COLOR = "DECORATIONS_COLOR";
    private static final String ERROR_COLOR = "ERROR_COLOR";

    private ColorUtils() {
    }

    public static Color getDecorationsColorFromCurrentTheme() {
        ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        return theme.getColorRegistry().get(DECORATIONS_COLOR);
    }

    public static ColorDescriptor getDecorationsColorDescriptorFromCurrentTheme() {
        ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        return (ColorDescriptor)Preconditions.checkNotNull((Object)theme.getColorRegistry().getColorDescriptor(DECORATIONS_COLOR));
    }

    public static ColorDescriptor getErrorColorDescriptorFromCurrentTheme() {
        ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        return (ColorDescriptor)Preconditions.checkNotNull((Object)theme.getColorRegistry().getColorDescriptor(ERROR_COLOR));
    }
}

