/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.nekohtml.sax;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codelibs.nekohtml.HTMLElements;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class HTMLTagBalancerFilter
extends XMLFilterImpl
implements LexicalHandler {
    private static final Logger logger = Logger.getLogger(HTMLTagBalancerFilter.class.getName());
    protected LexicalHandler lexicalHandler;
    protected final Stack<String> elementStack = new Stack();
    protected final LinkedList<String> activeFormattingElements = new LinkedList();
    protected static final String MARKER = new String("MARKER");
    protected boolean documentInitialized = false;
    protected static final Set<String> BODY_ELEMENTS = new HashSet<String>();
    protected static final Set<String> HEAD_ELEMENTS;
    protected static final Set<String> GENERIC_CONTAINERS;
    protected static final Set<String> VOID_ELEMENTS;

    public HTMLTagBalancerFilter() {
        this(null);
    }

    public HTMLTagBalancerFilter(XMLReader parent) {
        super(parent);
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        super.setContentHandler(handler);
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this.lexicalHandler = handler;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (this.getContentHandler() != null) {
            this.getContentHandler().setDocumentLocator(locator);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Starting document - initializing tag balancer");
        }
        this.elementStack.clear();
        this.activeFormattingElements.clear();
        this.documentInitialized = false;
        if (this.getContentHandler() != null) {
            this.getContentHandler().startDocument();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Ending document - closing " + this.elementStack.size() + " remaining open elements");
        }
        while (!this.elementStack.isEmpty()) {
            String element = this.elementStack.pop();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Auto-closing unclosed element at document end: " + element);
            }
            if (this.getContentHandler() == null) continue;
            this.getContentHandler().endElement("", element, element);
        }
        if (this.getContentHandler() != null) {
            this.getContentHandler().endDocument();
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().startPrefixMapping(prefix, uri);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().endPrefixMapping(prefix);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        ContentHandler handler = this.getContentHandler();
        if (handler == null) {
            return;
        }
        String tagName = qName.toUpperCase();
        if ("HTML".equals(tagName)) {
            this.documentInitialized = true;
        } else {
            this.ensureDocumentInitialized();
        }
        if (BODY_ELEMENTS.contains(tagName)) {
            this.closeElement("HEAD");
            this.closeElement("TITLE");
        }
        handler.startElement(uri, localName, qName, atts);
        if (!VOID_ELEMENTS.contains(tagName)) {
            this.elementStack.push(tagName);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Pushed element onto stack: " + tagName + " (stack depth: " + this.elementStack.size() + ")");
            }
            if (HTMLElements.isFormattingElement(tagName)) {
                this.addFormattingElement(tagName);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Added formatting element: " + tagName);
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        ContentHandler handler = this.getContentHandler();
        if (handler == null) {
            return;
        }
        String tagName = qName.toUpperCase();
        boolean isFormatting = HTMLElements.isFormattingElement(tagName);
        if (isFormatting && this.findFormattingElement(tagName) >= 0) {
            this.runAdoptionAgencyAlgorithm(tagName, uri, localName, qName);
            return;
        }
        if (!this.elementStack.isEmpty()) {
            int index = this.elementStack.lastIndexOf(tagName);
            if (index >= 0) {
                int elementsToClose = this.elementStack.size() - index - 1;
                if (elementsToClose > 0 && logger.isLoggable(Level.FINER)) {
                    logger.finer("Auto-closing " + elementsToClose + " elements above " + tagName);
                }
                while (this.elementStack.size() > index + 1) {
                    String elem = this.elementStack.pop();
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Auto-closing element: " + elem);
                    }
                    this.removeFormattingElement(elem);
                    handler.endElement("", elem, elem);
                }
                this.elementStack.pop();
                this.removeFormattingElement(tagName);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Popped element from stack: " + tagName + " (stack depth: " + this.elementStack.size() + ")");
                }
                handler.endElement(uri, localName, qName);
            } else {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("End element not on stack (void or already closed): " + tagName);
                }
                handler.endElement(uri, localName, qName);
            }
        } else {
            handler.endElement(uri, localName, qName);
        }
    }

    protected void closeElement(String tagName) throws SAXException {
        ContentHandler handler = this.getContentHandler();
        if (handler == null || this.elementStack.isEmpty()) {
            return;
        }
        int index = this.elementStack.lastIndexOf(tagName);
        if (index >= 0) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Closing element and " + (this.elementStack.size() - index - 1) + " elements above it: " + tagName);
            }
            while (this.elementStack.size() > index) {
                String elem = this.elementStack.pop();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Auto-closing element: " + elem);
                }
                handler.endElement("", elem, elem);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.ensureDocumentInitialized();
        if (this.getContentHandler() != null) {
            this.getContentHandler().characters(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().processingInstruction(target, data);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().skippedEntity(name);
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startDTD(name, publicId, systemId);
        }
    }

    @Override
    public void endDTD() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endDTD();
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startEntity(name);
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endEntity(name);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startCDATA();
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endCDATA();
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        this.ensureDocumentInitialized();
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(ch, start, length);
        }
    }

    protected void ensureDocumentInitialized() throws SAXException {
        if (!this.documentInitialized) {
            this.documentInitialized = true;
            ContentHandler handler = this.getContentHandler();
            if (handler != null) {
                handler.startElement("", "HTML", "HTML", new AttributesImpl());
                this.elementStack.push("HTML");
            }
        }
    }

    protected void addFormattingElement(String tagName) {
        this.activeFormattingElements.remove(tagName);
        this.activeFormattingElements.add(tagName);
    }

    protected boolean removeFormattingElement(String tagName) {
        return this.activeFormattingElements.remove(tagName);
    }

    protected int findFormattingElement(String tagName) {
        for (int i = this.activeFormattingElements.size() - 1; i >= 0; --i) {
            String element = this.activeFormattingElements.get(i);
            if (tagName.equals(element)) {
                return i;
            }
            if (element == MARKER) break;
        }
        return -1;
    }

    protected void clearFormattingElementsToLastMarker() {
        String element;
        while (!this.activeFormattingElements.isEmpty() && (element = this.activeFormattingElements.removeLast()) != MARKER) {
        }
    }

    protected void pushFormattingMarker() {
        this.activeFormattingElements.add(MARKER);
    }

    protected boolean isSpecialElement(String tagName) {
        return "ADDRESS".equals(tagName) || "ARTICLE".equals(tagName) || "ASIDE".equals(tagName) || "BLOCKQUOTE".equals(tagName) || "DETAILS".equals(tagName) || "DIALOG".equals(tagName) || "DIV".equals(tagName) || "DL".equals(tagName) || "FIELDSET".equals(tagName) || "FIGCAPTION".equals(tagName) || "FIGURE".equals(tagName) || "FOOTER".equals(tagName) || "FORM".equals(tagName) || "H1".equals(tagName) || "H2".equals(tagName) || "H3".equals(tagName) || "H4".equals(tagName) || "H5".equals(tagName) || "H6".equals(tagName) || "HEADER".equals(tagName) || "HGROUP".equals(tagName) || "HR".equals(tagName) || "LI".equals(tagName) || "MAIN".equals(tagName) || "NAV".equals(tagName) || "OL".equals(tagName) || "P".equals(tagName) || "PRE".equals(tagName) || "SEARCH".equals(tagName) || "SECTION".equals(tagName) || "TABLE".equals(tagName) || "UL".equals(tagName);
    }

    protected int findFurthestBlock(int formattingIndex) {
        for (int i = formattingIndex + 1; i < this.elementStack.size(); ++i) {
            if (!this.isSpecialElement((String)this.elementStack.get(i))) continue;
            return i;
        }
        return -1;
    }

    protected void runAdoptionAgencyAlgorithm(String tagName, String uri, String localName, String qName) throws SAXException {
        int index;
        int outerLoop;
        ContentHandler handler = this.getContentHandler();
        if (handler == null) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Running Adoption Agency Algorithm for: " + tagName);
        }
        if ((outerLoop = 0) < 8) {
            int formattingElemIndexInList = this.findFormattingElement(tagName);
            if (formattingElemIndexInList < 0) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("AAA: Formatting element not in active list, using standard close");
                }
            } else {
                int formattingElemIndexInStack = this.elementStack.lastIndexOf(tagName);
                if (formattingElemIndexInStack < 0) {
                    this.activeFormattingElements.remove(formattingElemIndexInList);
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("AAA: Formatting element not in stack, removed from active list");
                    }
                    return;
                }
                int furthestBlockIndex = this.findFurthestBlock(formattingElemIndexInStack);
                if (furthestBlockIndex < 0) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("AAA: No furthest block, closing and reopening formatting elements");
                    }
                    ArrayList<String> elementsToReopen = new ArrayList<String>();
                    for (int i = formattingElemIndexInStack + 1; i < this.elementStack.size(); ++i) {
                        String elem = (String)this.elementStack.get(i);
                        if (!HTMLElements.isFormattingElement(elem)) continue;
                        elementsToReopen.add(elem);
                    }
                    while (this.elementStack.size() > formattingElemIndexInStack) {
                        String elem = this.elementStack.pop();
                        this.removeFormattingElement(elem);
                        handler.endElement("", elem, elem);
                        if (!elem.equals(tagName)) continue;
                        break;
                    }
                    for (String elem : elementsToReopen) {
                        this.elementStack.push(elem);
                        this.addFormattingElement(elem);
                        handler.startElement("", elem.toLowerCase(), elem, new AttributesImpl());
                    }
                    return;
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("AAA: Furthest block found at index " + furthestBlockIndex + ", reconstructing");
                }
                ArrayList<String> elementsToReopen = new ArrayList<String>();
                for (int i = formattingElemIndexInStack + 1; i < furthestBlockIndex; ++i) {
                    elementsToReopen.add((String)this.elementStack.get(i));
                }
                this.elementStack.remove(formattingElemIndexInStack);
                this.removeFormattingElement(tagName);
                handler.endElement(uri, localName, qName);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("AAA: Completed reconstruction for " + tagName);
                }
                return;
            }
        }
        if ((index = this.elementStack.lastIndexOf(tagName)) >= 0) {
            while (this.elementStack.size() > index) {
                String elem = this.elementStack.pop();
                this.removeFormattingElement(elem);
                handler.endElement("", elem, elem);
                if (!elem.equals(tagName)) continue;
                break;
            }
        }
    }

    static {
        BODY_ELEMENTS.add("BODY");
        BODY_ELEMENTS.add("FRAMESET");
        HEAD_ELEMENTS = new HashSet<String>();
        HEAD_ELEMENTS.add("TITLE");
        HEAD_ELEMENTS.add("META");
        HEAD_ELEMENTS.add("LINK");
        HEAD_ELEMENTS.add("STYLE");
        HEAD_ELEMENTS.add("SCRIPT");
        HEAD_ELEMENTS.add("BASE");
        GENERIC_CONTAINERS = new HashSet<String>();
        GENERIC_CONTAINERS.add("DIV");
        GENERIC_CONTAINERS.add("SPAN");
        GENERIC_CONTAINERS.add("P");
        GENERIC_CONTAINERS.add("BLOCKQUOTE");
        GENERIC_CONTAINERS.add("ADDRESS");
        GENERIC_CONTAINERS.add("PRE");
        GENERIC_CONTAINERS.add("ARTICLE");
        GENERIC_CONTAINERS.add("SECTION");
        GENERIC_CONTAINERS.add("NAV");
        GENERIC_CONTAINERS.add("HEADER");
        GENERIC_CONTAINERS.add("FOOTER");
        GENERIC_CONTAINERS.add("ASIDE");
        GENERIC_CONTAINERS.add("MAIN");
        GENERIC_CONTAINERS.add("SEARCH");
        GENERIC_CONTAINERS.add("LI");
        GENERIC_CONTAINERS.add("DD");
        GENERIC_CONTAINERS.add("DT");
        GENERIC_CONTAINERS.add("UL");
        GENERIC_CONTAINERS.add("OL");
        GENERIC_CONTAINERS.add("DL");
        GENERIC_CONTAINERS.add("MENU");
        GENERIC_CONTAINERS.add("TABLE");
        GENERIC_CONTAINERS.add("TBODY");
        GENERIC_CONTAINERS.add("THEAD");
        GENERIC_CONTAINERS.add("TFOOT");
        GENERIC_CONTAINERS.add("TR");
        GENERIC_CONTAINERS.add("TD");
        GENERIC_CONTAINERS.add("TH");
        GENERIC_CONTAINERS.add("CAPTION");
        GENERIC_CONTAINERS.add("COLGROUP");
        GENERIC_CONTAINERS.add("FORM");
        GENERIC_CONTAINERS.add("FIELDSET");
        GENERIC_CONTAINERS.add("LABEL");
        GENERIC_CONTAINERS.add("BUTTON");
        GENERIC_CONTAINERS.add("LEGEND");
        GENERIC_CONTAINERS.add("FIGURE");
        GENERIC_CONTAINERS.add("FIGCAPTION");
        GENERIC_CONTAINERS.add("DETAILS");
        GENERIC_CONTAINERS.add("SUMMARY");
        GENERIC_CONTAINERS.add("DIALOG");
        GENERIC_CONTAINERS.add("HGROUP");
        GENERIC_CONTAINERS.add("SLOT");
        GENERIC_CONTAINERS.add("CENTER");
        GENERIC_CONTAINERS.add("MARQUEE");
        GENERIC_CONTAINERS.add("NOSCRIPT");
        GENERIC_CONTAINERS.add("A");
        VOID_ELEMENTS = new HashSet<String>();
        VOID_ELEMENTS.add("AREA");
        VOID_ELEMENTS.add("BASE");
        VOID_ELEMENTS.add("BR");
        VOID_ELEMENTS.add("COL");
        VOID_ELEMENTS.add("EMBED");
        VOID_ELEMENTS.add("HR");
        VOID_ELEMENTS.add("IMG");
        VOID_ELEMENTS.add("INPUT");
        VOID_ELEMENTS.add("LINK");
        VOID_ELEMENTS.add("META");
        VOID_ELEMENTS.add("PARAM");
        VOID_ELEMENTS.add("SOURCE");
        VOID_ELEMENTS.add("TRACK");
        VOID_ELEMENTS.add("WBR");
    }
}

