/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.burningwave.core.Criteria;
import org.burningwave.core.assembler.StaticComponentContainer;

public abstract class CriteriaWithClassElementsSupplyingSupport<E, C extends CriteriaWithClassElementsSupplyingSupport<E, C, T>, T extends Criteria.TestContext<E, C>>
extends Criteria<E, C, T> {
    Map<Class<?>[], List<Class<?>>> uploadedClassesMap;
    List<Class<?>> classesToBeUploaded;
    Map<Class<?>, Class<?>> uploadedClasses;
    Function<Class<?>, Class<?>> classSupplier;
    Map<Class<?>[], List<ByteBuffer>> byteCodeForClasses = new ConcurrentHashMap<Class<?>[], List<ByteBuffer>>();
    Map<Class<?>, byte[]> loadedBytecode;
    Function<Class<?>, ByteBuffer> byteCodeSupplier;

    CriteriaWithClassElementsSupplyingSupport() {
    }

    C init(Function<Class<?>, Class<?>> classSupplier, Function<Class<?>, ByteBuffer> byteCodeSupplier) {
        if (classSupplier != null) {
            this.classSupplier = classSupplier;
            this.uploadedClassesMap = new HashMap();
        }
        if (byteCodeSupplier != null) {
            this.byteCodeSupplier = byteCodeSupplier;
            this.byteCodeForClasses = new HashMap<Class<?>[], List<ByteBuffer>>();
        }
        return (C)this;
    }

    @Override
    protected C logicOperation(C leftCriteria, C rightCriteria, Function<BiPredicate<T, E>, Function<BiPredicate<? super T, ? super E>, BiPredicate<T, E>>> binaryOperator, C targetCriteria) {
        CriteriaWithClassElementsSupplyingSupport newCriteria = (CriteriaWithClassElementsSupplyingSupport)super.logicOperation(leftCriteria, rightCriteria, binaryOperator, targetCriteria);
        if (((CriteriaWithClassElementsSupplyingSupport)leftCriteria).classesToBeUploaded != null) {
            newCriteria.useClasses(((CriteriaWithClassElementsSupplyingSupport)leftCriteria).classesToBeUploaded);
        }
        if (((CriteriaWithClassElementsSupplyingSupport)rightCriteria).classesToBeUploaded != null) {
            newCriteria.useClasses(((CriteriaWithClassElementsSupplyingSupport)rightCriteria).classesToBeUploaded);
        }
        return (C)newCriteria;
    }

    Function<Class<?>, Class<?>> getClassSupplier() {
        return this.classSupplier;
    }

    Function<Class<?>, ByteBuffer> getByteCodeSupplier() {
        return this.byteCodeSupplier;
    }

    Class<?> retrieveClass(Class<?> cls) {
        if (this.classSupplier != null) {
            return this.classSupplier.apply(cls);
        }
        return cls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Class<?>, Class<?>> getUploadedClasses() {
        if (this.uploadedClasses == null) {
            CriteriaWithClassElementsSupplyingSupport criteriaWithClassElementsSupplyingSupport = this;
            synchronized (criteriaWithClassElementsSupplyingSupport) {
                if (this.uploadedClasses == null) {
                    HashMap uploadedClasses = new HashMap();
                    for (Class<?> cls : this.classesToBeUploaded) {
                        uploadedClasses.put(cls, this.classSupplier.apply(cls));
                    }
                    this.uploadedClasses = uploadedClasses;
                }
            }
        }
        return this.uploadedClasses;
    }

    List<Class<?>> getClassesToBeUploaded() {
        return this.classesToBeUploaded;
    }

    public C useClasses(Class<?> ... classes) {
        if (this.classesToBeUploaded == null) {
            this.classesToBeUploaded = new CopyOnWriteArrayList();
        }
        for (Class<?> cls : classes) {
            this.classesToBeUploaded.add(cls);
        }
        return (C)this;
    }

    public C useClasses(Collection<Class<?>> classes) {
        if (this.classesToBeUploaded == null) {
            this.classesToBeUploaded = new CopyOnWriteArrayList();
        }
        this.classesToBeUploaded.addAll(classes);
        return (C)this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Class<?>> retrieveUploadedClasses(Class<?> ... classes) {
        List<Class<?>> uploadedClasses = this.uploadedClassesMap.get(classes);
        if (uploadedClasses == null) {
            Map<Class<?>[], List<Class<?>>> map = this.uploadedClassesMap;
            synchronized (map) {
                uploadedClasses = this.uploadedClassesMap.get(classes);
                if (uploadedClasses == null) {
                    uploadedClasses = new CopyOnWriteArrayList();
                    for (Class<?> element : classes) {
                        uploadedClasses.add(element.isPrimitive() ? element : this.classSupplier.apply(element));
                    }
                    this.uploadedClassesMap.put(classes, uploadedClasses);
                }
            }
        }
        return uploadedClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Class<?>, byte[]> getLoadedBytecode() {
        if (this.loadedBytecode == null) {
            CriteriaWithClassElementsSupplyingSupport criteriaWithClassElementsSupplyingSupport = this;
            synchronized (criteriaWithClassElementsSupplyingSupport) {
                HashMap loadedBytecode = new HashMap();
                for (Class<?> cls : this.classesToBeUploaded) {
                    loadedBytecode.put(cls, StaticComponentContainer.BufferHandler.toByteArray(this.byteCodeSupplier.apply(cls)));
                }
                this.loadedBytecode = loadedBytecode;
            }
        }
        return this.loadedBytecode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ByteBuffer> retrieveByteCode(C criteria, Class<?>[] classes) {
        List<ByteBuffer> byteCode = ((CriteriaWithClassElementsSupplyingSupport)criteria).byteCodeForClasses.get(classes);
        if (byteCode == null) {
            Map<Class<?>[], List<ByteBuffer>> map = ((CriteriaWithClassElementsSupplyingSupport)criteria).byteCodeForClasses;
            synchronized (map) {
                byteCode = ((CriteriaWithClassElementsSupplyingSupport)criteria).byteCodeForClasses.get(classes);
                if (byteCode == null) {
                    byteCode = new CopyOnWriteArrayList<ByteBuffer>();
                    for (Class<?> cls : classes) {
                        byteCode.add(this.byteCodeSupplier.apply(cls));
                    }
                    ((CriteriaWithClassElementsSupplyingSupport)criteria).byteCodeForClasses.put(classes, byteCode);
                }
            }
        }
        return byteCode;
    }

    @Override
    public C createCopy() {
        CriteriaWithClassElementsSupplyingSupport copy = (CriteriaWithClassElementsSupplyingSupport)super.createCopy();
        if (this.classesToBeUploaded != null) {
            copy.useClasses(this.classesToBeUploaded);
        }
        return (C)copy;
    }

    @Override
    public void close() {
        if (this.uploadedClassesMap != null) {
            this.uploadedClassesMap.clear();
        }
        this.uploadedClassesMap = null;
        if (this.classesToBeUploaded != null) {
            this.classesToBeUploaded.clear();
        }
        this.classesToBeUploaded = null;
        if (this.byteCodeForClasses != null) {
            this.byteCodeForClasses.clear();
        }
        this.byteCodeForClasses = null;
        if (this.loadedBytecode != null) {
            this.loadedBytecode.clear();
        }
        this.loadedBytecode = null;
        this.classSupplier = null;
        this.byteCodeSupplier = null;
        super.close();
    }
}

