/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ClassTemplateInvocationContext;
import org.junit.jupiter.api.extension.ClassTemplateInvocationContextProvider;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.params.ParameterizedClass;
import org.junit.jupiter.params.ParameterizedClassContext;
import org.junit.jupiter.params.ParameterizedInvocationContextProvider;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.support.AnnotationSupport;

class ParameterizedClassExtension
extends ParameterizedInvocationContextProvider<ClassTemplateInvocationContext>
implements ClassTemplateInvocationContextProvider,
ParameterResolver {
    private static final String DECLARATION_CONTEXT_KEY = "context";

    ParameterizedClassExtension() {
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (ParameterizedClassExtension.isDeclaredOnTestClassConstructor(parameterContext, extensionContext)) {
            this.validateAndStoreClassContext(extensionContext);
        }
        return false;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        throw new JUnitException("Unexpected call to resolveParameter");
    }

    public boolean supportsClassTemplate(ExtensionContext extensionContext) {
        return this.validateAndStoreClassContext(extensionContext);
    }

    public Stream<? extends ClassTemplateInvocationContext> provideClassTemplateInvocationContexts(ExtensionContext extensionContext) {
        return this.provideInvocationContexts(extensionContext, this.getDeclarationContext(extensionContext));
    }

    public boolean mayReturnZeroClassTemplateInvocationContexts(ExtensionContext extensionContext) {
        return this.getDeclarationContext(extensionContext).isAllowingZeroInvocations();
    }

    private static boolean isDeclaredOnTestClassConstructor(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Executable declaringExecutable = parameterContext.getDeclaringExecutable();
        return declaringExecutable instanceof Constructor && declaringExecutable.getDeclaringClass().equals(extensionContext.getTestClass().orElse(null));
    }

    private boolean validateAndStoreClassContext(ExtensionContext extensionContext) {
        ExtensionContext.Store store = this.getStore(extensionContext);
        if (store.get((Object)DECLARATION_CONTEXT_KEY) != null) {
            return true;
        }
        Optional annotation = AnnotationSupport.findAnnotation((Optional)extensionContext.getTestClass(), ParameterizedClass.class);
        if (!annotation.isPresent()) {
            return false;
        }
        store.put((Object)DECLARATION_CONTEXT_KEY, (Object)ParameterizedClassExtension.createClassContext(extensionContext, extensionContext.getRequiredTestClass(), (ParameterizedClass)annotation.get()));
        return true;
    }

    private static ParameterizedClassContext createClassContext(ExtensionContext extensionContext, Class<?> testClass, ParameterizedClass annotation) {
        TestInstance.Lifecycle lifecycle = (TestInstance.Lifecycle)extensionContext.getTestInstanceLifecycle().orElseThrow(() -> new PreconditionViolationException("TestInstance.Lifecycle not present"));
        ParameterizedClassContext classContext = new ParameterizedClassContext(testClass, annotation, lifecycle);
        if (lifecycle == TestInstance.Lifecycle.PER_CLASS && classContext.getInjectionType() == ParameterizedClassContext.InjectionType.CONSTRUCTOR) {
            throw new PreconditionViolationException("Constructor injection is not supported for @ParameterizedClass classes with @TestInstance(Lifecycle.PER_CLASS)");
        }
        return classContext;
    }

    private ParameterizedClassContext getDeclarationContext(ExtensionContext extensionContext) {
        return (ParameterizedClassContext)this.getStore(extensionContext).get((Object)DECLARATION_CONTEXT_KEY, ParameterizedClassContext.class);
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{ParameterizedClassExtension.class, context.getRequiredTestClass()}));
    }
}

