/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.StaticTypedRef;
import com.google.javascript.rhino.jstype.StaticTypedSlot;

public class TypedVar
extends Var
implements StaticTypedSlot<JSType>,
StaticTypedRef<JSType> {
    final TypedScope scope;
    private JSType type;
    private boolean markedEscaped = false;
    private boolean markedAssignedExactlyOnce = false;
    private final boolean typeInferred;

    TypedVar(boolean inferred, String name, Node nameNode, JSType type, TypedScope scope, int index, CompilerInput input) {
        super(name, nameNode, scope, index, input);
        this.type = type;
        this.scope = scope;
        this.typeInferred = inferred;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Node getNode() {
        return this.nameNode;
    }

    @Override
    CompilerInput getInput() {
        return this.input;
    }

    @Override
    public StaticSourceFile getSourceFile() {
        return this.nameNode.getStaticSourceFile();
    }

    @Override
    public TypedVar getSymbol() {
        return this;
    }

    @Override
    public TypedVar getDeclaration() {
        return this.nameNode == null ? null : this;
    }

    @Override
    public Node getParentNode() {
        return this.nameNode == null ? null : this.nameNode.getParent();
    }

    @Override
    public boolean isBleedingFunction() {
        throw new IllegalStateException("Method isBleedingFunction cannot be called on typed variables.");
    }

    @Override
    public TypedScope getScope() {
        return this.scope;
    }

    @Override
    public boolean isGlobal() {
        return this.scope.isGlobal();
    }

    @Override
    public boolean isLocal() {
        return this.scope.isLocal();
    }

    @Override
    boolean isExtern() {
        return this.input == null || this.input.isExtern();
    }

    @Override
    public boolean isInferredConst() {
        throw new IllegalStateException("Method isInferredConst cannot be called on typed variables.");
    }

    @Override
    public boolean isDefine() {
        throw new IllegalStateException("Method isDefine cannot be called on typed variables.");
    }

    @Override
    public Node getInitialValue() {
        return NodeUtil.getRValueOfLValue(this.nameNode);
    }

    @Override
    public Node getNameNode() {
        return this.nameNode;
    }

    @Override
    public JSDocInfo getJSDocInfo() {
        return this.nameNode == null ? null : NodeUtil.getBestJSDocInfo(this.nameNode);
    }

    @Override
    public JSType getType() {
        return this.type;
    }

    void setType(JSType type) {
        this.type = type;
    }

    void resolveType(ErrorReporter errorReporter) {
        if (this.type != null) {
            this.type = this.type.resolve(errorReporter, this.scope);
        }
    }

    @Override
    public boolean isTypeInferred() {
        return this.typeInferred;
    }

    public String getInputName() {
        if (this.input == null) {
            return "<non-file>";
        }
        return this.input.getName();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof TypedVar)) {
            return false;
        }
        return ((TypedVar)other).nameNode == this.nameNode;
    }

    @Override
    public int hashCode() {
        return this.nameNode.hashCode();
    }

    @Override
    public String toString() {
        return "Var " + this.name + "{" + this.type + "}";
    }

    void markEscaped() {
        this.markedEscaped = true;
    }

    boolean isMarkedEscaped() {
        return this.markedEscaped;
    }

    void markAssignedExactlyOnce() {
        this.markedAssignedExactlyOnce = true;
    }

    boolean isMarkedAssignedExactlyOnce() {
        return this.markedAssignedExactlyOnce;
    }

    @Override
    boolean isVar() {
        throw new IllegalStateException("Method isVar cannot be called on typed variables.");
    }

    @Override
    boolean isLet() {
        throw new IllegalStateException("Method isLet cannot be called on typed variables.");
    }

    @Override
    boolean isConst() {
        throw new IllegalStateException("Method isConst cannot be called on typed variables.");
    }

    @Override
    boolean isParam() {
        throw new IllegalStateException("Method isParam cannot be called on typed variables.");
    }
}

