/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Provider;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.AbstractResourceDescription;

public class StatefulResourceDescription
extends AbstractResourceDescription {
    private URI uri;
    private ImmutableList<IEObjectDescription> exported;
    private final Provider<IResourceDescription> snapShotProvider;

    public StatefulResourceDescription(IResourceDescription original, Provider<IResourceDescription> snapShotProvider) {
        this.snapShotProvider = snapShotProvider;
        this.uri = original.getURI();
        this.exported = this.copyExportedObjects(original);
    }

    protected ImmutableList<IEObjectDescription> copyExportedObjects(IResourceDescription original) {
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)original.getExportedObjects(), (Function)new Function<IEObjectDescription, IEObjectDescription>(){

            public IEObjectDescription apply(IEObjectDescription from) {
                if (from == null) {
                    return null;
                }
                EObject proxy = from.getEObjectOrProxy();
                if (proxy == null) {
                    return null;
                }
                if (proxy.eIsProxy()) {
                    return from;
                }
                InternalEObject result = (InternalEObject)EcoreUtil.create((EClass)from.getEClass());
                result.eSetProxyURI(EcoreUtil.getURI((EObject)from.getEObjectOrProxy()));
                HashMap<String, String> userData = null;
                String[] stringArray = from.getUserDataKeys();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    if (userData == null) {
                        userData = new HashMap<String, String>(3);
                    }
                    userData.put(key, from.getUserData(key));
                    ++n2;
                }
                return EObjectDescription.create((QualifiedName)from.getName(), (EObject)result, userData);
            }
        }), (Predicate)Predicates.notNull()));
    }

    protected List<IEObjectDescription> computeExportedObjects() {
        return this.exported;
    }

    public Iterable<QualifiedName> getImportedNames() {
        IResourceDescription snapShot = (IResourceDescription)this.snapShotProvider.get();
        if (snapShot != null) {
            return snapShot.getImportedNames();
        }
        return Collections.emptyList();
    }

    public Iterable<IReferenceDescription> getReferenceDescriptions() {
        IResourceDescription snapShot = (IResourceDescription)this.snapShotProvider.get();
        if (snapShot != null) {
            return snapShot.getReferenceDescriptions();
        }
        return Collections.emptyList();
    }

    public URI getURI() {
        return this.uri;
    }
}

