/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.target;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.IStateDeltaListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelDelta;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.shared.target.CopyLocationAction;
import org.eclipse.pde.internal.ui.views.plugins.ImportActionGroup;
import org.eclipse.pde.internal.ui.views.target.StateTree;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBookView;
import org.osgi.resource.Resource;

public class StateViewPage
extends Page
implements IStateDeltaListener,
IPluginModelListener {
    private final IPropertyChangeListener fPropertyListener;
    private StateTree fFilteredTree;
    private TreeViewer fTreeViewer = null;
    private final PageBookView fView;
    private Composite fComposite;
    private Action fOpenAction;
    private final String DIALOG_SETTINGS = "targetStateView";
    private static final String HIDE_RESOLVED = "hideResolved";
    private static final String SHOW_NONLEAF = "hideNonLeaf";
    private final ViewerFilter fHideResolvedFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return element instanceof BundleDescription && !((BundleDescription)element).isResolved() || parentElement instanceof BundleDescription && !((BundleDescription)parentElement).isResolved();
        }
    };
    private final ViewerFilter fShowLeaves = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof BundleDescription) {
                return ((BundleDescription)element).getDependents().length == 0;
            }
            return true;
        }
    };

    public StateViewPage(PageBookView view) {
        this.fView = view;
        this.fPropertyListener = event -> {
            String property = event.getProperty();
            if (property.equals("Preferences.MainPage.showObjects")) {
                this.fTreeViewer.refresh();
            }
        };
    }

    public void createControl(Composite parent) {
        this.fComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.fComposite.setLayout((Layout)layout);
        this.fComposite.setLayoutData((Object)new GridData(1808));
        this.fFilteredTree = new StateTree(this.fComposite);
        this.fFilteredTree.setBackground(parent.getDisplay().getSystemColor(25));
        this.fTreeViewer = this.fFilteredTree.getViewer();
        if (this.getSettings().getBoolean(HIDE_RESOLVED)) {
            this.fTreeViewer.addFilter(this.fHideResolvedFilter);
        }
        if (this.getSettings().getBoolean(SHOW_NONLEAF)) {
            this.fTreeViewer.addFilter(this.fShowLeaves);
        }
        PDEPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fPropertyListener);
        this.getSite().setSelectionProvider((ISelectionProvider)this.fTreeViewer);
        PDECore.getDefault().getModelManager().addStateDeltaListener((IStateDeltaListener)this);
        this.setActive(true);
    }

    public Control getControl() {
        return this.fComposite;
    }

    public void setFocus() {
        Text c;
        if (this.fFilteredTree != null && (c = this.fFilteredTree.getFilterControl()) != null && !c.isFocusControl()) {
            c.setFocus();
        }
    }

    protected void setActive(boolean active) {
        if (active) {
            State state = PDECore.getDefault().getModelManager().getState().getState();
            state.resolve(true);
            this.fFilteredTree.setInput(state);
            PDECore.getDefault().getModelManager().addPluginModelListener((IPluginModelListener)this);
        } else {
            PDECore.getDefault().getModelManager().removePluginModelListener((IPluginModelListener)this);
        }
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        super.makeContributions(menuManager, toolBarManager, statusLineManager);
        Action filterResolved = new Action(PDEUIMessages.StateViewPage_showOnlyUnresolved_label, 2){

            public void run() {
                StateViewPage.this.getSettings().put(StateViewPage.HIDE_RESOLVED, this.isChecked());
                if (this.isChecked()) {
                    StateViewPage.this.fTreeViewer.addFilter(StateViewPage.this.fHideResolvedFilter);
                } else {
                    StateViewPage.this.fTreeViewer.removeFilter(StateViewPage.this.fHideResolvedFilter);
                }
            }
        };
        Action filterLeaves = new Action(PDEUIMessages.StateViewPage_showLeaves, 2){

            public void run() {
                StateViewPage.this.getSettings().put(StateViewPage.SHOW_NONLEAF, this.isChecked());
                if (this.isChecked()) {
                    StateViewPage.this.fTreeViewer.addFilter(StateViewPage.this.fShowLeaves);
                } else {
                    StateViewPage.this.fTreeViewer.removeFilter(StateViewPage.this.fShowLeaves);
                }
            }
        };
        filterResolved.setChecked(this.getSettings().getBoolean(HIDE_RESOLVED));
        filterLeaves.setChecked(this.getSettings().getBoolean(SHOW_NONLEAF));
        menuManager.add((IAction)filterResolved);
        menuManager.add((IAction)filterLeaves);
        menuManager.add((IContributionItem)new Separator());
        Action openPreferences = new Action(PDEUIMessages.StateViewPage_ChangeTargetPlatform, PDEPluginImages.DESC_TARGET_DEFINITION){

            public void run() {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)"org.eclipse.pde.ui.TargetPlatformPreferencePage", null, null);
                dialog.open();
            }
        };
        menuManager.add((IAction)openPreferences);
        this.hookContextMenu();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(this::fillContextMenu);
        Menu menu = menuMgr.createContextMenu(this.fTreeViewer.getControl());
        this.fTreeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(this.fView.getSite().getId(), menuMgr, (ISelectionProvider)this.fTreeViewer);
    }

    private void fillContextMenu(IMenuManager menu) {
        ITreeSelection selection = this.fTreeViewer.getStructuredSelection();
        final BundleDescription desc = this.fFilteredTree.getBundleDescription();
        if (desc != null) {
            if (this.fOpenAction == null) {
                this.fOpenAction = new Action(PDEUIMessages.StateViewPage_openItem){

                    public void run() {
                        ManifestEditor.openPluginEditor((Resource)desc);
                    }
                };
            }
            menu.add((IAction)this.fOpenAction);
            if (ImportActionGroup.canImport((IStructuredSelection)selection)) {
                ImportActionGroup actionGroup = new ImportActionGroup();
                actionGroup.setContext(new ActionContext((ISelection)selection));
                actionGroup.fillContextMenu(menu);
                menu.add((IContributionItem)new Separator());
            }
            menu.add((IAction)new CopyLocationAction((StructuredViewer)this.fTreeViewer));
            menu.add((IContributionItem)new Separator("additions"));
        }
    }

    public void dispose() {
        PDECore.getDefault().getModelManager().removeStateDeltaListener((IStateDeltaListener)this);
        this.setActive(false);
        super.dispose();
    }

    public void stateResolved(StateDelta delta) {
        if (!this.fView.getCurrentPage().equals((Object)this) || this.fTreeViewer == null || this.fTreeViewer.getTree().isDisposed()) {
            return;
        }
        this.fTreeViewer.getTree().getDisplay().asyncExec(() -> {
            if (delta == null) {
                this.fTreeViewer.refresh();
            } else {
                BundleDelta[] deltas;
                BundleDelta[] bundleDeltaArray = deltas = delta.getChanges();
                int n = deltas.length;
                int n2 = 0;
                while (n2 < n) {
                    BundleDelta d = bundleDeltaArray[n2];
                    int type = d.getType();
                    if (type == 2 || type == 8 || type == 1 || type == 16) {
                        this.fTreeViewer.refresh();
                        break;
                    }
                    ++n2;
                }
            }
        });
    }

    public void stateChanged(State newState) {
        if (!((Object)((Object)this)).equals(this.fView.getCurrentPage()) || this.fTreeViewer == null || this.fTreeViewer.getTree().isDisposed()) {
            return;
        }
        this.fTreeViewer.getTree().getDisplay().asyncExec(() -> this.fFilteredTree.setInput(newState));
    }

    private IDialogSettings getSettings() {
        IDialogSettings master = PDEPlugin.getDefault().getDialogSettings();
        IDialogSettings section = master.getSection("targetStateView");
        if (section == null) {
            section = master.addNewSection("targetStateView");
        }
        return section;
    }

    public void modelsChanged(PluginModelDelta delta) {
        if (this.fTreeViewer == null || this.fTreeViewer.getTree().isDisposed()) {
            return;
        }
        if (delta.getAddedEntries().length > 0 || delta.getChangedEntries().length > 0 || delta.getRemovedEntries().length > 0) {
            this.fTreeViewer.getTree().getDisplay().asyncExec(() -> this.fTreeViewer.refresh());
        }
    }

    static class DependencyGroup {
        Object[] dependencies;

        public DependencyGroup(Object[] constraints) {
            this.dependencies = constraints;
        }

        public Object[] getChildren() {
            return this.dependencies;
        }

        public String toString() {
            return this.dependencies[0] instanceof BundleSpecification ? PDEUIMessages.StateViewPage_requiredBundles : PDEUIMessages.StateViewPage_importedPackages;
        }
    }
}

