/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.subscriber;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.subscriber.ISubscriberProvider;

public class SubscriberProviderDescriptor {
    private final IConfigurationElement configurationElement;
    private final String attributeClassName;
    private boolean logOnce;
    private ISubscriberProvider provider;
    private int ranking;

    public SubscriberProviderDescriptor(String attributeName, IConfigurationElement configurationElement, int ranking) {
        this.attributeClassName = attributeName;
        this.configurationElement = configurationElement;
        this.ranking = ranking;
    }

    public int getRanking() {
        return this.ranking;
    }

    public ISubscriberProvider getSubscriberProvider() {
        block3: {
            if (this.provider == null && !this.logOnce) {
                try {
                    this.provider = (ISubscriberProvider)this.configurationElement.createExecutableExtension(this.attributeClassName);
                }
                catch (CoreException e) {
                    if (this.logOnce) break block3;
                    this.logOnce = true;
                    String className = this.configurationElement.getAttribute(this.attributeClassName);
                    String message = EMFCompareIDEUIMessages.getString("SubscriberProviderRegistry.invalidSubscriber", className);
                    Status status = new Status(4, this.configurationElement.getDeclaringExtension().getContributor().getName(), message, (Throwable)e);
                    EMFCompareIDEUIPlugin.getDefault().getLog().log((IStatus)status);
                }
            }
        }
        return this.provider;
    }
}

