/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.ui.preferences;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.server.ProcessStreamConnectionProvider;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.wildwebdeveloper.ui.preferences.Settings;

public abstract class ProcessStreamConnectionProviderWithPreference
extends ProcessStreamConnectionProvider
implements IPropertyChangeListener {
    private static final Map<PreferenceStoreKey, PropertyChangeListenerWrapper> listenerPerLanguageServer = new HashMap<PreferenceStoreKey, PropertyChangeListenerWrapper>();
    private final PreferenceStoreKey preferenceStoreKey;
    private final String[] supportedSections;
    private LanguageServersRegistry.LanguageServerDefinition languageServerDefinition;

    public ProcessStreamConnectionProviderWithPreference(String languageServerId, IPreferenceStore preferenceStore, String[] supportedSections) {
        this.preferenceStoreKey = new PreferenceStoreKey(preferenceStore, languageServerId);
        this.supportedSections = supportedSections;
    }

    public void start() throws IOException {
        super.start();
        this.addPropertyChangeListenerIfNeed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPropertyChangeListenerIfNeed() {
        Map<PreferenceStoreKey, PropertyChangeListenerWrapper> map = listenerPerLanguageServer;
        synchronized (map) {
            PropertyChangeListenerWrapper listener = listenerPerLanguageServer.get(this.preferenceStoreKey);
            if (listener == null) {
                listener = new PropertyChangeListenerWrapper(this);
                listenerPerLanguageServer.put(this.preferenceStoreKey, listener);
            }
            if (listener.hasNoServerStarted()) {
                this.preferenceStoreKey.preferenceStore.addPropertyChangeListener((IPropertyChangeListener)listener);
            }
            listener.startServer();
        }
    }

    public void stop() {
        this.removePropertyChangeListenerIfNeed();
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePropertyChangeListenerIfNeed() {
        Map<PreferenceStoreKey, PropertyChangeListenerWrapper> map = listenerPerLanguageServer;
        synchronized (map) {
            PropertyChangeListenerWrapper listener = listenerPerLanguageServer.get(this.preferenceStoreKey);
            if (listener != null) {
                listener.endServer();
                if (listener.hasNoServerStarted()) {
                    this.preferenceStoreKey.preferenceStore.removePropertyChangeListener((IPropertyChangeListener)listener);
                    listenerPerLanguageServer.remove(this.preferenceStoreKey);
                }
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.isAffected(event)) {
            LanguageServersRegistry.LanguageServerDefinition languageServerDefinition = this.getLanguageServerDefinition();
            DidChangeConfigurationParams params = new DidChangeConfigurationParams(this.createSettings());
            ((LanguageServers.LanguageServerProjectExecutor)LanguageServers.forProject(null).withPreferredServer(languageServerDefinition)).excludeInactive().collectAll((w, ls) -> CompletableFuture.completedFuture(ls)).thenAccept(lss -> lss.stream().forEach(ls -> ls.getWorkspaceService().didChangeConfiguration(params)));
        }
    }

    private LanguageServersRegistry.LanguageServerDefinition getLanguageServerDefinition() {
        if (this.languageServerDefinition == null) {
            this.languageServerDefinition = LanguageServersRegistry.getInstance().getDefinition(this.preferenceStoreKey.languageServerId);
        }
        return this.languageServerDefinition;
    }

    protected boolean isAffected(PropertyChangeEvent event) {
        String property = event.getProperty();
        String[] stringArray = this.supportedSections;
        int n = this.supportedSections.length;
        int n2 = 0;
        while (n2 < n) {
            String supportedSection = stringArray[n2];
            if (Settings.isMatchSection(property, supportedSection)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected abstract Object createSettings();

    private static class PreferenceStoreKey {
        public final IPreferenceStore preferenceStore;
        public final String languageServerId;

        public PreferenceStoreKey(IPreferenceStore preferenceStore, String languageServerId) {
            this.preferenceStore = preferenceStore;
            this.languageServerId = languageServerId;
        }

        public int hashCode() {
            return Objects.hash(this.languageServerId, this.preferenceStore);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PreferenceStoreKey other = (PreferenceStoreKey)obj;
            return Objects.equals(this.languageServerId, other.languageServerId) && Objects.equals(this.preferenceStore, other.preferenceStore);
        }
    }

    private static class PropertyChangeListenerWrapper
    implements IPropertyChangeListener {
        private final IPropertyChangeListener listener;
        private int languageServerStartedNumber;

        public PropertyChangeListenerWrapper(IPropertyChangeListener listener) {
            this.listener = listener;
        }

        public void propertyChange(PropertyChangeEvent event) {
            this.listener.propertyChange(event);
        }

        public boolean hasNoServerStarted() {
            return this.languageServerStartedNumber == 0;
        }

        public void startServer() {
            ++this.languageServerStartedNumber;
        }

        public void endServer() {
            --this.languageServerStartedNumber;
        }
    }
}

