/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.log.stream;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.equinox.internal.log.stream.LogStreamProviderImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.log.stream.LogStreamProvider;
import org.osgi.util.tracker.ServiceTracker;

public class LogStreamProviderFactory
implements ServiceFactory<LogStreamProvider> {
    Map<Bundle, LogStreamProviderImpl> providers = new HashMap<Bundle, LogStreamProviderImpl>();
    ReentrantReadWriteLock eventProducerLock = new ReentrantReadWriteLock();
    ServiceTracker<LogReaderService, AtomicReference<LogReaderService>> logReaderService;
    private final int cores = Runtime.getRuntime().availableProcessors();
    private final ExecutorService executor = Executors.newFixedThreadPool(this.cores, r -> {
        Thread t = new Thread(r, "LogStream thread");
        t.setDaemon(true);
        return t;
    });

    public LogStreamProviderFactory(ServiceTracker<LogReaderService, AtomicReference<LogReaderService>> logReaderService) {
        this.logReaderService = logReaderService;
    }

    public void postLogEntry(LogEntry entry) {
        this.eventProducerLock.readLock().lock();
        try {
            for (LogStreamProviderImpl provider : this.providers.values()) {
                provider.logged(entry);
            }
        }
        finally {
            this.eventProducerLock.readLock().unlock();
        }
    }

    public LogStreamProviderImpl getService(Bundle bundle, ServiceRegistration<LogStreamProvider> registration) {
        LogStreamProviderImpl logStreamProviderImpl = new LogStreamProviderImpl(this.logReaderService, this.executor);
        this.eventProducerLock.writeLock().lock();
        try {
            this.providers.put(bundle, logStreamProviderImpl);
            LogStreamProviderImpl logStreamProviderImpl2 = logStreamProviderImpl;
            return logStreamProviderImpl2;
        }
        finally {
            this.eventProducerLock.writeLock().unlock();
        }
    }

    public void ungetService(Bundle bundle, ServiceRegistration<LogStreamProvider> registration, LogStreamProvider service) {
        LogStreamProviderImpl logStreamProviderImpl;
        this.eventProducerLock.writeLock().lock();
        try {
            logStreamProviderImpl = this.providers.remove(bundle);
        }
        finally {
            this.eventProducerLock.writeLock().unlock();
        }
        logStreamProviderImpl.close();
    }

    public void shutdownExecutor() {
        this.executor.shutdown();
    }
}

