/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecSimpleDeclaration;
import org.eclipse.core.runtime.CoreException;

public class ExecIf
implements ICPPExecution {
    private final boolean isConstexpr;
    private final ICPPExecution initStmtExec;
    private final ICPPEvaluation conditionExprEval;
    private final ExecSimpleDeclaration conditionDeclExec;
    private final ICPPExecution thenClauseExec;
    private final ICPPExecution elseClauseExec;

    public ExecIf(boolean isConstexpr, ICPPExecution initStmtExec, ICPPEvaluation conditionExprEval, ExecSimpleDeclaration conditionDeclExec, ICPPExecution thenClauseExec, ICPPExecution elseClauseExec) {
        this.isConstexpr = isConstexpr;
        this.initStmtExec = initStmtExec;
        this.conditionExprEval = conditionExprEval;
        this.conditionDeclExec = conditionDeclExec;
        this.thenClauseExec = thenClauseExec;
        this.elseClauseExec = elseClauseExec;
    }

    private boolean conditionSatisfied(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        if (this.conditionExprEval != null) {
            return EvalUtil.conditionExprSatisfied(this.conditionExprEval, record, context);
        }
        if (this.conditionDeclExec != null) {
            return EvalUtil.conditionDeclSatisfied(this.conditionDeclExec, record, context);
        }
        return false;
    }

    @Override
    public ICPPExecution executeForFunctionCall(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        EvalUtil.executeStatement(this.initStmtExec, record, context);
        if (this.conditionSatisfied(record, context)) {
            return this.thenClauseExec != null ? EvalUtil.executeStatement(this.thenClauseExec, record, context) : null;
        }
        return this.elseClauseExec != null ? EvalUtil.executeStatement(this.elseClauseExec, record, context) : null;
    }

    @Override
    public ICPPExecution instantiate(InstantiationContext context, int maxDepth) {
        ICPPExecution newInitStmtExec = this.initStmtExec != null ? this.initStmtExec.instantiate(context, maxDepth) : null;
        ICPPEvaluation newConditionExprEval = this.conditionExprEval != null ? this.conditionExprEval.instantiate(context, maxDepth) : null;
        ExecSimpleDeclaration newConditionDeclExec = this.conditionDeclExec != null ? (ExecSimpleDeclaration)this.conditionDeclExec.instantiate(context, maxDepth) : null;
        ICPPExecution newThenClauseExec = null;
        ICPPExecution newElseClauseExec = null;
        if (this.isConstexpr && newConditionExprEval != null && newConditionExprEval.getValue().numberValue() != null) {
            if (newConditionExprEval.getValue().numberValue().intValue() != 0) {
                newThenClauseExec = this.thenClauseExec != null ? this.thenClauseExec.instantiate(context, maxDepth) : null;
            } else {
                newElseClauseExec = this.elseClauseExec != null ? this.elseClauseExec.instantiate(context, maxDepth) : null;
            }
        } else {
            newThenClauseExec = this.thenClauseExec != null ? this.thenClauseExec.instantiate(context, maxDepth) : null;
            ICPPExecution iCPPExecution = newElseClauseExec = this.elseClauseExec != null ? this.elseClauseExec.instantiate(context, maxDepth) : null;
        }
        if (newInitStmtExec == this.initStmtExec && newConditionExprEval == this.conditionExprEval && newConditionDeclExec == this.conditionDeclExec && newThenClauseExec == this.thenClauseExec && newElseClauseExec == this.elseClauseExec) {
            return this;
        }
        return new ExecIf(this.isConstexpr, newInitStmtExec, newConditionExprEval, newConditionDeclExec, newThenClauseExec, newElseClauseExec);
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        short firstBytes = 11;
        if (this.isConstexpr) {
            firstBytes = (short)(firstBytes | 0x20);
        }
        buffer.putShort(firstBytes);
        buffer.marshalExecution(this.initStmtExec, includeValue);
        buffer.marshalEvaluation(this.conditionExprEval, includeValue);
        buffer.marshalExecution(this.conditionDeclExec, includeValue);
        buffer.marshalExecution(this.thenClauseExec, includeValue);
        buffer.marshalExecution(this.elseClauseExec, includeValue);
    }

    public static ICPPExecution unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        boolean isConstexpr = (firstBytes & 0x20) != 0;
        ICPPExecution initStmtExec = buffer.unmarshalExecution();
        ICPPEvaluation conditionExprEval = buffer.unmarshalEvaluation();
        ExecSimpleDeclaration conditionDeclExec = (ExecSimpleDeclaration)buffer.unmarshalExecution();
        ICPPExecution thenClauseExec = buffer.unmarshalExecution();
        ICPPExecution elseClauseExec = buffer.unmarshalExecution();
        return new ExecIf(isConstexpr, initStmtExec, conditionExprEval, conditionDeclExec, thenClauseExec, elseClauseExec);
    }
}

