/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.ui;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gmf.runtime.gef.ui.internal.tools.ConnectionBendpointTrackerEx;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.SnapBendpointRequest;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Cursor;

public class SiriusConnectionBendpointTrackerEx
extends ConnectionBendpointTrackerEx {
    boolean snapToAllShape = false;
    private boolean moveGroupActivated;

    public SiriusConnectionBendpointTrackerEx(ConnectionEditPart editpart, int i) {
        super(editpart, i);
        this.setDisabledCursor(SharedCursors.NO);
    }

    protected Request createSourceRequest() {
        SnapBendpointRequest request = new SnapBendpointRequest();
        request.setType(this.getType());
        request.setIndex(this.getIndex());
        request.setSource(this.getConnectionEditPart());
        return request;
    }

    protected boolean handleKeyDown(KeyEvent event) {
        boolean handled = false;
        if (0x100000D == event.keyCode) {
            this.snapToAllShape = true;
            handled = true;
        } else if (0x100000C == event.keyCode) {
            this.moveGroupActivated = true;
            handled = true;
        }
        if (handled) {
            return true;
        }
        return super.handleKeyDown(event);
    }

    protected boolean handleKeyUp(KeyEvent event) {
        boolean handled = false;
        if (0x100000D == event.keyCode) {
            this.snapToAllShape = false;
            handled = true;
        } else if (0x100000C == event.keyCode) {
            this.moveGroupActivated = false;
            handled = true;
        }
        if (handled) {
            return true;
        }
        return super.handleKeyUp(event);
    }

    protected void updateSourceRequest() {
        if (this.getSourceRequest() instanceof SnapBendpointRequest) {
            if (this.snapToAllShape) {
                ((SnapBendpointRequest)this.getSourceRequest()).setSnapToAllShape(true);
            } else {
                ((SnapBendpointRequest)this.getSourceRequest()).setSnapToAllShape(false);
            }
        }
        if (this.getSourceRequest() instanceof LocationRequest) {
            if (this.moveGroupActivated) {
                this.getSourceRequest().getExtendedData().put("EDGE_GROUP_MOVE", Boolean.TRUE);
                this.getSourceRequest().getExtendedData().put("EDGE_MOVE_DELTA", this.computeDelta((LocationRequest)this.getSourceRequest()));
                this.getSourceRequest().getExtendedData().put("EDGE_GROUP_MOVE_HAS_BEEN_ACTIVATED_KEY", Boolean.TRUE);
            } else {
                this.getSourceRequest().getExtendedData().put("EDGE_GROUP_MOVE", Boolean.FALSE);
                this.getSourceRequest().getExtendedData().remove("EDGE_MOVE_DELTA");
            }
        }
        super.updateSourceRequest();
    }

    private Dimension computeDelta(LocationRequest bendpointRequest) {
        Point newLocation = bendpointRequest.getLocation();
        Dimension diff = newLocation != null ? newLocation.getDifference(this.getStartLocation()) : this.getDragMoveDelta();
        return diff;
    }

    protected boolean handleButtonUp(int button) {
        boolean result = super.handleButtonUp(button);
        this.snapToAllShape = false;
        this.moveGroupActivated = false;
        return result;
    }

    protected Cursor calculateCursor() {
        Command command;
        Cursor cursorToReturn = this.moveGroupActivated ? ((command = this.getCurrentCommand()) == null || !command.canExecute() ? this.getDisabledCursor() : SharedCursors.ARROW) : super.calculateCursor();
        return cursorToReturn;
    }
}

