/*******************************************************************************
 * Copyright (c) 2009 Tasktop Technologies and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * https://www.eclipse.org/legal/epl-2.0
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Tasktop Technologies - initial API and implementation
 *******************************************************************************/

package org.eclipse.mylyn.internal.tasks.ui.commands;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUi;

/**
 * @author Steffen Pingel
 */
public class DeactivateTaskHandler extends AbstractTaskHandler {

	public DeactivateTaskHandler() {
		singleTask = true;
	}

	@Override
	protected void execute(ExecutionEvent event, ITask task) throws ExecutionException {
		TasksUi.getTaskActivityManager().deactivateTask(task);
	}

}
