/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.libval;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jpt.common.core.internal.libval.LibraryValidatorTools;
import org.eclipse.jpt.common.core.libprov.JptLibraryProviderInstallOperationConfig;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;

public class JaxbLibraryValidatorTools {
    public static final String FACET_VERSION_STRING_2_1 = "2.1";
    public static final IProjectFacetVersion FACET_VERSION_2_1 = JaxbProject.FACET.getVersion("2.1");
    public static final String FACET_VERSION_STRING_2_2 = "2.2";
    public static final IProjectFacetVersion FACET_VERSION_2_2 = JaxbProject.FACET.getVersion("2.2");
    private static final Transformer<LibraryLocation, IPath> LIBRARY_LOCATION_TRANSFORMER = new LibraryLocationTransformer();
    private static final String XML_SEE_ALSO = "javax/xml/bind/annotation/XmlSeeAlso.class";
    private static final String JAXB_PERMISSION = "javax/xml/bind/JAXBPermission.class";

    public static IProjectFacetVersion findJavaJaxbVersion(JptLibraryProviderInstallOperationConfig config) {
        IProjectFacetVersion javaVersion = LibraryValidatorTools.getJavaFacetVersion((JptLibraryProviderInstallOperationConfig)config);
        if (javaVersion == JavaFacet.VERSION_1_6) {
            return FACET_VERSION_2_1;
        }
        if (javaVersion == JavaFacet.VERSION_1_7) {
            return FACET_VERSION_2_2;
        }
        if (javaVersion == JavaFacet.VERSION_1_8) {
            return FACET_VERSION_2_2;
        }
        return null;
    }

    public static IProjectFacetVersion findJreJaxbVersion(JptLibraryProviderInstallOperationConfig config) {
        IVMInstall vmInstall = JaxbLibraryValidatorTools.findVMInstall(config.getFacetedProject());
        return vmInstall == null ? null : JaxbLibraryValidatorTools.findJreJaxbVersion(vmInstall);
    }

    private static IVMInstall findVMInstall(IFacetedProjectBase facetedProject) {
        IJavaProject javaProject;
        IVMInstall vm = null;
        IRuntime runtime = facetedProject.getPrimaryRuntime();
        if (runtime != null) {
            for (IRuntimeComponent rc : runtime.getRuntimeComponents()) {
                vm = JaxbLibraryValidatorTools.findVMInstall(rc);
                if (vm == null) continue;
                return vm;
            }
        }
        if ((javaProject = JavaCore.create((IProject)facetedProject.getProject())) != null) {
            try {
                vm = JavaRuntime.getVMInstall((IJavaProject)javaProject);
            }
            catch (CoreException coreException) {}
        }
        return vm != null ? vm : JavaRuntime.getDefaultVMInstall();
    }

    private static IVMInstall findVMInstall(IRuntimeComponent rc) {
        String vmInstallTypeId = rc.getProperty("vm-install-type");
        if (vmInstallTypeId == null) {
            return null;
        }
        String vmInstallId = rc.getProperty("vm-install-id");
        if (vmInstallId == null) {
            return null;
        }
        IVMInstallType vmInstallType = JavaRuntime.getVMInstallType((String)vmInstallTypeId);
        return vmInstallType == null ? null : vmInstallType.findVMInstall(vmInstallId);
    }

    private static IProjectFacetVersion findJreJaxbVersion(IVMInstall vm) {
        String javaVersion;
        if (vm instanceof IVMInstall2 && (javaVersion = ((IVMInstall2)vm).getJavaVersion()) != null) {
            if (javaVersion.startsWith("1.7")) {
                return FACET_VERSION_2_2;
            }
            if (!javaVersion.startsWith("1.6")) {
                return null;
            }
        }
        boolean foundXmlSeeAlso = false;
        for (IPath vmLibPath : JaxbLibraryValidatorTools.buildLibraryPaths(vm)) {
            ZipFile zipFile;
            block18: {
                IProjectFacetVersion iProjectFacetVersion;
                block19: {
                    File file = vmLibPath.toFile();
                    if (!file.exists()) continue;
                    zipFile = null;
                    zipFile = new ZipFile(file);
                    if (zipFile.getEntry(JAXB_PERMISSION) == null) break block18;
                    iProjectFacetVersion = FACET_VERSION_2_2;
                    if (zipFile == null) break block19;
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
                return iProjectFacetVersion;
            }
            try {
                try {
                    foundXmlSeeAlso |= zipFile.getEntry(XML_SEE_ALSO) != null;
                }
                catch (IOException iOException) {
                    if (zipFile == null) continue;
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException2) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (zipFile == null) continue;
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
        return foundXmlSeeAlso ? FACET_VERSION_2_1 : null;
    }

    private static Iterable<IPath> buildLibraryPaths(IVMInstall vm) {
        return IterableTools.transform((Iterable)IterableTools.iterable((Object[])JavaRuntime.getLibraryLocations((IVMInstall)vm)), LIBRARY_LOCATION_TRANSFORMER);
    }

    static class LibraryLocationTransformer
    extends TransformerAdapter<LibraryLocation, IPath> {
        LibraryLocationTransformer() {
        }

        public IPath transform(LibraryLocation libraryLocation) {
            return libraryLocation.getSystemLibraryPath();
        }
    }
}

