/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.launching;

import java.io.IOException;
import org.eclipse.cdt.debug.internal.ui.dialogfields.ComboDialogField;
import org.eclipse.cdt.debug.internal.ui.dialogfields.DialogField;
import org.eclipse.cdt.debug.internal.ui.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.AbstractSettingsBlock;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.LaunchUIMessages;
import org.eclipse.cdt.serial.SerialPort;
import org.eclipse.cdt.serial.StandardBaudRates;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SerialPortSettingsBlock
extends AbstractSettingsBlock {
    private ComboDialogField fDeviceField;
    private ComboDialogField fSpeedField;
    private String[] fSerialPorts;

    public SerialPortSettingsBlock() {
        try {
            this.fSerialPorts = SerialPort.list();
        }
        catch (IOException e) {
            GdbUIPlugin.log(e);
            this.fSerialPorts = new String[0];
        }
        this.fDeviceField = this.createDeviceField();
        this.fSpeedField = this.createSpeedField();
    }

    @Override
    public void createBlock(Composite parent) {
        this.fShell = parent.getShell();
        Composite comp = ControlFactory.createCompositeEx((Composite)parent, (int)2, (int)1808);
        ((GridLayout)comp.getLayout()).makeColumnsEqualWidth = false;
        ((GridLayout)comp.getLayout()).marginHeight = 0;
        ((GridLayout)comp.getLayout()).marginWidth = 0;
        comp.setFont(parent.getFont());
        this.fDeviceField.doFillIntoGrid(comp, 2);
        ((GridData)this.fDeviceField.getComboControl(null).getLayoutData()).horizontalAlignment = 1;
        this.fSpeedField.doFillIntoGrid(comp, 2);
        ((GridData)this.fSpeedField.getComboControl(null).getLayoutData()).horizontalAlignment = 1;
        this.setControl((Control)comp);
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        this.initializeDevice(configuration);
        this.initializeSpeed(configuration);
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.DEV", this.fSerialPorts.length > 0 ? this.fSerialPorts[0] : "");
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.DEV_SPEED", "" + StandardBaudRates.getDefault());
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fDeviceField != null) {
            configuration.setAttribute("org.eclipse.cdt.dsf.gdb.DEV", this.fDeviceField.getText().trim());
        }
        if (this.fSpeedField != null) {
            configuration.setAttribute("org.eclipse.cdt.dsf.gdb.DEV_SPEED", this.fSpeedField.getText().trim());
        }
    }

    private ComboDialogField createDeviceField() {
        ComboDialogField field = new ComboDialogField(4);
        field.setLabelText(LaunchUIMessages.getString("SerialPortSettingsBlock.0"));
        field.setItems(this.fSerialPorts);
        field.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField f) {
                SerialPortSettingsBlock.this.deviceFieldChanged();
            }
        });
        return field;
    }

    private ComboDialogField createSpeedField() {
        ComboDialogField field = new ComboDialogField(4);
        field.setLabelText(LaunchUIMessages.getString("SerialPortSettingsBlock.1"));
        field.setItems(StandardBaudRates.asStringArray());
        field.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField f) {
                SerialPortSettingsBlock.this.speedFieldChanged();
            }
        });
        return field;
    }

    protected void deviceFieldChanged() {
        this.updateErrorMessage();
        this.setChanged();
        this.notifyObservers();
    }

    protected void speedFieldChanged() {
        this.updateErrorMessage();
        this.setChanged();
        this.notifyObservers();
    }

    private void initializeDevice(ILaunchConfiguration configuration) {
        if (this.fDeviceField != null) {
            try {
                String defaultPort = this.fSerialPorts.length > 0 ? this.fSerialPorts[0] : "";
                String port = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.DEV", defaultPort);
                this.fDeviceField.setText(port);
                this.initializeField(configuration, this.fDeviceField, (Composite)this.fControl);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    private void initializeSpeed(ILaunchConfiguration configuration) {
        if (this.fSpeedField != null) {
            try {
                String rate = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.DEV_SPEED", "" + StandardBaudRates.getDefault());
                this.fSpeedField.setText(rate);
                this.initializeField(configuration, this.fSpeedField, (Composite)this.fControl);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void updateErrorMessage() {
        this.setErrorMessage(null);
        if (this.fDeviceField != null && this.fSpeedField != null) {
            if (this.fDeviceField.getText().isBlank()) {
                this.setErrorMessage(LaunchUIMessages.getString("SerialPortSettingsBlock.2"));
            } else if (!this.deviceIsValid(this.fDeviceField.getText().trim())) {
                this.setErrorMessage(LaunchUIMessages.getString("SerialPortSettingsBlock.3"));
            } else if (this.fSpeedField.getText().isBlank()) {
                this.setErrorMessage(LaunchUIMessages.getString("SerialPortSettingsBlock.4"));
            }
        }
    }

    private boolean deviceIsValid(String serialPort) {
        return true;
    }
}

