/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.ui.widgets;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.ui.IWorkingSet;

public class BasicElementLabels {
    private static final String CODE_DELIMITERS = TextProcessor.getDefaultDelimiters() + "<>()?,{}+-*!%=^|&;[]~";
    private static final String FILE_PATTERN_DELIMITERS = TextProcessor.getDefaultDelimiters() + "*.?";
    private static final String URL_DELIMITERS = TextProcessor.getDefaultDelimiters() + ":@?-";

    public static String getPathLabel(IPath path, boolean isOSPath) {
        String label = isOSPath ? path.toOSString() : path.makeRelative().toString();
        return BasicElementLabels.markLTR(label);
    }

    public static String getPathLabel(File file) {
        return BasicElementLabels.markLTR(file.getAbsolutePath());
    }

    public static String getFilePattern(String name) {
        return BasicElementLabels.markLTR(name, FILE_PATTERN_DELIMITERS);
    }

    public static String getURLPart(String name) {
        return BasicElementLabels.markLTR(name, URL_DELIMITERS);
    }

    public static String getResourceName(IResource resource) {
        return BasicElementLabels.markLTR(resource.getName());
    }

    public static String getResourceName(String resourceName) {
        return BasicElementLabels.markLTR(resourceName);
    }

    public static String getJavaCodeString(String string) {
        return BasicElementLabels.markLTR(string, CODE_DELIMITERS);
    }

    public static String getVersionName(String name) {
        return BasicElementLabels.markLTR(name);
    }

    public static String getWorkingSetLabel(IWorkingSet set) {
        return BasicElementLabels.markLTR(set.getLabel());
    }

    private static String markLTR(String label) {
        return label;
    }

    private static String markLTR(String label, String delim) {
        return label;
    }
}

