/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.io;

import java.net.URI;
import java.util.Objects;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.io.Resource;

class DefaultResource
implements Resource {
    private final String name;
    private final URI uri;

    DefaultResource(String name, URI uri) {
        this.name = DefaultResource.checkNotNull(name, "name");
        this.uri = DefaultResource.checkNotNull(uri, "uri");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Resource) {
            Resource that = (Resource)obj;
            return this.name.equals(that.getName()) && this.uri.equals(that.getUri());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.uri);
    }

    private static <T> T checkNotNull(T input, String title) {
        if (input == null) {
            throw new PreconditionViolationException(title + " must not be null");
        }
        return input;
    }
}

