/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ecore.es2as;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.common.OCLCommon;
import org.eclipse.ocl.pivot.Annotation;
import org.eclipse.ocl.pivot.AnyType;
import org.eclipse.ocl.pivot.BagType;
import org.eclipse.ocl.pivot.BooleanType;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Comment;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Detail;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Enumeration;
import org.eclipse.ocl.pivot.EnumerationLiteral;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.InvalidType;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.Library;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OrderedSetType;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.ParameterVariable;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.PrimitiveType;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.SequenceType;
import org.eclipse.ocl.pivot.SetType;
import org.eclipse.ocl.pivot.Stereotype;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.TemplateableElement;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.VoidType;
import org.eclipse.ocl.pivot.ids.RootPackageId;
import org.eclipse.ocl.pivot.internal.PackageImpl;
import org.eclipse.ocl.pivot.internal.PrimitiveCompletePackageImpl;
import org.eclipse.ocl.pivot.internal.complete.CompleteClassInternal;
import org.eclipse.ocl.pivot.internal.complete.CompleteModelInternal;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.ecore.EObjectOperation;
import org.eclipse.ocl.pivot.internal.ecore.es2as.AbstractExternal2AS;
import org.eclipse.ocl.pivot.internal.ecore.es2as.Ecore2AS;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.AS2Moniker;
import org.eclipse.ocl.pivot.internal.utilities.AliasAdapter;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.internal.utilities.Technology;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.RealValue;
import org.eclipse.ocl.pivot.values.UnlimitedNaturalValue;

public class Ecore2ASDeclarationSwitch
extends EcoreSwitch<Object> {
    protected final @NonNull AbstractExternal2AS converter;
    protected final @NonNull EnvironmentFactoryInternal environmentFactory;
    protected final @NonNull Technology technology;

    public static boolean hasDocumentationKey(@Nullable String source, @NonNull EMap<String, String> details) {
        return details.size() == 1 && "http://www.eclipse.org/emf/2002/GenModel".equals(source) && details.containsKey((Object)"documentation");
    }

    public static boolean hasImportKey(@Nullable String source, @NonNull EMap<String, String> details) {
        return "http://www.eclipse.org/OCL/Import".equals(source);
    }

    public static boolean isDocumentationKey(@Nullable String source, @Nullable String key) {
        return "http://www.eclipse.org/emf/2002/GenModel".equals(source) && "documentation".equals(key);
    }

    public Ecore2ASDeclarationSwitch(@NonNull AbstractExternal2AS converter) {
        this.converter = converter;
        this.environmentFactory = converter.getEnvironmentFactory();
        this.technology = this.environmentFactory.getTechnology();
    }

    public Object caseEAnnotation(EAnnotation eObject) {
        String source = eObject.getSource();
        EMap details = eObject.getDetails();
        Annotation pivotElement = PivotFactory.eINSTANCE.createAnnotation();
        pivotElement.setName(source);
        this.converter.addMapping((EObject)eObject, pivotElement);
        this.copyAnnotatedElement(pivotElement, (EModelElement)eObject, null);
        this.doSwitchAll(pivotElement.getOwnedContents(), (List<? extends EObject>)eObject.getContents());
        for (Map.Entry entry : details) {
            String key = (String)entry.getKey();
            if (details.size() == 1 && Ecore2ASDeclarationSwitch.isDocumentationKey(source, key)) continue;
            Detail pivotDetail = PivotFactory.eINSTANCE.createDetail();
            pivotDetail.setName(key);
            pivotDetail.getValues().add((String)entry.getValue());
            pivotElement.getOwnedDetails().add(pivotDetail);
        }
        if (!eObject.getReferences().isEmpty()) {
            this.converter.queueReference((EObject)eObject);
        }
        return pivotElement;
    }

    public Object caseEAttribute(EAttribute eObject) {
        @NonNull EAttribute eObject2 = eObject;
        Property pivotElement = this.converter.refreshNamedElement(Property.class, PivotPackage.Literals.PROPERTY, (ENamedElement)eObject2);
        this.copyStructuralFeature(pivotElement, (EStructuralFeature)eObject2, null);
        pivotElement.setIsID(eObject2.isID());
        return pivotElement;
    }

    public Object caseEClass(EClass eClass) {
        EAnnotation redefinesAnnotation;
        Package parentPackage;
        boolean nameChange;
        assert (eClass != null);
        String newName = this.technology.getOriginalName((ENamedElement)eClass);
        Class pivotElement = this.technology.isStereotype(this.environmentFactory, eClass) ? (Class)this.converter.refreshElement(Stereotype.class, PivotPackage.Literals.STEREOTYPE, (EModelElement)eClass) : ("Bag".equals(newName) ? (Class)this.converter.refreshElement(BagType.class, PivotPackage.Literals.BAG_TYPE, (EModelElement)eClass) : ("Collection".equals(newName) ? (Class)this.converter.refreshElement(CollectionType.class, PivotPackage.Literals.COLLECTION_TYPE, (EModelElement)eClass) : ("OclAny".equals(newName) ? (Class)this.converter.refreshElement(AnyType.class, PivotPackage.Literals.ANY_TYPE, (EModelElement)eClass) : ("OclInvalid".equals(newName) ? (Class)this.converter.refreshElement(InvalidType.class, PivotPackage.Literals.INVALID_TYPE, (EModelElement)eClass) : ("OclVoid".equals(newName) ? (Class)this.converter.refreshElement(VoidType.class, PivotPackage.Literals.VOID_TYPE, (EModelElement)eClass) : ("OrderedCollection".equals(newName) ? (Class)this.converter.refreshElement(CollectionType.class, PivotPackage.Literals.COLLECTION_TYPE, (EModelElement)eClass) : ("OrderedSet".equals(newName) ? (Class)this.converter.refreshElement(OrderedSetType.class, PivotPackage.Literals.ORDERED_SET_TYPE, (EModelElement)eClass) : ("Sequence".equals(newName) ? (Class)this.converter.refreshElement(SequenceType.class, PivotPackage.Literals.SEQUENCE_TYPE, (EModelElement)eClass) : ("Set".equals(newName) ? (Class)this.converter.refreshElement(SetType.class, PivotPackage.Literals.SET_TYPE, (EModelElement)eClass) : ("UniqueCollection".equals(newName) ? (Class)this.converter.refreshElement(CollectionType.class, PivotPackage.Literals.COLLECTION_TYPE, (EModelElement)eClass) : this.converter.refreshElement(Class.class, PivotPackage.Literals.CLASS, (EModelElement)eClass)))))))))));
        String oldName = pivotElement.getName();
        boolean bl = nameChange = oldName != newName || oldName != null && !oldName.equals(newName);
        if (nameChange && (parentPackage = pivotElement.getOwningPackage()) != null) {
            parentPackage.getOwnedClasses().remove(pivotElement);
        }
        pivotElement.setName(newName);
        ArrayList<EAnnotation> excludedAnnotations = null;
        EAnnotation duplicatesAnnotation = eClass.getEAnnotation("duplicates");
        if (duplicatesAnnotation != null) {
            excludedAnnotations = new ArrayList<EAnnotation>();
            excludedAnnotations.add(duplicatesAnnotation);
        }
        if ((redefinesAnnotation = eClass.getEAnnotation("redefines")) != null) {
            excludedAnnotations = new ArrayList();
            excludedAnnotations.add(redefinesAnnotation);
        }
        this.copyClassifier(pivotElement, (EClassifier)eClass, excludedAnnotations);
        pivotElement.setIsAbstract(eClass.isAbstract());
        pivotElement.setIsInterface(eClass.isInterface());
        this.doSwitchAll((List<? extends EObject>)eClass.getEGenericSuperTypes());
        List<Operation> pivotOperations = pivotElement.getOwnedOperations();
        List<Constraint> pivotInvariants = pivotElement.getOwnedInvariants();
        for (EOperation eOperation : eClass.getEOperations()) {
            Object pivotObject;
            if (this.converter.isInvariant(eOperation)) {
                pivotObject = this.doSwitch((EObject)eOperation);
                pivotInvariants.add((Constraint)pivotObject);
                continue;
            }
            pivotObject = this.doSwitch((EObject)eOperation);
            pivotOperations.add((Operation)pivotObject);
        }
        List<Property> pivotProperties = pivotElement.getOwnedProperties();
        this.doSwitchAll(pivotProperties, (List<? extends EObject>)eClass.getEStructuralFeatures());
        if (duplicatesAnnotation != null) {
            for (EObject eContent : duplicatesAnnotation.getContents()) {
                if (eContent instanceof EOperation) {
                    if (this.converter.isInvariant((EOperation)eContent)) {
                        Constraint pivotInvariant = (Constraint)this.doSwitch(eContent);
                        pivotInvariants.add(pivotInvariant);
                    } else {
                        Operation pivotOperation = (Operation)this.doSwitch(eContent);
                        pivotOperations.add(pivotOperation);
                    }
                    this.converter.queueReference(eContent);
                    continue;
                }
                if (eContent instanceof EStructuralFeature) {
                    Property pivotProperty = (Property)this.doSwitch(eContent);
                    pivotProperties.add(pivotProperty);
                    this.converter.queueReference(eContent);
                    continue;
                }
                if (eContent instanceof EAnnotation) continue;
                this.converter.error("Unsupported duplicate " + eContent.eClass().getName());
            }
        }
        this.converter.queueReference((EObject)eClass);
        return pivotElement;
    }

    public Object caseEDataType(EDataType eDataType) {
        PivotMetamodelManager metamodelManager;
        Package parentPackage;
        boolean nameChange;
        assert (eDataType != null);
        java.lang.Class instanceClass = eDataType.getInstanceClass();
        String newName = this.technology.getOriginalName((ENamedElement)eDataType);
        boolean isBoolean = false;
        boolean isPrimitive = false;
        if ("Boolean".equals(newName) && (instanceClass == Boolean.class || instanceClass == Boolean.TYPE)) {
            isBoolean = true;
            isPrimitive = true;
        } else if ("Integer".equals(newName) && (instanceClass == IntegerValue.class || instanceClass == Number.class || instanceClass == BigInteger.class || instanceClass == Long.class || instanceClass == Long.TYPE || instanceClass == Integer.class || instanceClass == Integer.TYPE || instanceClass == Short.class || instanceClass == Short.TYPE || instanceClass == Byte.class || instanceClass == Byte.TYPE)) {
            isPrimitive = true;
        } else if ("Real".equals(newName) && (instanceClass == RealValue.class || instanceClass == Number.class || instanceClass == BigDecimal.class || instanceClass == Double.class || instanceClass == Double.TYPE || instanceClass == Float.class || instanceClass == Float.TYPE)) {
            isPrimitive = true;
        } else if ("String".equals(newName) && instanceClass == String.class) {
            isPrimitive = true;
        } else if ("UnlimitedNatural".equals(newName) && (instanceClass == UnlimitedNaturalValue.class || instanceClass == Number.class || instanceClass == BigInteger.class || instanceClass == Long.class || instanceClass == Long.TYPE || instanceClass == Integer.class || instanceClass == Integer.TYPE || instanceClass == Short.class || instanceClass == Short.TYPE || instanceClass == Byte.class || instanceClass == Byte.TYPE)) {
            isPrimitive = true;
        }
        DataType pivotElement = isBoolean ? (DataType)this.converter.refreshElement(BooleanType.class, PivotPackage.Literals.BOOLEAN_TYPE, (EModelElement)eDataType) : (isPrimitive ? (DataType)this.converter.refreshElement(PrimitiveType.class, PivotPackage.Literals.PRIMITIVE_TYPE, (EModelElement)eDataType) : this.converter.refreshElement(DataType.class, PivotPackage.Literals.DATA_TYPE, (EModelElement)eDataType));
        String oldName = pivotElement.getName();
        boolean bl = nameChange = oldName != newName || oldName != null && !oldName.equals(newName);
        if (nameChange && (parentPackage = pivotElement.getOwningPackage()) != null) {
            parentPackage.getOwnedClasses().remove(pivotElement);
        }
        pivotElement.setName(newName);
        this.copyDataTypeOrEnum(pivotElement, eDataType);
        if (isPrimitive) {
            metamodelManager = this.converter.getMetamodelManager();
            CompleteModelInternal completeModelInternal = metamodelManager.getCompleteModel();
            PrimitiveCompletePackageImpl primitiveCompletePackage = completeModelInternal.getPrimitiveCompletePackage();
            CompleteClassInternal completeClass = primitiveCompletePackage.getCompleteClass(pivotElement);
            if (!completeClass.getPartialClasses().contains(pivotElement)) {
                completeClass.addClass(pivotElement);
            }
        } else if (instanceClass != null) {
            try {
                metamodelManager = this.converter.getMetamodelManager();
                StandardLibraryInternal standardLibrary = metamodelManager.getStandardLibrary();
                PrimitiveType behavioralClass = standardLibrary.getBehavioralClass(instanceClass);
                if (behavioralClass == null) {
                    instanceClass.getDeclaredMethod("compareTo", instanceClass);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.converter.queueReference((EObject)eDataType);
        }
        return pivotElement;
    }

    public Object caseEEnum(EEnum eObject) {
        Package parentPackage;
        String newName;
        boolean nameChange;
        @NonNull EEnum eObject2 = eObject;
        Enumeration pivotElement = this.converter.refreshElement(Enumeration.class, PivotPackage.Literals.ENUMERATION, (EModelElement)eObject2);
        String oldName = pivotElement.getName();
        boolean bl = nameChange = oldName != (newName = this.technology.getOriginalName((ENamedElement)eObject2)) || oldName != null && !oldName.equals(newName);
        if (nameChange && (parentPackage = pivotElement.getOwningPackage()) != null) {
            parentPackage.getOwnedClasses().remove(pivotElement);
        }
        pivotElement.setName(newName);
        this.copyDataTypeOrEnum(pivotElement, (EDataType)eObject2);
        this.doSwitchAll(pivotElement.getOwnedLiterals(), (List<? extends EObject>)eObject2.getELiterals());
        return pivotElement;
    }

    public Object caseEEnumLiteral(EEnumLiteral eEnumLiteral) {
        @NonNull EEnumLiteral eEnumLiteral2 = eEnumLiteral;
        EnumerationLiteral pivotElement = this.converter.refreshNamedElement(EnumerationLiteral.class, PivotPackage.Literals.ENUMERATION_LITERAL, (ENamedElement)eEnumLiteral2);
        this.copyNamedElement(pivotElement, (ENamedElement)eEnumLiteral2);
        this.copyAnnotatedElement(pivotElement, (EModelElement)eEnumLiteral2, null);
        if (eEnumLiteral2.eIsSet((EStructuralFeature)EcorePackage.Literals.EENUM_LITERAL__LITERAL)) {
            pivotElement.setLiteral(eEnumLiteral2.getLiteral());
        } else {
            pivotElement.eUnset((EStructuralFeature)PivotPackage.Literals.ENUMERATION_LITERAL__LITERAL);
        }
        if (eEnumLiteral2.eIsSet((EStructuralFeature)EcorePackage.Literals.EENUM_LITERAL__VALUE)) {
            pivotElement.setValue(BigInteger.valueOf(eEnumLiteral2.getValue()));
        } else {
            pivotElement.eUnset((EStructuralFeature)PivotPackage.Literals.ENUMERATION_LITERAL__VALUE);
        }
        return pivotElement;
    }

    public Object caseEGenericType(EGenericType eObject) {
        EClassifier eClassifier = eObject.getEClassifier();
        if (!this.converter.isEcoreOnlyEntryClass(eClassifier)) {
            this.doSwitchAll((List<? extends EObject>)eObject.getETypeArguments());
            this.converter.addGenericType(eObject);
        }
        return true;
    }

    public Object caseEOperation(EOperation eObject) {
        @NonNull EOperation eOperation = eObject;
        if (this.converter.isInvariant(eOperation)) {
            return this.convertEOperation2Constraint(eOperation);
        }
        return this.convertEOperation2Operation(eOperation);
    }

    public Object caseEPackage(EPackage ePackage) {
        boolean nsURIChange;
        assert (ePackage != null);
        Package pivotElement = this.converter.isLibrary(ePackage) ? (Package)this.converter.refreshElement(Library.class, PivotPackage.Literals.LIBRARY, (EModelElement)ePackage) : this.converter.refreshElement(Package.class, PivotPackage.Literals.PACKAGE, (EModelElement)ePackage);
        String oldName = pivotElement.getName();
        String newName = this.technology.getOriginalName((ENamedElement)ePackage);
        String oldNsURI = pivotElement.getURI();
        String newNsURI = ePackage.getNsURI();
        boolean nameChange = oldName != newName || oldName != null && !oldName.equals(newName);
        boolean bl = nsURIChange = oldNsURI != newNsURI || oldNsURI != null && !oldNsURI.equals(newNsURI);
        if (nameChange || nsURIChange) {
            EObject eContainer = pivotElement.eContainer();
            if (eContainer instanceof Model) {
                ((Model)eContainer).getOwnedPackages().remove(pivotElement);
            } else if (eContainer instanceof Package) {
                ((Package)eContainer).getOwnedPackages().remove(pivotElement);
            }
        }
        pivotElement.setName(newName);
        if (ePackage.eIsSet((EStructuralFeature)EcorePackage.Literals.EPACKAGE__NS_URI)) {
            RootPackageId metamodel = this.technology.getMetamodelId(this.environmentFactory, ePackage);
            if (metamodel != null) {
                ((PackageImpl)pivotElement).setPackageId(metamodel);
            }
            pivotElement.setURI(ePackage.getNsURI());
        } else {
            pivotElement.setURI(null);
        }
        if (ePackage.eIsSet((EStructuralFeature)EcorePackage.Literals.EPACKAGE__NS_PREFIX)) {
            pivotElement.setNsPrefix(ePackage.getNsPrefix());
        } else {
            pivotElement.setNsPrefix(null);
        }
        if (!(ePackage.eContainer() instanceof EAnnotation)) {
            String moniker = AS2Moniker.toString(pivotElement);
            AliasAdapter adapter = AliasAdapter.getAdapter(ePackage.eResource());
            if (adapter != null) {
                adapter.getAliasMap().put((EObject)ePackage, moniker);
            }
        }
        ArrayList<EAnnotation> exclusions = new ArrayList<EAnnotation>();
        EAnnotation eAnnotation = ePackage.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore");
        if (eAnnotation != null) {
            exclusions.add(eAnnotation);
        }
        if (ClassUtil.basicGetMetamodelAnnotation(ePackage) != null) {
            exclusions.add(ClassUtil.getMetamodelAnnotation(ePackage));
        }
        this.converter.addMapping((EObject)ePackage, pivotElement);
        this.copyAnnotatedElement(pivotElement, (EModelElement)ePackage, exclusions);
        this.doSwitchAll(pivotElement.getOwnedPackages(), (List<? extends EObject>)ePackage.getESubpackages());
        ArrayList<@NonNull Class> newList = new ArrayList<Class>();
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            if (this.converter.isEcoreOnlyEntryClass(eClassifier)) continue;
            @NonNull Class pivotObject = (Class)this.doSwitch((EObject)eClassifier);
            newList.add(pivotObject);
        }
        PivotUtilInternal.refreshList(pivotElement.getOwnedClasses(), newList);
        return pivotElement;
    }

    public Object caseEParameter(EParameter eObject) {
        @NonNull EParameter eObject2 = eObject;
        Parameter pivotElement = this.converter.refreshNamedElement(Parameter.class, PivotPackage.Literals.PARAMETER, (ENamedElement)eObject2);
        this.copyTypedElement(pivotElement, (ETypedElement)eObject2, null);
        return pivotElement;
    }

    public Object caseEReference(EReference eObject) {
        @NonNull EReference eObject2 = eObject;
        Property pivotElement = this.converter.refreshNamedElement(Property.class, PivotPackage.Literals.PROPERTY, (ENamedElement)eObject2);
        ArrayList<Object> excludedAnnotations = null;
        EAnnotation oppositeRole = eObject2.getEAnnotation("http://schema.omg.org/spec/MOF/2.0/emof.xml");
        if (oppositeRole != null) {
            excludedAnnotations = new ArrayList<EAnnotation>();
            excludedAnnotations.add(oppositeRole);
        }
        if ((oppositeRole = eObject2.getEAnnotation("http://schema.omg.org/spec/MOF/2.0/emof.xml#Property.oppositeRoleName")) != null) {
            if (excludedAnnotations == null) {
                excludedAnnotations = new ArrayList();
            }
            excludedAnnotations.add(oppositeRole);
        }
        this.copyStructuralFeature(pivotElement, (EStructuralFeature)eObject2, excludedAnnotations);
        pivotElement.setIsComposite(eObject2.isContainment());
        pivotElement.setIsResolveProxies(eObject2.isResolveProxies());
        if (eObject2.getEOpposite() != null || excludedAnnotations != null || !eObject2.getEKeys().isEmpty()) {
            this.converter.queueReference((EObject)eObject2);
        }
        return pivotElement;
    }

    public Object caseETypeParameter(ETypeParameter eObject) {
        @NonNull ETypeParameter eObject2 = eObject;
        TemplateParameter pivotElement = this.converter.refreshNamedElement(TemplateParameter.class, PivotPackage.Literals.TEMPLATE_PARAMETER, (ENamedElement)eObject2);
        this.converter.addMapping((EObject)eObject2, pivotElement);
        String name = this.technology.getOriginalName((ENamedElement)eObject2);
        pivotElement.setName(name);
        EList eBounds = eObject2.getEBounds();
        if (!eBounds.isEmpty()) {
            this.doSwitchAll((List<? extends EObject>)eBounds);
            this.converter.queueReference((EObject)eObject2);
        }
        return pivotElement;
    }

    protected @NonNull Constraint convertEOperation2Constraint(@NonNull EOperation eOperation) {
        Constraint constraint = PivotFactory.eINSTANCE.createConstraint();
        constraint.setName(this.technology.getOriginalName((ENamedElement)eOperation));
        constraint.setIsCallable(true);
        String value = null;
        EAnnotation eAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eOperation);
        if (eAnnotation == null) {
            eAnnotation = eOperation.getEAnnotation("http://www.eclipse.org/uml2/2.2.0/GenModel");
        }
        if (eAnnotation == null) {
            eAnnotation = eOperation.getEAnnotation("http://www.eclipse.org/uml2/1.1.0/GenModel");
        }
        if (eAnnotation != null) {
            value = (String)eAnnotation.getDetails().get((Object)"body");
        }
        ExpressionInOCL specification = PivotFactory.eINSTANCE.createExpressionInOCL();
        if (value != null) {
            specification.setBody(value);
        }
        constraint.setOwnedSpecification(specification);
        String commentBody = EcoreUtil.getAnnotation((EModelElement)eOperation, (String)"http://www.eclipse.org/emf/2002/GenModel", (String)"documentation");
        if (commentBody != null) {
            Comment pivotComment = PivotFactory.eINSTANCE.createComment();
            pivotComment.setBody(commentBody.replaceAll("\\r", ""));
            constraint.getOwnedComments().add(pivotComment);
        }
        this.converter.addMapping((EObject)eOperation, constraint);
        return constraint;
    }

    protected @NonNull Operation convertEOperation2Operation(@NonNull EOperation eOperation) {
        Operation pivotElement = this.converter.refreshNamedElement(Operation.class, PivotPackage.Literals.OPERATION, (ENamedElement)eOperation);
        List<EAnnotation> excludedAnnotations = this.convertEOperationEAnnotations(pivotElement, eOperation);
        this.copyTypedElement(pivotElement, (ETypedElement)eOperation, excludedAnnotations);
        this.doSwitchAll(pivotElement.getOwnedParameters(), (List<? extends EObject>)eOperation.getEParameters());
        @NonNull EList eTypeParameters = eOperation.getETypeParameters();
        this.copyTemplateSignature(pivotElement, (List<ETypeParameter>)eTypeParameters);
        this.doSwitchAll((List<? extends EObject>)eOperation.getEGenericExceptions());
        this.converter.queueReference((EObject)eOperation);
        return pivotElement;
    }

    protected @Nullable List<EAnnotation> convertEOperationEAnnotations(@NonNull Operation pivotElement, @NonNull EOperation eOperation) {
        EAnnotation isTransientAnnotation;
        EAnnotation oclAnnotation;
        ArrayList<Object> excludedAnnotations = null;
        EAnnotation redefinesAnnotation = eOperation.getEAnnotation("redefines");
        if (redefinesAnnotation != null) {
            excludedAnnotations = new ArrayList<EAnnotation>();
            excludedAnnotations.add(redefinesAnnotation);
        }
        if ((oclAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eOperation)) == null) {
            oclAnnotation = eOperation.getEAnnotation("http://www.eclipse.org/uml2/2.2.0/GenModel");
        }
        if (oclAnnotation == null) {
            oclAnnotation = eOperation.getEAnnotation("http://www.eclipse.org/uml2/1.1.0/GenModel");
        }
        if (oclAnnotation != null) {
            if (excludedAnnotations == null) {
                excludedAnnotations = new ArrayList();
            }
            excludedAnnotations.add(oclAnnotation);
            ListIterator it = oclAnnotation.getDetails().listIterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String bodyName = null;
                String preName = null;
                String postName = null;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (key.equals("body")) {
                    bodyName = "";
                    if (value != null) {
                        value = PivotUtilInternal.getBodyExpression(value);
                    }
                } else if (key.startsWith("body_")) {
                    bodyName = key.substring(5);
                } else if (key.equals("pre")) {
                    preName = "";
                } else if (key.startsWith("pre_")) {
                    preName = key.substring(4);
                } else if (key.equals("post")) {
                    postName = "";
                } else if (key.startsWith("post_")) {
                    postName = key.substring(5);
                } else {
                    this.converter.error("Unsupported operation constraint " + key);
                    continue;
                }
                ExpressionInOCL specification = PivotFactory.eINSTANCE.createExpressionInOCL();
                specification.setBody(value);
                if (bodyName != null) {
                    pivotElement.setBodyExpression(specification);
                    pivotElement.setImplementation(new EObjectOperation(pivotElement, eOperation, specification));
                    continue;
                }
                Constraint constraint = PivotFactory.eINSTANCE.createConstraint();
                constraint.setOwnedSpecification(specification);
                if (preName != null) {
                    pivotElement.getOwnedPreconditions().add(constraint);
                    constraint.setName(preName);
                } else {
                    pivotElement.getOwnedPostconditions().add(constraint);
                    constraint.setName(postName);
                }
                this.copyAnnotationComment(constraint, oclAnnotation, key);
            }
        }
        if ((isTransientAnnotation = eOperation.getEAnnotation("http://www.eclipse.org/OCL/Pivot/Operation")) != null) {
            if (excludedAnnotations == null) {
                excludedAnnotations = new ArrayList();
            }
            excludedAnnotations.add(isTransientAnnotation);
            String isTransientString = (String)isTransientAnnotation.getDetails().get((Object)"isTransient");
            pivotElement.setIsTransient(isTransientString != null && Boolean.parseBoolean(isTransientString));
        }
        return excludedAnnotations;
    }

    protected void copyClassifier(@NonNull Class pivotElement, @NonNull EClassifier eClassifier, @Nullable List<EAnnotation> excludedAnnotations) {
        excludedAnnotations = this.refreshTypeConstraints(pivotElement, eClassifier, excludedAnnotations);
        this.copyNamedElement(pivotElement, (ENamedElement)eClassifier);
        this.copyAnnotatedElement(pivotElement, (EModelElement)eClassifier, excludedAnnotations);
        if (eClassifier.eIsSet((EStructuralFeature)EcorePackage.Literals.ECLASSIFIER__INSTANCE_CLASS_NAME)) {
            String instanceClassName = eClassifier.getInstanceClassName();
            pivotElement.setInstanceClassName(instanceClassName);
        } else {
            pivotElement.eUnset((EStructuralFeature)PivotPackage.Literals.CLASS__INSTANCE_CLASS_NAME);
        }
        @NonNull EList eTypeParameters = eClassifier.getETypeParameters();
        this.copyTemplateSignature(pivotElement, (List<ETypeParameter>)eTypeParameters);
    }

    protected void copyDataTypeOrEnum(@NonNull DataType pivotElement, @NonNull EDataType eDataType) {
        this.copyClassifier(pivotElement, (EClassifier)eDataType, null);
        pivotElement.setIsSerializable(eDataType.isSerializable());
    }

    protected void copyTemplateSignature(@NonNull TemplateableElement pivotElement, @NonNull List<ETypeParameter> eTypeParameters) {
        if (!eTypeParameters.isEmpty()) {
            TemplateSignature pivotTemplateSignature = PivotFactory.eINSTANCE.createTemplateSignature();
            pivotElement.setOwnedSignature(pivotTemplateSignature);
            this.doSwitchAll(pivotTemplateSignature.getOwnedParameters(), eTypeParameters);
        }
    }

    protected void copyAnnotatedElement(@NonNull NamedElement pivotElement, @NonNull EModelElement eModelElement, List<EAnnotation> excludedAnnotations) {
        List<Element> pivotAnnotations = pivotElement.getOwnedAnnotations();
        for (EAnnotation eAnnotation : eModelElement.getEAnnotations()) {
            EMap details;
            if (excludedAnnotations != null && excludedAnnotations.contains(eAnnotation)) continue;
            String source = eAnnotation.getSource();
            if (Ecore2ASDeclarationSwitch.hasDocumentationKey(source, (EMap<String, String>)(details = eAnnotation.getDetails()))) {
                Comment pivotComment = PivotFactory.eINSTANCE.createComment();
                pivotComment.setBody((String)details.get((Object)"documentation"));
                pivotElement.getOwnedComments().add(pivotComment);
                continue;
            }
            if (Ecore2ASDeclarationSwitch.hasImportKey(source, (EMap<String, String>)details)) continue;
            Annotation pivotAnnotation = (Annotation)this.doSwitch((EObject)eAnnotation);
            pivotAnnotations.add(pivotAnnotation);
        }
    }

    protected void copyAnnotationComment(@NonNull Constraint pivotElement, @NonNull EAnnotation eModelElement, @NonNull String key) {
        pivotElement.getOwnedComments().clear();
        String comment = EcoreUtil.getAnnotation((EModelElement)eModelElement, (String)"http://www.eclipse.org/emf/2002/GenModel", (String)key);
        if (comment != null) {
            Comment pivotComment = PivotFactory.eINSTANCE.createComment();
            pivotComment.setBody(comment);
            pivotElement.getOwnedComments().add(pivotComment);
        }
    }

    protected void copyNamedElement(@NonNull NamedElement pivotElement, @NonNull ENamedElement eNamedElement) {
        this.converter.addMapping((EObject)eNamedElement, pivotElement);
        String name = this.technology.getOriginalName(eNamedElement);
        pivotElement.setName(name);
    }

    protected void copyStructuralFeature(@NonNull Property pivotElement, @NonNull EStructuralFeature eObject, List<EAnnotation> excludedAnnotations) {
        EAnnotation oclAnnotation;
        EAnnotation redefinesAnnotation = eObject.getEAnnotation("redefines");
        if (redefinesAnnotation != null) {
            if (excludedAnnotations == null) {
                excludedAnnotations = new ArrayList<EAnnotation>();
            }
            excludedAnnotations.add(redefinesAnnotation);
        }
        if ((oclAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eObject)) != null) {
            if (excludedAnnotations == null) {
                excludedAnnotations = new ArrayList<EAnnotation>();
            }
            excludedAnnotations.add(oclAnnotation);
            Map.Entry bestEntry = null;
            for (Map.Entry entry : oclAnnotation.getDetails().entrySet()) {
                String key = (String)entry.getKey();
                if (key.equals("derivation")) {
                    bestEntry = entry;
                    continue;
                }
                if (key.equals("initial")) {
                    if (bestEntry != null) continue;
                    bestEntry = entry;
                    continue;
                }
                if (key.equals("get")) {
                    if (bestEntry != null) continue;
                    bestEntry = entry;
                    continue;
                }
                this.converter.error("Unsupported feature constraint " + key);
            }
            if (bestEntry != null) {
                String value = (String)bestEntry.getValue();
                ExpressionInOCL specification = PivotFactory.eINSTANCE.createExpressionInOCL();
                specification.setBody(value);
                pivotElement.setOwnedExpression(specification);
            }
            pivotElement.setImplementation(null);
        }
        this.copyTypedElement(pivotElement, (ETypedElement)eObject, excludedAnnotations);
        pivotElement.setIsReadOnly(!eObject.isChangeable());
        pivotElement.setIsDerived(eObject.isDerived());
        pivotElement.setIsTransient(eObject.isTransient());
        pivotElement.setIsUnsettable(eObject.isUnsettable());
        pivotElement.setIsVolatile(eObject.isVolatile());
    }

    protected void copyTypedElement(@NonNull TypedElement pivotElement, @NonNull ETypedElement eTypedElement, List<EAnnotation> excludedAnnotations) {
        int upper;
        this.copyNamedElement(pivotElement, (ENamedElement)eTypedElement);
        List<EAnnotation> excludedAnnotations2 = excludedAnnotations;
        EAnnotation eAnnotation = eTypedElement.getEAnnotation("http://www.eclipse.org/OCL/Collection");
        if (eAnnotation != null) {
            excludedAnnotations2 = excludedAnnotations != null ? new ArrayList<EAnnotation>(excludedAnnotations) : new ArrayList();
            excludedAnnotations2.add(eAnnotation);
        }
        this.copyAnnotatedElement(pivotElement, (EModelElement)eTypedElement, excludedAnnotations2);
        int lower = eTypedElement.getLowerBound();
        if (lower == 0 && this.converter.cannotBeOptional(eTypedElement)) {
            Ecore2AS.NOT_OPTIONAL.println(String.valueOf(NameUtil.qualifiedNameFor(eTypedElement)) + " converted to not-optional");
            lower = 1;
        }
        pivotElement.setIsRequired((upper = eTypedElement.getUpperBound()) == 1 && lower == 1);
        EGenericType eGenericType = eTypedElement.getEGenericType();
        if (eGenericType != null) {
            this.doInPackageSwitch((EObject)eGenericType);
            this.converter.queueReference((EObject)eTypedElement);
        }
    }

    public Element defaultCase(EObject object) {
        this.converter.error("Unsupported " + object.eClass().getName() + " for Ecore2ASDeclarationSwitch");
        return null;
    }

    public Object doInPackageSwitch(EObject eObject) {
        EClass eClass = eObject.eClass();
        if (eClass.getEPackage() != EcorePackage.eINSTANCE) {
            this.converter.error("Non Ecore " + eClass.getName() + " for Ecore2ASDeclarationSwitch");
            return null;
        }
        int classifierID = eClass.getClassifierID();
        return this.doSwitch(classifierID, eObject);
    }

    public <T extends Element> void doSwitchAll(List<T> pivotObjects, List<? extends EObject> eObjects) {
        ArrayList<Element> newList = new ArrayList<Element>();
        for (EObject eObject : eObjects) {
            Element pivotObject = (Element)this.doSwitch(eObject);
            newList.add(pivotObject);
        }
        PivotUtilInternal.refreshList(pivotObjects, newList);
    }

    public <T extends Element> void doSwitchAll(List<? extends EObject> eObjects) {
        for (EObject eObject : eObjects) {
            this.doSwitch(eObject);
        }
    }

    protected List<EAnnotation> refreshTypeConstraints(@NonNull Class pivotElement, @NonNull EClassifier eClassifier, @Nullable List<EAnnotation> excludedAnnotations) {
        EAnnotation ecoreAnnotation;
        EAnnotation oclAnnotation;
        EMap oclAnnotationDetails = null;
        HashMap<String, Constraint> newConstraintMap = null;
        HashMap<String, Constraint> oldInvariantMap = null;
        ArrayList<Constraint> newInvariants = null;
        List<Constraint> oldInvariants = pivotElement.getOwnedInvariants();
        if (oldInvariants.size() > 0) {
            oldInvariantMap = new HashMap<String, Constraint>();
            for (Constraint oldInvariant : oldInvariants) {
                oldInvariantMap.put(oldInvariant.getName(), oldInvariant);
            }
        }
        if ((oclAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eClassifier)) != null) {
            if (excludedAnnotations == null) {
                excludedAnnotations = new ArrayList<EAnnotation>();
            }
            excludedAnnotations.add(oclAnnotation);
            oclAnnotationDetails = oclAnnotation.getDetails();
            ListIterator it = oclAnnotationDetails.listIterator();
            while (it.hasNext()) {
                ExpressionInOCL expression;
                String messageAnnotationDetailSuffix;
                Map.Entry entry = (Map.Entry)it.next();
                String invariantName = (String)entry.getKey();
                if (invariantName == null) {
                    invariantName = "";
                }
                if (invariantName.endsWith(messageAnnotationDetailSuffix = "$message")) continue;
                Constraint invariant = null;
                LanguageExpression specification = null;
                if (oldInvariantMap != null) {
                    invariant = (Constraint)oldInvariantMap.get(invariantName);
                }
                if (invariant == null) {
                    invariant = PivotFactory.eINSTANCE.createConstraint();
                    invariant.setName(invariantName);
                } else {
                    specification = invariant.getOwnedSpecification();
                }
                if (specification instanceof ExpressionInOCL) {
                    expression = (ExpressionInOCL)specification;
                } else {
                    expression = PivotFactory.eINSTANCE.createExpressionInOCL();
                    invariant.setOwnedSpecification(expression);
                    ParameterVariable contextVariable = PivotFactory.eINSTANCE.createParameterVariable();
                    contextVariable.setName("self");
                    contextVariable.setType(pivotElement);
                    contextVariable.setIsRequired(contextVariable.isIsRequired());
                    expression.setOwnedContext(contextVariable);
                }
                String value = (String)entry.getValue();
                String message = (String)oclAnnotationDetails.get((Object)(String.valueOf(invariantName) + messageAnnotationDetailSuffix));
                if (value != null && message != null) {
                    value = PivotUtil.createTupleValuedConstraint(value, null, message);
                }
                expression.setBody(value);
                if (newInvariants == null) {
                    newInvariants = new ArrayList();
                }
                newInvariants.add(invariant);
                if (newConstraintMap == null) {
                    newConstraintMap = new HashMap();
                }
                newConstraintMap.put(invariantName, invariant);
                this.copyAnnotationComment(invariant, oclAnnotation, "documentation");
            }
        }
        if ((ecoreAnnotation = eClassifier.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore")) != null) {
            if (excludedAnnotations == null) {
                excludedAnnotations = new ArrayList<EAnnotation>();
            }
            excludedAnnotations.add(ecoreAnnotation);
            String invariantNameList = (String)ecoreAnnotation.getDetails().get((Object)"constraints");
            if (invariantNameList != null) {
                String[] invariantNames;
                String[] stringArray = invariantNames = invariantNameList.split(" ");
                int n = invariantNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String invariantName = stringArray[n2];
                    if (oclAnnotationDetails == null || !oclAnnotationDetails.containsKey((Object)invariantName)) {
                        Constraint invariant = null;
                        if (newConstraintMap != null) {
                            invariant = (Constraint)newConstraintMap.get(invariantName);
                        }
                        if (invariant == null) {
                            invariant = PivotFactory.eINSTANCE.createConstraint();
                            invariant.setName(invariantName);
                        }
                        ExpressionInOCL specification = PivotFactory.eINSTANCE.createExpressionInOCL();
                        invariant.setOwnedSpecification(specification);
                        if (newInvariants == null) {
                            newInvariants = new ArrayList<Constraint>();
                        }
                        newInvariants.add(invariant);
                        if (newConstraintMap == null) {
                            newConstraintMap = new HashMap<String, Constraint>();
                        }
                        newConstraintMap.put(invariantName, invariant);
                    }
                    ++n2;
                }
            }
        }
        if (newInvariants != null) {
            this.converter.refreshList(oldInvariants, newInvariants);
        } else {
            oldInvariants.clear();
        }
        return excludedAnnotations;
    }
}

