/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.lemminx.bnd;

import aQute.bnd.help.Syntax;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.services.extensions.IXMLExtension;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.services.extensions.completion.ICompletionParticipant;
import org.eclipse.lemminx.services.extensions.completion.ICompletionRequest;
import org.eclipse.lemminx.services.extensions.completion.ICompletionResponse;
import org.eclipse.lemminx.services.extensions.save.ISaveContext;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class BndLemminxPlugin
implements IXMLExtension {
    public void start(InitializeParams params, XMLExtensionsRegistry registry) {
        final Logger logger = Logger.getLogger("bnd");
        logger.log(Level.INFO, "Loading bnd-lemminx extension");
        registry.registerCompletionParticipant(new ICompletionParticipant(){

            public void onAttributeName(boolean generateValue, ICompletionRequest completionRequest, ICompletionResponse response, CancelChecker checker) throws Exception {
            }

            public void onAttributeValue(String valuePrefix, ICompletionRequest completionRequest, ICompletionResponse response, CancelChecker checker) throws Exception {
            }

            public void onDTDSystemId(String valuePrefix, ICompletionRequest completionRequest, ICompletionResponse response, CancelChecker checker) throws Exception {
            }

            public void onTagOpen(ICompletionRequest completionRequest, ICompletionResponse response, CancelChecker checker) throws Exception {
            }

            public void onXMLContent(ICompletionRequest completionRequest, ICompletionResponse response, CancelChecker checker) throws Exception {
                try {
                    DOMDocument xmlDocument = completionRequest.getXMLDocument();
                    DOMNode node = xmlDocument.findNodeBefore(completionRequest.getOffset());
                    logger.log(Level.INFO, "onXMLContent: " + String.valueOf(node));
                    if (BndLemminxPlugin.isBndInstructionNode(node)) {
                        this.addCompletion(response, syntax -> syntax.getHeader() + ": ");
                    } else if (BndLemminxPlugin.isFelixInstructionNode(node)) {
                        this.addCompletion(response, syntax -> {
                            Object header = syntax.getHeader();
                            if (((String)header).startsWith("-")) {
                                header = "_" + ((String)header).substring(1);
                            }
                            return String.format("<%s>${0}</%s>", header, header);
                        });
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "err=" + String.valueOf(e));
                }
            }

            private void addCompletion(ICompletionResponse response, Function<Syntax, String> insert) {
                Syntax.HELP.values().stream().forEach(syntax -> {
                    CompletionItem item = new CompletionItem();
                    item.setLabel(syntax.getHeader());
                    item.setDocumentation(syntax.getLead());
                    item.setDetail(syntax.getExample());
                    item.setInsertText((String)insert.apply((Syntax)syntax));
                    item.setKind(CompletionItemKind.Property);
                    item.setInsertTextFormat(InsertTextFormat.Snippet);
                    response.addCompletionItem(item);
                });
            }
        });
    }

    private static boolean isBndInstructionNode(DOMNode node) {
        if (node != null) {
            if (node.getNodeName().equals("bnd")) {
                return true;
            }
            return BndLemminxPlugin.isBndInstructionNode(node.getParentNode());
        }
        return false;
    }

    private static boolean isFelixInstructionNode(DOMNode node) {
        if (node != null) {
            if (node.getNodeName().equals("instructions")) {
                return true;
            }
            return BndLemminxPlugin.isFelixInstructionNode(node.getParentNode());
        }
        return false;
    }

    public void stop(XMLExtensionsRegistry registry) {
    }

    public void doSave(ISaveContext context) {
        super.doSave(context);
    }
}

