/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.webxml.internal;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.javaee.web.Filter;
import org.eclipse.jst.javaee.web.Servlet;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jsf.common.webxml.WebXmlUtils;
import org.eclipse.jst.jsf.common.webxml.WebXmlUtilsForJavaEE;
import org.eclipse.jst.jsf.common.webxml.internal.AbstractWebXmlUpdater;
import org.eclipse.jst.jsf.common.webxml.internal.operations.ContextParamAdderForJavaEE;
import org.eclipse.jst.jsf.common.webxml.internal.operations.FilterAdderForJavaEE;
import org.eclipse.jst.jsf.common.webxml.internal.operations.FilterMapperAdderForJavaEE;
import org.eclipse.jst.jsf.common.webxml.internal.operations.FilterRemoverForJavaEE;
import org.eclipse.jst.jsf.common.webxml.internal.operations.ListenerAdderForJavaEE;
import org.eclipse.jst.jsf.common.webxml.internal.operations.ServletAdderForJavaEE;
import org.eclipse.jst.jsf.common.webxml.internal.operations.ServletMappingAdderForJavaEE;
import org.eclipse.jst.jsf.common.webxml.internal.operations.ServletRemoverForJavaEE;

public class WebXmlUpdaterForJavaEE
extends AbstractWebXmlUpdater {
    private final WebApp webApp;

    public WebXmlUpdaterForJavaEE(Object webAppObj, IProject project, IModelProvider provider, IProgressMonitor monitor) {
        super(webAppObj, project, provider, monitor);
        this.webApp = (WebApp)webAppObj;
    }

    @Override
    public void addServlet(String servletName, String servletClass, String loadOnStartup) {
        this.provider.modify((Runnable)new ServletAdderForJavaEE(this.project, servletName, servletClass, loadOnStartup), WebXmlUtils.WEB_XML_PATH);
    }

    @Override
    public void removeServlet(String servletClassName) {
        Servlet servlet = WebXmlUtilsForJavaEE.findServlet(servletClassName, this.webApp);
        if (servlet == null) {
            throw new IllegalArgumentException("Cannot find servlet named \"" + servletClassName + "\"");
        }
        this.provider.modify((Runnable)new ServletRemoverForJavaEE(this.project, servletClassName), WebXmlUtils.WEB_XML_PATH);
    }

    @Override
    public void addServletMapping(String servletName, String servletClass, String urlPattern) {
        this.provider.modify((Runnable)new ServletMappingAdderForJavaEE(this.project, servletName, servletClass, urlPattern), WebXmlUtils.WEB_XML_PATH);
    }

    @Override
    public void addFilter(String filterName, String filterClass) {
        this.provider.modify((Runnable)new FilterAdderForJavaEE(this.project, filterName, filterClass), WebXmlUtils.WEB_XML_PATH);
    }

    @Override
    public void removeFilter(String filterClassName) {
        Filter filter = WebXmlUtilsForJavaEE.findFilter(this.webApp, filterClassName);
        if (filter == null) {
            throw new IllegalArgumentException("Cannot find filter named \"" + filterClassName + "\"");
        }
        this.provider.modify((Runnable)new FilterRemoverForJavaEE(this.project, filterClassName), WebXmlUtils.WEB_XML_PATH);
    }

    @Override
    public void addFilterMapping(String filterName, String filterClass, String servletName) {
        this.provider.modify((Runnable)new FilterMapperAdderForJavaEE(this.project, filterName, servletName), WebXmlUtils.WEB_XML_PATH);
    }

    @Override
    public String getContextParamValue(String paramName) {
        return WebXmlUtilsForJavaEE.getContextParamValue(this.webApp, paramName);
    }

    @Override
    public List<String> getContextParamValuesAsList(String paramName, String valuesDelimiterRegex) {
        return WebXmlUtilsForJavaEE.getContextParamValuesAsList(this.webApp, paramName, valuesDelimiterRegex);
    }

    @Override
    public void setContextParamValue(String paramName, String paramValue) {
        WebXmlUtilsForJavaEE.setContextParamValue(this.webApp, paramName, paramValue);
    }

    @Override
    public void addContextParam(String paramName, String paramValue, String description) {
        this.provider.modify((Runnable)new ContextParamAdderForJavaEE(this.project, paramName, paramValue, description), WebXmlUtils.WEB_XML_PATH);
    }

    @Override
    public void addListener(String listenerClass) {
        this.provider.modify((Runnable)new ListenerAdderForJavaEE(this.project, listenerClass), WebXmlUtils.WEB_XML_PATH);
    }

    @Override
    public Object getWebApp() {
        return this.webApp;
    }
}

