/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.ui.properties;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.gef.mvc.fx.ui.properties.UndoablePropertySheetEntry;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.operations.UndoRedoActionGroup;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class UndoablePropertySheetPage
extends PropertySheetPage {
    private final IOperationHistory operationHistory;
    private IUndoContext undoContext;
    private IWorkbenchPart workbenchPart;
    private final IOperationHistoryListener operationHistoryListener;
    private UndoRedoActionGroup actionGroup;

    @Inject
    public UndoablePropertySheetPage(@Assisted IWorkbenchPart workbenchPart, IOperationHistory operationHistory, IUndoContext undoContext) {
        this.workbenchPart = workbenchPart;
        this.operationHistory = operationHistory;
        this.undoContext = undoContext;
        this.operationHistoryListener = new IOperationHistoryListener(){

            public void historyNotification(OperationHistoryEvent event) {
                if (event.getEventType() == 2 || event.getEventType() == 3) {
                    UndoablePropertySheetPage.this.refresh();
                }
            }
        };
        operationHistory.addOperationHistoryListener(this.operationHistoryListener);
        this.setRootEntry((IPropertySheetEntry)this.createRootEntry());
    }

    protected UndoablePropertySheetEntry createRootEntry() {
        return new UndoablePropertySheetEntry(this.workbenchPart, this.operationHistory, this.undoContext);
    }

    public void dispose() {
        if (this.actionGroup != null) {
            this.actionGroup.dispose();
        }
        if (this.operationHistory != null) {
            this.operationHistory.removeOperationHistoryListener(this.operationHistoryListener);
        }
        super.dispose();
    }

    public IWorkbenchPart getWorkbenchPart() {
        return this.workbenchPart;
    }

    public void setActionBars(IActionBars actionBars) {
        super.setActionBars(actionBars);
        if (this.actionGroup == null) {
            this.actionGroup = new UndoRedoActionGroup(this.workbenchPart.getSite(), this.undoContext, true);
        }
        this.actionGroup.fillActionBars(actionBars);
    }
}

