/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.eclipse.emf.cdo.internal.server.ServerDebugUtil;
import org.eclipse.emf.cdo.server.CDOServerBrowser;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.factory.Factory;
import org.eclipse.net4j.util.factory.ProductCreationException;

public abstract class DBBrowserPage
extends CDOServerBrowser.AbstractPage {
    protected DBBrowserPage(String name, String label) {
        super(name, label);
    }

    public boolean canDisplay(InternalRepository repository) {
        return repository.getStore() instanceof IDBConnectionProvider;
    }

    public void display(CDOServerBrowser browser, InternalRepository repository, PrintStream out) {
        block10: {
            IDBStore store = (IDBStore)repository.getStore();
            Connection connection = null;
            boolean closeConnection = true;
            try {
                try {
                    IStoreAccessor debugAccessor = ServerDebugUtil.getAccessor((IRepository)repository);
                    if (debugAccessor instanceof IDBStoreAccessor) {
                        connection = ((IDBStoreAccessor)debugAccessor).getConnection();
                        closeConnection = false;
                    } else {
                        connection = store.getConnection();
                    }
                    IDBSchema schema = store.getDBSchema();
                    this.display(browser, repository, out, connection, schema);
                }
                catch (DBException ex) {
                    ex.printStackTrace();
                    if (closeConnection) {
                        DBUtil.close(connection);
                    }
                    break block10;
                }
            }
            catch (Throwable throwable) {
                if (closeConnection) {
                    DBUtil.close(connection);
                }
                throw throwable;
            }
            if (closeConnection) {
                DBUtil.close((Connection)connection);
            }
        }
    }

    protected abstract void display(CDOServerBrowser var1, InternalRepository var2, PrintStream var3, Connection var4, IDBSchema var5);

    protected void executeQuery(CDOServerBrowser browser, PrintStream pout, Connection connection, String title, boolean ordering, String sql) {
        String order = browser.getParam("order");
        String direction = browser.getParam("direction");
        String highlight = browser.getParam("highlight");
        boolean schema = browser.isParam("schema");
        Statement stmt = null;
        ResultSet resultSet = null;
        try {
            try {
                stmt = connection.createStatement();
                resultSet = stmt.executeQuery(sql);
                ResultSetMetaData metaData = resultSet.getMetaData();
                int columns = metaData.getColumnCount();
                pout.print("<table border=\"1\" cellpadding=\"2\">\r\n");
                pout.print("<tr><td colspan=\"" + (1 + columns) + "\" align=\"center\"><b>" + title + "</b></td></tr>\r\n");
                pout.print("<tr>\r\n");
                pout.print("<td>&nbsp;</td>\r\n");
                int i = 0;
                while (i < columns) {
                    String column = metaData.getColumnLabel(1 + i);
                    String type = String.valueOf(metaData.getColumnTypeName(1 + i).toLowerCase()) + "(" + metaData.getPrecision(1 + i) + ")";
                    if (ordering) {
                        String dir = column.equals(order) && "ASC".equals(direction) ? "DESC" : "ASC";
                        column = browser.href(column, this.getName(), new String[]{"order", column, "direction", dir});
                    }
                    pout.print("<td align=\"center\"><b>" + column);
                    pout.print("</b><br>" + type + "</td>\r\n");
                    ++i;
                }
                pout.print("</tr>\r\n");
                if (!schema) {
                    int row = 0;
                    while (resultSet.next()) {
                        pout.print("<tr>\r\n");
                        pout.print("<td><b>" + ++row + "</b></td>\r\n");
                        int i2 = 0;
                        while (i2 < columns) {
                            String value = resultSet.getString(1 + i2);
                            String bgcolor = highlight != null && highlight.equals(value) ? " bgcolor=\"#fffca6\"" : "";
                            pout.print("<td" + bgcolor + ">" + browser.href(value, this.getName(), new String[]{"highlight", value}) + "</td>\r\n");
                            ++i2;
                        }
                        pout.print("</tr>\r\n");
                    }
                }
                pout.print("</table>\r\n");
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            DBUtil.close((Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
    }

    public static final class Queries
    extends DBBrowserPage {
        public static final String NAME = "db-queries";

        public Queries() {
            super(NAME, "DB Queries");
        }

        @Override
        protected void display(CDOServerBrowser browser, InternalRepository repository, PrintStream out, Connection connection, IDBSchema schema) {
            String query = browser.getParam("query");
            out.print("<table border=\"0\">\r\n");
            out.print("<tr>\r\n");
            out.print("<td valign=\"top\">\r\n");
            out.print("<form method=\"get\">\r\n");
            out.print("<textarea name=\"query\" rows=\"10\" cols=\"160\">\r\n");
            if (query != null) {
                query = query.trim();
                out.print(query);
            }
            out.print("</textarea>\r\n");
            out.print("<br><br>\r\n");
            out.print("<input type=\"submit\" value=\"Submit\"/>\r\n");
            if (!DBUtil.DISABLE_QUOTED_NAMES) {
                out.print("&nbsp;Table and column names may need to be quoted!\r\n");
            }
            out.print("</form>\r\n");
            out.print("</td>\r\n");
            out.print("</tr>\r\n");
            if (query != null) {
                out.print("<tr>\r\n");
                out.print("<td valign=\"top\">\r\n");
                try {
                    this.executeQuery(browser, out, connection, "Results", false, query);
                }
                catch (DBException ex) {
                    String message = this.getMessage(ex);
                    if (message != null) {
                        message = message.replace("\r\n", "<br>");
                        message = message.replace("\n", "<br>");
                    }
                    out.print("<font color=\"red\"><b>");
                    out.print("<pre>");
                    out.print(message);
                    out.print("</pre>");
                    out.print("</b></font>");
                }
                out.print("</td>\r\n");
                out.print("</tr>\r\n");
            }
            out.print("</table>\r\n");
        }

        private String getMessage(Throwable ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof SQLException) {
                return cause.getMessage();
            }
            return ex.getMessage();
        }

        public static class Factory
        extends org.eclipse.net4j.util.factory.Factory {
            public Factory() {
                super("org.eclipse.emf.cdo.server.browserPages", Queries.NAME);
            }

            public DBBrowserPage create(String description) throws ProductCreationException {
                return new Queries();
            }
        }
    }

    public static final class Tables
    extends DBBrowserPage {
        public static final String NAME = "db-tables";

        public Tables() {
            super(NAME, "DB Tables");
        }

        @Override
        protected void display(CDOServerBrowser browser, InternalRepository repository, PrintStream out, Connection connection, IDBSchema schema) {
            out.print("<table border=\"0\">\r\n");
            out.print("<tr>\r\n");
            out.print("<td valign=\"top\">\r\n");
            String tableName = this.showTables(browser, out, connection, schema);
            out.print("</td>\r\n");
            if (tableName != null) {
                out.print("<td valign=\"top\">\r\n");
                this.showTable(browser, out, connection, schema, tableName);
                out.print("</td>\r\n");
            }
            out.print("</tr>\r\n");
            out.print("</table>\r\n");
        }

        protected String showTables(CDOServerBrowser browser, PrintStream pout, Connection connection, IDBSchema schema) {
            String currentTable = browser.getParam("table");
            boolean used = browser.isParam("used");
            boolean hideRowData = browser.isParam("schema");
            pout.print("<table border=\"0\">\r\n");
            pout.print("<tr><td><b>Empty tables:</b></td><td><b>" + browser.href(used ? "Hidden" : "Shown", this.getName(), new String[]{"used", String.valueOf(!used)}) + "</b></td></tr>\r\n");
            pout.print("<tr><td><b>Row data:</b></td><td><b>" + browser.href(hideRowData ? "Hidden" : "Shown", this.getName(), new String[]{"schema", String.valueOf(!hideRowData)}) + "</b></td></tr>\r\n");
            pout.print("</table><br>\r\n");
            int totalRows = 0;
            int usedTables = 0;
            List allTableNames = DBUtil.getAllTableNames((Connection)connection, (String)schema.getName(), (boolean)schema.isCaseSensitive());
            for (String tableName : allTableNames) {
                if (currentTable == null) {
                    currentTable = tableName;
                }
                String label = browser.escape(tableName);
                int rowCount = DBUtil.getRowCount((Connection)connection, (String)this.getTableName(tableName, schema));
                if (rowCount > 0) {
                    totalRows += rowCount;
                    ++usedTables;
                } else if (used) continue;
                if (tableName.equals(currentTable)) {
                    pout.print("<b>" + label + "</b>");
                } else {
                    pout.print(browser.href(label, this.getName(), new String[]{"table", tableName, "order", null, "direction", null}));
                }
                if (rowCount > 0) {
                    pout.print("&nbsp;(" + rowCount + ")");
                }
                pout.print("<br>\r\n");
            }
            if (totalRows != 0) {
                int totalTables = allTableNames.size();
                int emptyTables = totalTables - usedTables;
                pout.print("<br>" + totalTables + " tables total\r\n");
                pout.print("<br>" + usedTables + " tables used (" + totalRows + " rows)\r\n");
                pout.print("<br>" + emptyTables + " tables empty<br>\r\n");
            }
            return currentTable;
        }

        protected void showTable(CDOServerBrowser browser, PrintStream pout, Connection connection, IDBSchema schema, String tableName) {
            String firstColumn;
            String columns;
            block10: {
                columns = "*";
                firstColumn = null;
                ResultSet resultSet = null;
                try {
                    try {
                        StringBuilder builder = new StringBuilder();
                        DatabaseMetaData metaData = connection.getMetaData();
                        resultSet = metaData.getColumns(null, null, tableName, null);
                        while (resultSet.next()) {
                            String name = resultSet.getString("COLUMN_NAME");
                            if (firstColumn == null) {
                                firstColumn = name;
                            }
                            StringUtil.appendSeparator((StringBuilder)builder, (String)", ");
                            builder.append(DBUtil.quoted((String)name));
                        }
                        columns = builder.toString();
                    }
                    catch (Exception builder) {
                        DBUtil.close(resultSet);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    DBUtil.close(resultSet);
                    throw throwable;
                }
                DBUtil.close((ResultSet)resultSet);
            }
            String sqlTableName = this.getTableName(tableName, schema);
            String sql = "SELECT " + columns + " FROM " + sqlTableName;
            if (firstColumn != null) {
                sql = String.valueOf(sql) + " ORDER BY " + DBUtil.quoted((String)firstColumn) + " ASC";
            }
            String title = browser.href(tableName, "db-queries", new String[]{"query", sql});
            try {
                String order = browser.getParam("order");
                this.executeQuery(browser, pout, connection, title, true, "SELECT * FROM " + sqlTableName + (order == null ? "" : " ORDER BY " + DBUtil.quoted((String)order) + " " + browser.getParam("direction")));
            }
            catch (Exception ex) {
                browser.removeParam("order");
                browser.removeParam("direction");
                this.executeQuery(browser, pout, connection, tableName, true, "SELECT * FROM " + sqlTableName);
            }
        }

        private String getTableName(String tableName, IDBSchema schema) {
            tableName = DBUtil.quoted((String)tableName);
            if (schema.isQualifiedTableNames()) {
                tableName = String.valueOf(DBUtil.quoted((String)schema.getName())) + '.' + tableName;
            }
            return tableName;
        }

        public static class Factory
        extends org.eclipse.net4j.util.factory.Factory {
            public Factory() {
                super("org.eclipse.emf.cdo.server.browserPages", Tables.NAME);
            }

            public DBBrowserPage create(String description) throws ProductCreationException {
                return new Tables();
            }
        }
    }
}

