/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir.util.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.queryrender.sparql.TupleExprIRRenderer;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrGraph;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPathTriple;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrStatementPattern;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrSubSelect;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrUnion;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.transform.BaseTransform;

public final class FuseUnionOfSimpleTriplesTransform
extends BaseTransform {
    private FuseUnionOfSimpleTriplesTransform() {
    }

    public static IrBGP apply(IrBGP bgp, TupleExprIRRenderer r) {
        if (bgp == null) {
            return null;
        }
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        Iterator<IrNode> iterator = bgp.getLines().iterator();
        while (iterator.hasNext()) {
            IrNode n;
            IrNode m = n = iterator.next();
            if (n instanceof IrUnion) {
                IrUnion u = (IrUnion)n;
                if (u.isNewScope()) {
                    IrUnion u2 = new IrUnion(u.isNewScope());
                    for (IrBGP b : u.getBranches()) {
                        u2.addBranch(FuseUnionOfSimpleTriplesTransform.apply(b, r));
                    }
                    m = u2;
                } else {
                    Fused f = FuseUnionOfSimpleTriplesTransform.tryFuseUnion(u, r);
                    if (f != null) {
                        ArrayList<String> alts = new ArrayList<String>(f.steps);
                        Object alt = String.join((CharSequence)"|", alts);
                        if (alts.size() > 1) {
                            alt = "(" + (String)alt + ")";
                        }
                        if (f.graph != null) {
                            IrBGP inner = new IrBGP(false);
                            IrPathTriple np = new IrPathTriple(f.s, (String)alt, f.o, u.isNewScope(), Collections.emptySet());
                            inner.add(np);
                            m = new IrGraph(f.graph, inner, false);
                        } else {
                            IrPathTriple npTop = new IrPathTriple(f.s, (String)alt, f.o, u.isNewScope(), Collections.emptySet());
                            m = npTop;
                        }
                    } else {
                        IrUnion u2 = new IrUnion(u.isNewScope());
                        for (IrBGP b : u.getBranches()) {
                            u2.addBranch(FuseUnionOfSimpleTriplesTransform.apply(b, r));
                        }
                        m = u2;
                    }
                }
            } else if (!(n instanceof IrSubSelect)) {
                m = BaseTransform.rewriteContainers(n, child -> FuseUnionOfSimpleTriplesTransform.apply(child, r));
            }
            out.add(m);
        }
        return BaseTransform.bgpWithLines(bgp, out);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Fused tryFuseUnion(IrUnion u, TupleExprIRRenderer r) {
        if (u == null || u.getBranches().size() < 2) {
            return null;
        }
        Var graphRef = null;
        Var sCommon = null;
        Var oCommon = null;
        ArrayList<Object> steps = new ArrayList<Object>();
        for (IrBGP b : u.getBranches()) {
            IrStatementPattern sp;
            Var g = null;
            if (b.getLines().size() == 1 && b.getLines().get(0) instanceof IrStatementPattern) {
                sp = (IrStatementPattern)b.getLines().get(0);
            } else {
                if (b.getLines().size() != 1 || !(b.getLines().get(0) instanceof IrGraph)) return null;
                IrGraph gb = (IrGraph)b.getLines().get(0);
                if (gb.getWhere() == null || gb.getWhere().getLines().size() != 1 || !(gb.getWhere().getLines().get(0) instanceof IrStatementPattern)) return null;
                sp = (IrStatementPattern)gb.getWhere().getLines().get(0);
                g = gb.getGraph();
            }
            if (!FuseUnionOfSimpleTriplesTransform.isConstantIriPredicate(sp)) {
                return null;
            }
            String step = FuseUnionOfSimpleTriplesTransform.iri(sp.getPredicate(), r);
            if (sCommon == null && oCommon == null) {
                Var sVar = sp.getSubject();
                Var oVar = sp.getObject();
                sCommon = sVar;
                oCommon = oVar;
                graphRef = g;
                steps.add(step);
                continue;
            }
            if (FuseUnionOfSimpleTriplesTransform.sameVar(sCommon, sp.getSubject()) && FuseUnionOfSimpleTriplesTransform.sameVar(oCommon, sp.getObject())) {
                steps.add(step);
            } else {
                if (!FuseUnionOfSimpleTriplesTransform.sameVar(sCommon, sp.getObject()) || !FuseUnionOfSimpleTriplesTransform.sameVar(oCommon, sp.getSubject())) return null;
                steps.add("^" + step);
            }
            if (!(graphRef == null && g != null || graphRef != null && g == null) && (graphRef == null || FuseUnionOfSimpleTriplesTransform.sameVarOrValue(graphRef, g))) continue;
            return null;
        }
        if (steps.size() < 2) return null;
        Fused f = new Fused(graphRef, sCommon, oCommon);
        f.steps.addAll(steps);
        return f;
    }

    static final class Fused {
        final Var graph;
        final Var s;
        final Var o;
        final List<String> steps = new ArrayList<String>();

        Fused(Var graph, Var s, Var o) {
            this.graph = graph;
            this.s = s;
            this.o = o;
        }
    }
}

