/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.base.config;

import java.util.Optional;
import org.eclipse.rdf4j.common.transaction.QueryEvaluationMode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Configurations;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.CONFIG;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategyFactory;
import org.eclipse.rdf4j.sail.base.config.BaseSailSchema;
import org.eclipse.rdf4j.sail.config.AbstractSailImplConfig;
import org.eclipse.rdf4j.sail.config.SailConfigException;

public abstract class BaseSailConfig
extends AbstractSailImplConfig {
    private String evalStratFactoryClassName;
    private QueryEvaluationMode defaultQueryEvaluationMode;

    protected BaseSailConfig(String type) {
        super(type);
    }

    public String getEvaluationStrategyFactoryClassName() {
        return this.evalStratFactoryClassName;
    }

    public void setEvaluationStrategyFactoryClassName(String className) {
        this.evalStratFactoryClassName = className;
    }

    public EvaluationStrategyFactory getEvaluationStrategyFactory() throws SailConfigException {
        if (this.evalStratFactoryClassName == null) {
            return null;
        }
        try {
            EvaluationStrategyFactory factory = (EvaluationStrategyFactory)Thread.currentThread().getContextClassLoader().loadClass(this.evalStratFactoryClassName).newInstance();
            return factory;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new SailConfigException((Throwable)e);
        }
    }

    public Resource export(Model graph) {
        if (Configurations.useLegacyConfig()) {
            return this.exportLegacy(graph);
        }
        Resource implNode = super.export(graph);
        if (this.evalStratFactoryClassName != null) {
            graph.add(implNode, CONFIG.Sail.evaluationStrategyFactory, (Value)Values.literal((String)this.evalStratFactoryClassName), new Resource[0]);
        }
        this.getDefaultQueryEvaluationMode().ifPresent(mode -> graph.add(implNode, CONFIG.Sail.defaultQueryEvaluationMode, (Value)Values.literal((String)mode.getValue()), new Resource[0]));
        return implNode;
    }

    private Resource exportLegacy(Model graph) {
        Resource implNode = super.export(graph);
        if (this.evalStratFactoryClassName != null) {
            graph.add(implNode, BaseSailSchema.EVALUATION_STRATEGY_FACTORY, (Value)Values.literal((String)this.evalStratFactoryClassName), new Resource[0]);
        }
        this.getDefaultQueryEvaluationMode().ifPresent(mode -> graph.add(implNode, BaseSailSchema.DEFAULT_QUERY_EVALUATION_MODE, (Value)Values.literal((String)mode.getValue()), new Resource[0]));
        return implNode;
    }

    public void parse(Model graph, Resource implNode) throws SailConfigException {
        super.parse(graph, implNode);
        try {
            Configurations.getLiteralValue((Model)graph, (Resource)implNode, (IRI)CONFIG.Sail.defaultQueryEvaluationMode, (IRI)BaseSailSchema.DEFAULT_QUERY_EVALUATION_MODE).ifPresent(qem -> this.setDefaultQueryEvaluationMode(QueryEvaluationMode.valueOf((String)qem.stringValue())));
            Configurations.getLiteralValue((Model)graph, (Resource)implNode, (IRI)CONFIG.Sail.evaluationStrategyFactory, (IRI)BaseSailSchema.EVALUATION_STRATEGY_FACTORY).ifPresent(factoryClassName -> this.setEvaluationStrategyFactoryClassName(factoryClassName.stringValue()));
        }
        catch (IllegalArgumentException | ModelException e) {
            throw new SailConfigException(e.getMessage(), e);
        }
    }

    public Optional<QueryEvaluationMode> getDefaultQueryEvaluationMode() {
        return Optional.ofNullable(this.defaultQueryEvaluationMode);
    }

    public void setDefaultQueryEvaluationMode(QueryEvaluationMode defaultQueryEvaluationMode) {
        this.defaultQueryEvaluationMode = defaultQueryEvaluationMode;
    }
}

