/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.repository;

import java.util.Collection;
import java.util.Set;
import org.eclipse.rdf4j.federated.FedXConfig;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.impl.TreeModel;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.repository.config.AbstractRepositoryImplConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;

public class FedXRepositoryConfig
extends AbstractRepositoryImplConfig {
    private static final ValueFactory vf = SimpleValueFactory.getInstance();
    public static final String NAMESPACE = "http://rdf4j.org/config/federation#";
    public static final IRI DATA_CONFIG = vf.createIRI("http://rdf4j.org/config/federation#", "dataConfig");
    public static final IRI FEDX_CONFIG = vf.createIRI("http://rdf4j.org/config/federation#", "config");
    public static final IRI MEMBER = vf.createIRI("http://rdf4j.org/config/federation#", "member");
    public static final IRI CONFIG_JOIN_WORKER_THREADS = vf.createIRI("http://rdf4j.org/config/federation#", "joinWorkerThreads");
    public static final IRI CONFIG_UNION_WORKER_THREADS = vf.createIRI("http://rdf4j.org/config/federation#", "unionWorkerThreads");
    public static final IRI CONFIG_LEFT_JOIN_WORKER_THREADS = vf.createIRI("http://rdf4j.org/config/federation#", "leftJoinWorkerThreads");
    public static final IRI CONFIG_BOUND_JOIN_BLOCK_SIZE = vf.createIRI("http://rdf4j.org/config/federation#", "boundJoinBlockSize");
    public static final IRI CONFIG_ENFORCE_MAX_QUERY_TIME = vf.createIRI("http://rdf4j.org/config/federation#", "enforceMaxQueryTime");
    public static final IRI CONFIG_ENABLE_SERVICE_AS_BOUND_JOIN = vf.createIRI("http://rdf4j.org/config/federation#", "enableServiceAsBoundJoin");
    public static final IRI CONFIG_ENABLE_OPTIONAL_AS_BIND_JOIN = vf.createIRI("http://rdf4j.org/config/federation#", "enableOptionalAsBindJoin");
    public static final IRI CONFIG_ENABLE_MONITORING = vf.createIRI("http://rdf4j.org/config/federation#", "enableMonitoring");
    public static final IRI CONFIG_LOG_QUERY_PLAN = vf.createIRI("http://rdf4j.org/config/federation#", "logQueryPlan");
    public static final IRI CONFIG_LOG_QUERIES = vf.createIRI("http://rdf4j.org/config/federation#", "logQueries");
    public static final IRI CONFIG_DEBUG_QUERY_PLAN = vf.createIRI("http://rdf4j.org/config/federation#", "debugQueryPlan");
    public static final IRI CONFIG_INCLUDE_INFERRED_DEFAULT = vf.createIRI("http://rdf4j.org/config/federation#", "includeInferredDefault");
    public static final IRI CONFIG_SOURCE_SELECTION_CACHE_SPEC = vf.createIRI("http://rdf4j.org/config/federation#", "sourceSelectionCacheSpec");
    public static final IRI CONFIG_PREFIX_DECLARATIONS = vf.createIRI("http://rdf4j.org/config/federation#", "prefixDeclarations");
    public static final IRI CONFIG_CONSUMING_ITERATION_MAX = vf.createIRI("http://rdf4j.org/config/federation#", "consumingIterationMax");
    private String dataConfig;
    private Model members;
    private FedXConfig config;

    public FedXRepositoryConfig() {
        super("fedx:FedXRepository");
    }

    public String getDataConfig() {
        return this.dataConfig;
    }

    public void setDataConfig(String dataConfig) {
        this.dataConfig = dataConfig;
    }

    public Model getMembers() {
        return this.members;
    }

    public void setMembers(Model members) {
        this.members = members;
    }

    public FedXConfig getConfig() {
        return this.config;
    }

    public void setConfig(FedXConfig config) {
        this.config = config;
    }

    public Resource export(Model m) {
        Resource implNode = super.export(m);
        m.setNamespace("fedx", NAMESPACE);
        if (this.getDataConfig() != null) {
            m.add(implNode, DATA_CONFIG, (Value)vf.createLiteral(this.getDataConfig()), new Resource[0]);
        }
        this.exportFedXConfig(m, implNode);
        if (this.getMembers() != null) {
            Model members = this.getMembers();
            Set memberNodes = members.subjects();
            for (Resource memberNode : memberNodes) {
                m.add(implNode, MEMBER, (Value)memberNode, new Resource[0]);
                m.addAll((Collection)members.filter(memberNode, null, null, new Resource[0]));
            }
        }
        return implNode;
    }

    public void validate() throws RepositoryConfigException {
        super.validate();
        if (this.getMembers() == null && this.getDataConfig() == null) {
            throw new RepositoryConfigException("DataConfig needs to be provided to initialize the federation, if no explicit members are defined");
        }
    }

    public void parse(Model m, Resource implNode) throws RepositoryConfigException {
        super.parse(m, implNode);
        try {
            Models.objectLiteral((Iterable)m.getStatements(implNode, DATA_CONFIG, null, new Resource[0])).ifPresent(value -> this.setDataConfig(value.stringValue()));
            this.parseFedXConfig(m, implNode);
            Set memberNodes = m.filter(implNode, MEMBER, null, new Resource[0]).objects();
            if (!memberNodes.isEmpty()) {
                TreeModel members = new TreeModel();
                for (Value memberNode : memberNodes) {
                    if (!(memberNode instanceof Resource)) {
                        throw new RepositoryConfigException("Member nodes must be of type resource, was " + String.valueOf(memberNode));
                    }
                    members.addAll((Collection)m.filter((Resource)memberNode, null, null, new Resource[0]));
                }
                this.members = members;
            }
        }
        catch (ModelException e) {
            throw new RepositoryConfigException(e.getMessage(), (Throwable)e);
        }
    }

    protected void parseFedXConfig(Model m, Resource implNode) throws RepositoryConfigException {
        Models.objectResource((Iterable)m.getStatements(implNode, FEDX_CONFIG, null, new Resource[0])).ifPresent(res -> this.parseFedXConfigInternal(m, (Resource)res));
    }

    private void parseFedXConfigInternal(Model m, Resource confNode) throws RepositoryConfigException {
        if (this.getConfig() == null) {
            this.setConfig(new FedXConfig());
        }
        Models.objectLiteral((Iterable)m.getStatements(confNode, CONFIG_JOIN_WORKER_THREADS, null, new Resource[0])).ifPresent(value -> this.config.withJoinWorkerThreads(value.intValue()));
        Models.objectLiteral((Iterable)m.getStatements(confNode, CONFIG_UNION_WORKER_THREADS, null, new Resource[0])).ifPresent(value -> this.config.withUnionWorkerThreads(value.intValue()));
        Models.objectLiteral((Iterable)m.getStatements(confNode, CONFIG_LEFT_JOIN_WORKER_THREADS, null, new Resource[0])).ifPresent(value -> this.config.withLeftJoinWorkerThreads(value.intValue()));
        Models.objectLiteral((Iterable)m.getStatements(confNode, CONFIG_BOUND_JOIN_BLOCK_SIZE, null, new Resource[0])).ifPresent(value -> this.config.withBoundJoinBlockSize(value.intValue()));
        Models.objectLiteral((Iterable)m.getStatements(confNode, CONFIG_ENFORCE_MAX_QUERY_TIME, null, new Resource[0])).ifPresent(value -> this.config.withEnforceMaxQueryTime(value.intValue()));
        Models.objectLiteral((Iterable)m.getStatements(confNode, CONFIG_ENABLE_SERVICE_AS_BOUND_JOIN, null, new Resource[0])).ifPresent(value -> this.config.withEnableServiceAsBoundJoin(value.booleanValue()));
        Models.objectLiteral((Iterable)m.getStatements(confNode, CONFIG_ENABLE_OPTIONAL_AS_BIND_JOIN, null, new Resource[0])).ifPresent(value -> this.config.withEnableOptionalAsBindJoin(value.booleanValue()));
        Models.objectLiteral((Iterable)m.getStatements(confNode, CONFIG_ENABLE_MONITORING, null, new Resource[0])).ifPresent(value -> this.config.withEnableMonitoring(value.booleanValue()));
        Models.objectLiteral((Iterable)m.getStatements(confNode, CONFIG_LOG_QUERY_PLAN, null, new Resource[0])).ifPresent(value -> this.config.withLogQueryPlan(value.booleanValue()));
        Models.objectLiteral((Iterable)m.getStatements(confNode, CONFIG_LOG_QUERIES, null, new Resource[0])).ifPresent(value -> this.config.withLogQueries(value.booleanValue()));
        Models.objectLiteral((Iterable)m.getStatements(confNode, CONFIG_DEBUG_QUERY_PLAN, null, new Resource[0])).ifPresent(value -> this.config.withDebugQueryPlan(value.booleanValue()));
        Models.objectLiteral((Iterable)m.getStatements(confNode, CONFIG_INCLUDE_INFERRED_DEFAULT, null, new Resource[0])).ifPresent(value -> this.config.withIncludeInferredDefault(value.booleanValue()));
        Models.objectLiteral((Iterable)m.getStatements(confNode, CONFIG_SOURCE_SELECTION_CACHE_SPEC, null, new Resource[0])).ifPresent(value -> this.config.withSourceSelectionCacheSpec(value.stringValue()));
        Models.objectLiteral((Iterable)m.getStatements(confNode, CONFIG_PREFIX_DECLARATIONS, null, new Resource[0])).ifPresent(value -> this.config.withPrefixDeclarations(value.stringValue()));
        Models.objectLiteral((Iterable)m.getStatements(confNode, CONFIG_CONSUMING_ITERATION_MAX, null, new Resource[0])).ifPresent(value -> this.config.withConsumingIterationMax(value.intValue()));
    }

    protected void exportFedXConfig(Model model, Resource implNode) {
        if (this.getConfig() == null) {
            return;
        }
        BNode confNode = Values.bnode();
        model.add((Resource)confNode, CONFIG_JOIN_WORKER_THREADS, (Value)vf.createLiteral(this.config.getJoinWorkerThreads()), new Resource[0]);
        model.add((Resource)confNode, CONFIG_UNION_WORKER_THREADS, (Value)vf.createLiteral(this.config.getUnionWorkerThreads()), new Resource[0]);
        model.add((Resource)confNode, CONFIG_LEFT_JOIN_WORKER_THREADS, (Value)vf.createLiteral(this.config.getLeftJoinWorkerThreads()), new Resource[0]);
        model.add((Resource)confNode, CONFIG_BOUND_JOIN_BLOCK_SIZE, (Value)vf.createLiteral(this.config.getBoundJoinBlockSize()), new Resource[0]);
        model.add((Resource)confNode, CONFIG_ENFORCE_MAX_QUERY_TIME, (Value)vf.createLiteral(this.config.getEnforceMaxQueryTime()), new Resource[0]);
        model.add((Resource)confNode, CONFIG_ENABLE_SERVICE_AS_BOUND_JOIN, (Value)vf.createLiteral(this.config.getEnableServiceAsBoundJoin()), new Resource[0]);
        model.add((Resource)confNode, CONFIG_ENABLE_OPTIONAL_AS_BIND_JOIN, (Value)vf.createLiteral(this.config.isEnableOptionalAsBindJoin()), new Resource[0]);
        model.add((Resource)confNode, CONFIG_ENABLE_MONITORING, (Value)vf.createLiteral(this.config.isEnableMonitoring()), new Resource[0]);
        model.add((Resource)confNode, CONFIG_LOG_QUERY_PLAN, (Value)vf.createLiteral(this.config.isLogQueryPlan()), new Resource[0]);
        model.add((Resource)confNode, CONFIG_LOG_QUERIES, (Value)vf.createLiteral(this.config.isLogQueries()), new Resource[0]);
        model.add((Resource)confNode, CONFIG_DEBUG_QUERY_PLAN, (Value)vf.createLiteral(this.config.isDebugQueryPlan()), new Resource[0]);
        model.add((Resource)confNode, CONFIG_INCLUDE_INFERRED_DEFAULT, (Value)vf.createLiteral(this.config.getIncludeInferredDefault()), new Resource[0]);
        if (this.config.getSourceSelectionCacheSpec() != null) {
            model.add((Resource)confNode, CONFIG_SOURCE_SELECTION_CACHE_SPEC, (Value)vf.createLiteral(this.config.getSourceSelectionCacheSpec()), new Resource[0]);
        }
        if (this.config.getPrefixDeclarations() != null) {
            model.add((Resource)confNode, CONFIG_PREFIX_DECLARATIONS, (Value)vf.createLiteral(this.config.getPrefixDeclarations()), new Resource[0]);
        }
        model.add((Resource)confNode, CONFIG_CONSUMING_ITERATION_MAX, (Value)vf.createLiteral(this.config.getConsumingIterationMax()), new Resource[0]);
        model.add(implNode, FEDX_CONFIG, (Value)confNode, new Resource[0]);
    }
}

