/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.QueryParserUtil;
import org.eclipse.rdf4j.queryrender.VarNameNormalizer;
import org.eclipse.rdf4j.queryrender.sparql.PrefixIndex;
import org.eclipse.rdf4j.queryrender.sparql.TupleExprToIrConverter;
import org.eclipse.rdf4j.queryrender.sparql.ir.IRTextPrinter;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrGraph;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPathTriple;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrSelect;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrStatementPattern;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrSubSelect;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.IrDebug;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.IrTransforms;
import org.eclipse.rdf4j.queryrender.sparql.util.TermRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class TupleExprIRRenderer {
    private static final Logger log = LoggerFactory.getLogger(TupleExprIRRenderer.class);
    private final Config cfg;
    private final PrefixIndex prefixIndex;
    private final Map<String, String> userBnodeLabels = new LinkedHashMap<String, String>();
    private final Map<String, String> anonBnodeLabels = new LinkedHashMap<String, String>();
    private int bnodeCounter = 1;
    private static final String USER_BNODE_PREFIX = "_anon_user_bnode_";
    private static final String ANON_BNODE_PREFIX = "_anon_bnode_";

    public TupleExprIRRenderer() {
        this(new Config());
    }

    public TupleExprIRRenderer(Config cfg) {
        this.cfg = cfg == null ? new Config() : cfg;
        this.prefixIndex = new PrefixIndex(this.cfg.prefixes);
    }

    public void reset() {
        this.userBnodeLabels.clear();
        this.anonBnodeLabels.clear();
        this.bnodeCounter = 1;
    }

    Config getConfig() {
        return this.cfg;
    }

    public IrSelect toIRSelect(TupleExpr tupleExpr) {
        IrNode only;
        IrSelect transformed;
        IrSelect ir = new TupleExprToIrConverter(this).toIRSelect(tupleExpr);
        if (this.cfg.debugIR) {
            System.out.println("# IR (raw)\n" + IrDebug.dump(ir));
        }
        if ((transformed = this.transformIrRecursively(ir)) != null && transformed.getWhere() != null && transformed.getWhere().getLines() != null && transformed.getWhere().getLines().size() == 1 && TupleExprToIrConverter.hasExplicitRootScope(tupleExpr) && ((only = transformed.getWhere().getLines().get(0)) instanceof IrStatementPattern || only instanceof IrPathTriple || only instanceof IrGraph || only instanceof IrSubSelect)) {
            transformed.getWhere().setNewScope(true);
        }
        if (this.cfg.debugIR) {
            System.out.println("# IR (transformed)\n" + IrDebug.dump(transformed));
        }
        return transformed;
    }

    public IrSelect toIRSelectRaw(TupleExpr tupleExpr) {
        return TupleExprToIrConverter.toIRSelectRaw(tupleExpr, this, false);
    }

    public String dumpIRRaw(TupleExpr tupleExpr) {
        return IrDebug.dump(this.toIRSelectRaw(tupleExpr));
    }

    public String dumpIRTransformed(TupleExpr tupleExpr) {
        return IrDebug.dump(this.toIRSelect(tupleExpr));
    }

    public String render(IrSelect ir, DatasetView dataset, boolean subselect) {
        StringBuilder out = new StringBuilder(256);
        if (!subselect) {
            this.printPrologueAndDataset(out, dataset);
        }
        IRTextPrinter printer = new IRTextPrinter(out, this::convertVarToString, this.cfg);
        ir.print(printer);
        return out.toString().trim();
    }

    private IrSelect transformIrRecursively(IrSelect select) {
        if (select == null) {
            return null;
        }
        IrSelect top = IrTransforms.transformUsingChildren(select, this);
        IrNode mapped = top.transformChildren(child -> {
            if (child instanceof IrBGP) {
                IrBGP bgp = (IrBGP)child;
                IrBGP nb = new IrBGP(!bgp.getLines().isEmpty() && bgp.isNewScope());
                nb.setNewScope(bgp.isNewScope());
                for (IrNode ln : bgp.getLines()) {
                    if (ln instanceof IrSubSelect) {
                        IrSubSelect ss = (IrSubSelect)ln;
                        IrSelect subSel = ss.getSelect();
                        IrSelect subTx = this.transformIrRecursively(subSel);
                        nb.add(new IrSubSelect(subTx, ss.isNewScope()));
                        continue;
                    }
                    nb.add(ln);
                }
                return nb;
            }
            return child;
        });
        return (IrSelect)mapped;
    }

    public String render(TupleExpr tupleExpr) {
        return this.renderSelectInternal(tupleExpr, RenderMode.TOP_LEVEL_SELECT, null);
    }

    public String render(TupleExpr tupleExpr, DatasetView dataset) {
        return this.renderSelectInternal(tupleExpr, RenderMode.TOP_LEVEL_SELECT, dataset);
    }

    public String renderAsk(TupleExpr tupleExpr, DatasetView dataset) {
        this.reset();
        BNodeValidator.validate(tupleExpr, this.cfg);
        StringBuilder out = new StringBuilder(256);
        IrSelect ir = this.toIRSelect(tupleExpr);
        this.printPrologueAndDataset(out, dataset);
        out.append("ASK");
        Objects.requireNonNull(this.cfg);
        out.append("\nWHERE ");
        new IRTextPrinter(out, this::convertVarToString, this.cfg).printWhere(ir.getWhere());
        String rendered = out.toString().trim();
        this.verifyRoundTrip(tupleExpr, rendered);
        return rendered;
    }

    private String renderSelectInternal(TupleExpr tupleExpr, RenderMode mode, DatasetView dataset) {
        this.reset();
        BNodeValidator.validate(tupleExpr, this.cfg);
        IrSelect ir = this.toIRSelect(tupleExpr);
        boolean asSub = mode == RenderMode.SUBSELECT;
        String rendered = this.render(ir, dataset, asSub);
        return rendered;
    }

    private void verifyRoundTrip(TupleExpr original, String rendered) {
        if (!this.cfg.verifyRoundTrip || original == null || rendered == null || rendered.isEmpty()) {
            return;
        }
        try {
            ParsedQuery parsed = QueryParserUtil.parseQuery(QueryLanguage.SPARQL, rendered, null);
            String expected = VarNameNormalizer.normalizeVars(original.toString());
            String actual = VarNameNormalizer.normalizeVars(parsed.getTupleExpr().toString());
            if (!expected.equals(actual)) {
                String message = "Rendered SPARQL does not round-trip to the original TupleExpr.\n# Rendered query\n" + rendered + "\n# Original TupleExpr (normalized)\n" + expected + "\n# Round-tripped TupleExpr (normalized)\n" + actual + "\n# Diff (original -> round-tripped)\n" + this.diffText(expected, actual);
                throw new IllegalStateException(message);
            }
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Unexpected error while round-tripping TupleExpr. original={}, rendered={}", new Object[]{original, rendered, e});
            throw new IllegalStateException("Failed to verify rendered SPARQL against the original TupleExpr", e);
        }
    }

    private String diffText(String expected, String actual) {
        List<String> expLines = List.of(expected.split("\\R", -1));
        List<String> actLines = List.of(actual.split("\\R", -1));
        int max = Math.max(expLines.size(), actLines.size());
        StringBuilder sb = new StringBuilder(256);
        for (int i = 0; i < max; ++i) {
            String al;
            String el = i < expLines.size() ? expLines.get(i) : "<missing>";
            String string = al = i < actLines.size() ? actLines.get(i) : "<missing>";
            if (!el.trim().equals(al.trim())) {
                sb.append("line ").append(i + 1).append(":\n");
                sb.append("- ").append(el).append('\n');
                sb.append("+ ").append(al).append('\n');
                int common = this.commonPrefixLength(el, al);
                if (common < Math.min(el.length(), al.length())) {
                    sb.append("  ").append(" ".repeat(common)).append("^\n");
                }
            }
            if (sb.length() <= 1024) continue;
            sb.append("... diff truncated ...");
            break;
        }
        return sb.length() == 0 ? "<no visible diff>" : sb.toString();
    }

    private int commonPrefixLength(String a, String b) {
        int i;
        int limit = Math.min(a.length(), b.length());
        for (i = 0; i < limit && a.charAt(i) == b.charAt(i); ++i) {
        }
        return i;
    }

    private void printPrologueAndDataset(StringBuilder out, DatasetView dataset) {
        Objects.requireNonNull(this.cfg);
        if (!this.cfg.prefixes.isEmpty()) {
            this.cfg.prefixes.forEach((pfx, ns) -> out.append("PREFIX ").append((String)pfx).append(": <").append((String)ns).append(">\n"));
        }
        List<IRI> dgs = dataset != null ? dataset.defaultGraphs : this.cfg.defaultGraphs;
        List<IRI> ngs = dataset != null ? dataset.namedGraphs : this.cfg.namedGraphs;
        for (IRI iri : dgs) {
            out.append("FROM ").append(this.convertIRIToString(iri)).append("\n");
        }
        for (IRI iri : ngs) {
            out.append("FROM NAMED ").append(this.convertIRIToString(iri)).append("\n");
        }
    }

    String convertVarToString(Var v) {
        if (v == null) {
            return "?_";
        }
        if (v.hasValue()) {
            return this.convertValueToString(v.getValue());
        }
        if (v.isAnonymous() && v.getName() != null && v.getName().startsWith(ANON_BNODE_PREFIX)) {
            if (this.cfg.preserveAnonBNodeIdentity) {
                return "_:" + this.anonBnodeLabels.computeIfAbsent(v.getName(), TupleExprIRRenderer::deriveStableLabelFromName);
            }
            return "[]";
        }
        if (v.isAnonymous() && v.getName() != null && v.getName().startsWith(USER_BNODE_PREFIX)) {
            Object existing = this.userBnodeLabels.get(v.getName());
            if (existing == null) {
                existing = this.cfg.preserveUserBNodeLabels || this.cfg.deterministicBNodeLabels ? TupleExprIRRenderer.deriveStableLabelFromName(v.getName()) : "bnode" + this.bnodeCounter++;
                this.userBnodeLabels.put(v.getName(), (String)existing);
            }
            return "_:" + (String)existing;
        }
        if (v.isAnonymous() && v.getName() != null && v.getName().startsWith("_anon_path_")) {
            return "?" + v.getName();
        }
        if (v.isAnonymous() && !v.isConstant()) {
            return "_:" + v.getName();
        }
        return "?" + v.getName();
    }

    public String convertValueToString(Value val) {
        Objects.requireNonNull(this.cfg);
        return TermRenderer.convertValueToString(val, this.prefixIndex, true);
    }

    private static String deriveStableLabelFromName(String name) {
        if (name == null) {
            return "bnode";
        }
        String trimmed = name;
        assert (!trimmed.startsWith("anon_"));
        if (trimmed.startsWith(USER_BNODE_PREFIX)) {
            trimmed = trimmed.substring(USER_BNODE_PREFIX.length());
        } else if (trimmed.startsWith(ANON_BNODE_PREFIX)) {
            trimmed = trimmed.substring(ANON_BNODE_PREFIX.length());
        }
        if (trimmed.isEmpty()) {
            return "bnode";
        }
        if (trimmed.matches("[A-Za-z0-9_-]+")) {
            return trimmed.startsWith("bnode") ? trimmed : "bnode" + trimmed;
        }
        return "bnode" + Integer.toHexString(trimmed.hashCode());
    }

    public String convertIRIToString(IRI iri) {
        Objects.requireNonNull(this.cfg);
        return TermRenderer.convertIRIToString(iri, this.prefixIndex, true);
    }

    public String convertVarIriToString(Var v) {
        if (v != null && v.hasValue() && v.getValue() instanceof IRI) {
            return this.convertIRIToString((IRI)v.getValue());
        }
        return null;
    }

    public static final class Config {
        public final String indent = "  ";
        public final boolean printPrefixes = true;
        public final boolean usePrefixCompaction = true;
        public final boolean canonicalWhitespace = true;
        public boolean verifyRoundTrip = true;
        public final LinkedHashMap<String, String> prefixes = new LinkedHashMap();
        public final List<IRI> defaultGraphs = new ArrayList<IRI>();
        public final List<IRI> namedGraphs = new ArrayList<IRI>();
        public boolean debugIR = false;
        public boolean valuesPreserveOrder = false;
        public boolean preserveUserBNodeLabels = false;
        public boolean deterministicBNodeLabels = false;
        public boolean preserveAnonBNodeIdentity = false;
        public boolean failOnIllegalBNodes = true;
        public boolean allowBNodesInValues = false;
    }

    public static final class DatasetView {
        public final List<IRI> defaultGraphs = new ArrayList<IRI>();
        public final List<IRI> namedGraphs = new ArrayList<IRI>();

        public DatasetView addDefault(IRI iri) {
            if (iri != null) {
                this.defaultGraphs.add(iri);
            }
            return this;
        }

        public DatasetView addNamed(IRI iri) {
            if (iri != null) {
                this.namedGraphs.add(iri);
            }
            return this;
        }
    }

    private static enum RenderMode {
        TOP_LEVEL_SELECT,
        SUBSELECT;

    }

    private static final class BNodeValidator
    extends AbstractQueryModelVisitor<RuntimeException> {
        private final Config cfg;

        private BNodeValidator(Config cfg) {
            this.cfg = cfg == null ? new Config() : cfg;
        }

        static void validate(TupleExpr expr, Config cfg) {
            if (expr == null || cfg == null || !cfg.failOnIllegalBNodes) {
                return;
            }
            expr.visit(new BNodeValidator(cfg));
        }

        @Override
        public void meet(BindingSetAssignment node) {
            if (this.cfg.allowBNodesInValues) {
                return;
            }
            for (BindingSet bs : node.getBindingSets()) {
                for (String name : bs.getBindingNames()) {
                    Value v = bs.getValue(name);
                    if (!(v instanceof BNode)) continue;
                    throw new IllegalArgumentException("Blank nodes in VALUES are not supported: binding '" + name + "' -> " + String.valueOf(v));
                }
            }
        }

        @Override
        public void meet(StatementPattern sp) {
        }

        @Override
        public void meet(Var var) {
            if (!var.isAnonymous()) {
                return;
            }
            String name = var.getName();
            if (name == null) {
                return;
            }
            assert (!name.startsWith("anon_"));
            if (name.startsWith(TupleExprIRRenderer.ANON_BNODE_PREFIX) || name.startsWith(TupleExprIRRenderer.USER_BNODE_PREFIX)) {
                throw new IllegalArgumentException("Anonymous blank node used in expression context: " + name);
            }
        }

        @Override
        public void meet(ValueConstant node) {
            if (node.getValue() instanceof BNode) {
                throw new IllegalArgumentException("Blank node literal in expression context is not supported: " + String.valueOf(node.getValue()));
            }
        }
    }
}

