/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;

@Deprecated(since="3.0")
@InternalUseOnly
public class LuceneSailBuffer {
    private final ArrayList<Operation> operations = new ArrayList();
    private final boolean useType;

    public LuceneSailBuffer() {
        this(false);
    }

    public LuceneSailBuffer(boolean useType) {
        this.useType = useType;
    }

    public synchronized void add(Statement s) {
        Operation o;
        Operation operation = o = this.operations.isEmpty() ? null : this.operations.get(this.operations.size() - 1);
        if (o == null || !(o instanceof AddRemoveOperation)) {
            o = new AddRemoveOperation(this.useType);
            this.operations.add(o);
        }
        AddRemoveOperation aro = (AddRemoveOperation)o;
        aro.add(new ContextAwareStatementImpl(s));
    }

    public synchronized void addTypeStatement(Statement s, boolean rightType) {
        Operation o;
        Operation operation = o = this.operations.isEmpty() ? null : this.operations.get(this.operations.size() - 1);
        if (!(o instanceof AddRemoveOperation)) {
            o = new AddRemoveOperation(this.useType);
            this.operations.add(o);
        }
        AddRemoveOperation aro = (AddRemoveOperation)o;
        aro.addType(new ContextAwareStatementImpl(s), rightType);
    }

    public synchronized void remove(Statement s) {
        Operation o;
        Operation operation = o = this.operations.isEmpty() ? null : this.operations.get(this.operations.size() - 1);
        if (o == null || !(o instanceof AddRemoveOperation)) {
            o = new AddRemoveOperation(this.useType);
            this.operations.add(o);
        }
        AddRemoveOperation aro = (AddRemoveOperation)o;
        aro.remove(new ContextAwareStatementImpl(s));
    }

    public synchronized void removeTypeStatement(Statement s) {
        Operation o;
        Operation operation = o = this.operations.isEmpty() ? null : this.operations.get(this.operations.size() - 1);
        if (!(o instanceof AddRemoveOperation)) {
            o = new AddRemoveOperation(this.useType);
            this.operations.add(o);
        }
        AddRemoveOperation aro = (AddRemoveOperation)o;
        aro.removeType(new ContextAwareStatementImpl(s));
    }

    public synchronized void clear(Resource[] contexts) {
        if (contexts == null || contexts.length == 0) {
            this.operations.add(new ClearOperation());
        } else {
            this.operations.add(new ClearContextOperation(contexts));
        }
    }

    public synchronized Iterator<Operation> operationsIterator() {
        return this.operations.iterator();
    }

    public synchronized List<Operation> operations() {
        return this.operations;
    }

    public void optimize() {
        for (int i = this.operations.size() - 1; i >= 0; --i) {
            Operation o = this.operations.get(i);
            if (!(o instanceof ClearOperation)) continue;
            while (i > 0) {
                this.operations.remove(i);
                --i;
            }
            return;
        }
    }

    public void reset() {
        this.operations.clear();
    }

    public static class Operation {
    }

    public static class AddRemoveOperation
    extends Operation {
        HashSet<Statement> added = new HashSet();
        HashSet<Statement> removed = new HashSet();
        Map<Resource, Boolean> typeAdded;
        Set<Resource> typeRemoved;

        public AddRemoveOperation() {
            this(false);
        }

        public AddRemoveOperation(boolean useType) {
            if (useType) {
                this.typeAdded = new HashMap<Resource, Boolean>();
                this.typeRemoved = new HashSet<Resource>();
            }
        }

        public void add(Statement s) {
            if (!this.removed.remove(s)) {
                this.added.add(s);
            }
        }

        public void addType(Statement s, boolean rightType) {
            if (!this.typeRemoved.remove(s.getSubject())) {
                this.typeAdded.put(s.getSubject(), rightType);
            }
        }

        public void remove(Statement s) {
            if (!this.added.remove(s)) {
                this.removed.add(s);
            }
        }

        public void removeType(Statement s) {
            if (this.typeAdded.remove(s.getSubject()) == null) {
                this.typeRemoved.add(s.getSubject());
            }
        }

        public HashSet<Statement> getAdded() {
            return this.added;
        }

        public HashSet<Statement> getRemoved() {
            return this.removed;
        }

        public Map<Resource, Boolean> getTypeAdded() {
            return this.typeAdded;
        }

        public Set<Resource> getTypeRemoved() {
            return this.typeRemoved;
        }
    }

    private static class ContextAwareStatementImpl
    implements Statement {
        private static final long serialVersionUID = -2976244503679342649L;
        private final Statement delegate;

        public ContextAwareStatementImpl(Statement delegate) {
            if (delegate == null) {
                throw new RuntimeException("Trying to add/remove a null statement");
            }
            this.delegate = delegate;
        }

        @Override
        public Resource getSubject() {
            return this.delegate.getSubject();
        }

        @Override
        public IRI getPredicate() {
            return this.delegate.getPredicate();
        }

        @Override
        public Value getObject() {
            return this.delegate.getObject();
        }

        @Override
        public Resource getContext() {
            return this.delegate.getContext();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Statement) {
                Statement other = (Statement)obj;
                return this.delegate.equals(other) && (this.getContext() == null && other.getContext() == null || this.getContext() != null && other.getContext() != null && this.getContext().equals(other.getContext()));
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode() + (this.getContext() == null ? 0 : 29791 * this.getContext().hashCode());
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    public static class ClearOperation
    extends Operation {
    }

    public static class ClearContextOperation
    extends Operation {
        Resource[] contexts;

        public ClearContextOperation(Resource[] contexts) {
            this.contexts = contexts;
        }

        public Resource[] getContexts() {
            return this.contexts;
        }
    }
}

