/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.hash;

import java.security.NoSuchAlgorithmException;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.hash.HashFunction;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtility;

public class SHA256
extends HashFunction {
    @Override
    public String getURI() {
        return "SHA256";
    }

    @Override
    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException("SHA256 requires exactly 1 argument, got " + args.length);
        }
        if (args[0] instanceof Literal) {
            Literal literal = (Literal)args[0];
            if (QueryEvaluationUtility.isSimpleLiteral(literal)) {
                String lexValue = literal.getLabel();
                try {
                    return valueFactory.createLiteral(this.hash(lexValue, "SHA-256"));
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
            }
            throw new ValueExprEvaluationException("Invalid argument for SHA256: " + String.valueOf(literal));
        }
        throw new ValueExprEvaluationException("Invalid argument for SHA256: " + String.valueOf(args[0]));
    }
}

