/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.mutable;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MultiReaderBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.factory.Bags;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.multimap.bag.MutableBagMultimap;
import org.eclipse.collections.api.partition.bag.PartitionMutableBag;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.api.tuple.primitive.ObjectIntPair;
import org.eclipse.collections.impl.bag.mutable.HashBag;
import org.eclipse.collections.impl.bag.mutable.SynchronizedBag;
import org.eclipse.collections.impl.bag.mutable.UnmodifiableBag;
import org.eclipse.collections.impl.collection.mutable.AbstractMultiReaderMutableCollection;
import org.eclipse.collections.impl.factory.Iterables;
import org.eclipse.collections.impl.utility.LazyIterate;

public final class MultiReaderHashBag<T>
extends AbstractMultiReaderMutableCollection<T>
implements Externalizable,
MultiReaderBag<T> {
    private static final long serialVersionUID = 1L;
    private MutableBag<T> delegate;

    @Deprecated
    public MultiReaderHashBag() {
    }

    private MultiReaderHashBag(MutableBag<T> newDelegate) {
        this(newDelegate, new ReentrantReadWriteLock());
    }

    private MultiReaderHashBag(MutableBag<T> newDelegate, ReadWriteLock newLock) {
        this.lock = newLock;
        this.lockWrapper = new AbstractMultiReaderMutableCollection.ReadWriteLockWrapper(newLock);
        this.delegate = newDelegate;
    }

    public static <T> MultiReaderHashBag<T> newBag() {
        return new MultiReaderHashBag(HashBag.newBag());
    }

    public static <T> MultiReaderHashBag<T> newBag(int capacity) {
        return new MultiReaderHashBag(HashBag.newBag(capacity));
    }

    public static <T> MultiReaderHashBag<T> newBag(Iterable<T> iterable) {
        return new MultiReaderHashBag<T>(HashBag.newBag(iterable));
    }

    public static <T> MultiReaderHashBag<T> newBagWith(T ... elements) {
        return new MultiReaderHashBag<T>(HashBag.newBagWith(elements));
    }

    @Override
    protected MutableBag<T> getDelegate() {
        return this.delegate;
    }

    UntouchableMutableBag<T> asReadUntouchable() {
        return new UntouchableMutableBag(this.delegate.asUnmodifiable());
    }

    UntouchableMutableBag<T> asWriteUntouchable() {
        return new UntouchableMutableBag(this.delegate);
    }

    public void withReadLockAndDelegate(Procedure<? super MutableBag<T>> procedure) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UntouchableMutableBag<T> bag = this.asReadUntouchable();
            procedure.value(bag);
            bag.becomeUseless();
        }
    }

    public void withWriteLockAndDelegate(Procedure<? super MutableBag<T>> procedure) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            UntouchableMutableBag<T> bag = this.asWriteUntouchable();
            procedure.value(bag);
            bag.becomeUseless();
        }
    }

    public MutableBag<T> asSynchronized() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            SynchronizedBag synchronizedBag = SynchronizedBag.of(this);
            return synchronizedBag;
        }
    }

    public MutableBag<T> asUnmodifiable() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnmodifiableBag unmodifiableBag = UnmodifiableBag.of(this);
            return unmodifiableBag;
        }
    }

    public ImmutableBag<T> toImmutable() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            ImmutableBag immutableBag = Bags.immutable.withAll(this.delegate);
            return immutableBag;
        }
    }

    public int addOccurrences(T item, int occurrences) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            int n = this.delegate.addOccurrences(item, occurrences);
            return n;
        }
    }

    public boolean removeOccurrences(Object item, int occurrences) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            boolean bl = this.delegate.removeOccurrences(item, occurrences);
            return bl;
        }
    }

    public boolean setOccurrences(T item, int occurrences) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            boolean bl = this.delegate.setOccurrences(item, occurrences);
            return bl;
        }
    }

    public int occurrencesOf(Object item) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            int n = this.delegate.occurrencesOf(item);
            return n;
        }
    }

    public int sizeDistinct() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            int n = this.delegate.sizeDistinct();
            return n;
        }
    }

    public <V> MutableBag<V> collect(Function<? super T, ? extends V> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableBag mutableBag = this.delegate.collect(function);
            return mutableBag;
        }
    }

    public MutableBooleanBag collectBoolean(BooleanFunction<? super T> booleanFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableBooleanBag mutableBooleanBag = this.delegate.collectBoolean(booleanFunction);
            return mutableBooleanBag;
        }
    }

    public MutableByteBag collectByte(ByteFunction<? super T> byteFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableByteBag mutableByteBag = this.delegate.collectByte(byteFunction);
            return mutableByteBag;
        }
    }

    public MutableCharBag collectChar(CharFunction<? super T> charFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableCharBag mutableCharBag = this.delegate.collectChar(charFunction);
            return mutableCharBag;
        }
    }

    public MutableDoubleBag collectDouble(DoubleFunction<? super T> doubleFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableDoubleBag mutableDoubleBag = this.delegate.collectDouble(doubleFunction);
            return mutableDoubleBag;
        }
    }

    public MutableFloatBag collectFloat(FloatFunction<? super T> floatFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableFloatBag mutableFloatBag = this.delegate.collectFloat(floatFunction);
            return mutableFloatBag;
        }
    }

    public MutableIntBag collectInt(IntFunction<? super T> intFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableIntBag mutableIntBag = this.delegate.collectInt(intFunction);
            return mutableIntBag;
        }
    }

    public MutableLongBag collectLong(LongFunction<? super T> longFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableLongBag mutableLongBag = this.delegate.collectLong(longFunction);
            return mutableLongBag;
        }
    }

    public MutableShortBag collectShort(ShortFunction<? super T> shortFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableShortBag mutableShortBag = this.delegate.collectShort(shortFunction);
            return mutableShortBag;
        }
    }

    public <V> MutableBag<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableBag mutableBag = this.delegate.flatCollect(function);
            return mutableBag;
        }
    }

    public MutableList<ObjectIntPair<T>> topOccurrences(int count) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableList mutableList = this.delegate.topOccurrences(count);
            return mutableList;
        }
    }

    public MutableList<ObjectIntPair<T>> bottomOccurrences(int count) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableList mutableList = this.delegate.bottomOccurrences(count);
            return mutableList;
        }
    }

    public <V> MutableBag<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableBag mutableBag = this.delegate.collectIf(predicate, function);
            return mutableBag;
        }
    }

    public <V> MutableBag<V> collectWithOccurrences(ObjectIntToObjectFunction<? super T, ? extends V> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableBag mutableBag = this.collectWithOccurrences(function, Bags.mutable.empty());
            return mutableBag;
        }
    }

    public <V, R extends Collection<V>> R collectWithOccurrences(ObjectIntToObjectFunction<? super T, ? extends V> function, R target) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            this.forEachWithOccurrences((ObjectIntProcedure & Serializable)(each, occurrences) -> target.add(function.valueOf(each, occurrences)));
            Collection r = target;
            return r;
        }
    }

    public <P, V> MutableBag<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableBag mutableBag = this.delegate.collectWith(function, parameter);
            return mutableBag;
        }
    }

    public MutableBag<T> newEmpty() {
        return MultiReaderHashBag.newBag();
    }

    public MutableBag<T> reject(Predicate<? super T> predicate) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableBag mutableBag = this.delegate.reject(predicate);
            return mutableBag;
        }
    }

    public <P> MutableBag<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableBag mutableBag = this.delegate.rejectWith(predicate, parameter);
            return mutableBag;
        }
    }

    public MutableBag<T> tap(Procedure<? super T> procedure) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            this.forEach(procedure);
            MultiReaderHashBag multiReaderHashBag = this;
            return multiReaderHashBag;
        }
    }

    public MutableBag<T> select(Predicate<? super T> predicate) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableBag mutableBag = this.delegate.select(predicate);
            return mutableBag;
        }
    }

    public <P> MutableBag<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableBag mutableBag = this.delegate.selectWith(predicate, parameter);
            return mutableBag;
        }
    }

    public MutableBag<T> selectByOccurrences(IntPredicate predicate) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableBag mutableBag = this.delegate.selectByOccurrences(predicate);
            return mutableBag;
        }
    }

    public <S> MutableBag<S> selectInstancesOf(Class<S> clazz) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableBag mutableBag = this.delegate.selectInstancesOf(clazz);
            return mutableBag;
        }
    }

    public PartitionMutableBag<T> partition(Predicate<? super T> predicate) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            PartitionMutableBag partitionMutableBag = this.delegate.partition(predicate);
            return partitionMutableBag;
        }
    }

    public <P> PartitionMutableBag<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            PartitionMutableBag partitionMutableBag = this.delegate.partitionWith(predicate, parameter);
            return partitionMutableBag;
        }
    }

    public MutableMap<T, Integer> toMapOfItemToCount() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableMap mutableMap = this.delegate.toMapOfItemToCount();
            return mutableMap;
        }
    }

    public String toStringOfItemToCount() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            String string = this.delegate.toStringOfItemToCount();
            return string;
        }
    }

    public <V> MutableBagMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableBagMultimap mutableBagMultimap = this.delegate.groupBy(function);
            return mutableBagMultimap;
        }
    }

    public <V> MutableBagMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableBagMultimap mutableBagMultimap = this.delegate.groupByEach(function);
            return mutableBagMultimap;
        }
    }

    public <V> MutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableMap mutableMap = this.delegate.groupByUniqueKey(function);
            return mutableMap;
        }
    }

    @Deprecated
    public <S> MutableBag<Pair<T, S>> zip(Iterable<S> that) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableBag mutableBag = this.delegate.zip(that);
            return mutableBag;
        }
    }

    @Deprecated
    public MutableSet<Pair<T, Integer>> zipWithIndex() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableSet mutableSet = this.delegate.zipWithIndex();
            return mutableSet;
        }
    }

    public RichIterable<RichIterable<T>> chunk(int size) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            RichIterable richIterable = this.delegate.chunk(size);
            return richIterable;
        }
    }

    public void forEachWithOccurrences(ObjectIntProcedure<? super T> procedure) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            this.delegate.forEachWithOccurrences(procedure);
        }
    }

    public boolean equals(Object o) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            boolean bl = this.delegate.equals(o);
            return bl;
        }
    }

    public int hashCode() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            int n = this.delegate.hashCode();
            return n;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.delegate);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.delegate = (MutableBag)in.readObject();
        this.lock = new ReentrantReadWriteLock();
        this.lockWrapper = new AbstractMultiReaderMutableCollection.ReadWriteLockWrapper(this.lock);
    }

    public MutableSet<T> selectUnique() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableSet mutableSet = this.getDelegate().selectUnique();
            return mutableSet;
        }
    }

    private static final class UntouchableIterator<T>
    implements Iterator<T> {
        private Iterator<T> delegate;

        private UntouchableIterator(Iterator<T> newDelegate) {
            this.delegate = newDelegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public T next() {
            return this.delegate.next();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        public void becomeUseless() {
            this.delegate = null;
        }
    }

    static final class UntouchableMutableBag<T>
    extends AbstractMultiReaderMutableCollection.UntouchableMutableCollection<T>
    implements MutableBag<T> {
        private final MutableList<UntouchableIterator<T>> requestedIterators = Iterables.mList();

        private UntouchableMutableBag(MutableBag<T> newDelegate) {
            this.delegate = newDelegate;
        }

        public void becomeUseless() {
            this.delegate = null;
            this.requestedIterators.each(UntouchableIterator::becomeUseless);
        }

        public MutableBag<T> with(T element) {
            this.add(element);
            return this;
        }

        public MutableBag<T> without(T element) {
            this.remove(element);
            return this;
        }

        public MutableBag<T> withAll(Iterable<? extends T> elements) {
            this.addAllIterable(elements);
            return this;
        }

        public MutableBag<T> withoutAll(Iterable<? extends T> elements) {
            this.removeAllIterable(elements);
            return this;
        }

        public MutableBag<T> asSynchronized() {
            throw new UnsupportedOperationException("cannot wrap an UntouchableMutableBag");
        }

        public MutableBag<T> asUnmodifiable() {
            throw new UnsupportedOperationException("cannot wrap an UntouchableMutableBag");
        }

        public ImmutableBag<T> toImmutable() {
            return Bags.immutable.withAll(this.getDelegate());
        }

        public LazyIterable<T> asLazy() {
            return LazyIterate.adapt(this);
        }

        public Iterator<T> iterator() {
            UntouchableIterator iterator = new UntouchableIterator(this.delegate.iterator());
            this.requestedIterators.add(iterator);
            return iterator;
        }

        public int addOccurrences(T item, int occurrences) {
            return this.getDelegate().addOccurrences(item, occurrences);
        }

        public boolean removeOccurrences(Object item, int occurrences) {
            return this.getDelegate().removeOccurrences(item, occurrences);
        }

        public boolean setOccurrences(T item, int occurrences) {
            return this.getDelegate().setOccurrences(item, occurrences);
        }

        public int occurrencesOf(Object item) {
            return this.getDelegate().occurrencesOf(item);
        }

        public int sizeDistinct() {
            return this.getDelegate().sizeDistinct();
        }

        public <V> MutableBag<V> collect(Function<? super T, ? extends V> function) {
            return this.getDelegate().collect(function);
        }

        public MutableBooleanBag collectBoolean(BooleanFunction<? super T> booleanFunction) {
            return this.getDelegate().collectBoolean(booleanFunction);
        }

        public <R extends MutableBooleanCollection> R collectBoolean(BooleanFunction<? super T> booleanFunction, R target) {
            return (R)this.getDelegate().collectBoolean(booleanFunction, target);
        }

        public <R extends MutableBooleanCollection> R flatCollectBoolean(Function<? super T, ? extends BooleanIterable> function, R target) {
            return (R)this.getDelegate().flatCollectBoolean(function, target);
        }

        public MutableByteBag collectByte(ByteFunction<? super T> byteFunction) {
            return this.getDelegate().collectByte(byteFunction);
        }

        public <R extends MutableByteCollection> R collectByte(ByteFunction<? super T> byteFunction, R target) {
            return (R)this.getDelegate().collectByte(byteFunction, target);
        }

        public <R extends MutableByteCollection> R flatCollectByte(Function<? super T, ? extends ByteIterable> function, R target) {
            return (R)this.getDelegate().flatCollectByte(function, target);
        }

        public MutableCharBag collectChar(CharFunction<? super T> charFunction) {
            return this.getDelegate().collectChar(charFunction);
        }

        public <R extends MutableCharCollection> R collectChar(CharFunction<? super T> charFunction, R target) {
            return (R)this.getDelegate().collectChar(charFunction, target);
        }

        public <R extends MutableCharCollection> R flatCollectChar(Function<? super T, ? extends CharIterable> function, R target) {
            return (R)this.getDelegate().flatCollectChar(function, target);
        }

        public MutableDoubleBag collectDouble(DoubleFunction<? super T> doubleFunction) {
            return this.getDelegate().collectDouble(doubleFunction);
        }

        public <R extends MutableDoubleCollection> R collectDouble(DoubleFunction<? super T> doubleFunction, R target) {
            return (R)this.getDelegate().collectDouble(doubleFunction, target);
        }

        public <R extends MutableDoubleCollection> R flatCollectDouble(Function<? super T, ? extends DoubleIterable> function, R target) {
            return (R)this.getDelegate().flatCollectDouble(function, target);
        }

        public MutableFloatBag collectFloat(FloatFunction<? super T> floatFunction) {
            return this.getDelegate().collectFloat(floatFunction);
        }

        public <R extends MutableFloatCollection> R collectFloat(FloatFunction<? super T> floatFunction, R target) {
            return (R)this.getDelegate().collectFloat(floatFunction, target);
        }

        public <R extends MutableFloatCollection> R flatCollectFloat(Function<? super T, ? extends FloatIterable> function, R target) {
            return (R)this.getDelegate().flatCollectFloat(function, target);
        }

        public MutableIntBag collectInt(IntFunction<? super T> intFunction) {
            return this.getDelegate().collectInt(intFunction);
        }

        public <R extends MutableIntCollection> R collectInt(IntFunction<? super T> intFunction, R target) {
            return (R)this.getDelegate().collectInt(intFunction, target);
        }

        public <R extends MutableIntCollection> R flatCollectInt(Function<? super T, ? extends IntIterable> function, R target) {
            return (R)this.getDelegate().flatCollectInt(function, target);
        }

        public MutableLongBag collectLong(LongFunction<? super T> longFunction) {
            return this.getDelegate().collectLong(longFunction);
        }

        public <R extends MutableLongCollection> R collectLong(LongFunction<? super T> longFunction, R target) {
            return (R)this.getDelegate().collectLong(longFunction, target);
        }

        public <R extends MutableLongCollection> R flatCollectLong(Function<? super T, ? extends LongIterable> function, R target) {
            return (R)this.getDelegate().flatCollectLong(function, target);
        }

        public MutableShortBag collectShort(ShortFunction<? super T> shortFunction) {
            return this.getDelegate().collectShort(shortFunction);
        }

        public <R extends MutableShortCollection> R collectShort(ShortFunction<? super T> shortFunction, R target) {
            return (R)this.getDelegate().collectShort(shortFunction, target);
        }

        public <R extends MutableShortCollection> R flatCollectShort(Function<? super T, ? extends ShortIterable> function, R target) {
            return (R)this.getDelegate().flatCollectShort(function, target);
        }

        public <V> MutableBag<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
            return this.getDelegate().flatCollect(function);
        }

        public MutableList<ObjectIntPair<T>> topOccurrences(int count) {
            return this.getDelegate().topOccurrences(count);
        }

        public MutableList<ObjectIntPair<T>> bottomOccurrences(int count) {
            return this.getDelegate().bottomOccurrences(count);
        }

        public <V> MutableBag<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
            return this.getDelegate().collectIf(predicate, function);
        }

        public <V> MutableBag<V> collectWithOccurrences(ObjectIntToObjectFunction<? super T, ? extends V> function) {
            return this.getDelegate().collectWithOccurrences(function);
        }

        public <V, R extends Collection<V>> R collectWithOccurrences(ObjectIntToObjectFunction<? super T, ? extends V> function, R target) {
            return (R)this.getDelegate().collectWithOccurrences(function, target);
        }

        public <P, V> MutableBag<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
            return this.getDelegate().collectWith(function, parameter);
        }

        public <V> MutableBagMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
            return this.getDelegate().groupBy(function);
        }

        public <V> MutableBagMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
            return this.getDelegate().groupByEach(function);
        }

        public <V> MutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
            return this.getDelegate().groupByUniqueKey(function);
        }

        public MutableBag<T> newEmpty() {
            return this.getDelegate().newEmpty();
        }

        public MutableBag<T> reject(Predicate<? super T> predicate) {
            return this.getDelegate().reject(predicate);
        }

        public <P> MutableBag<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.getDelegate().rejectWith(predicate, parameter);
        }

        public MutableBag<T> tap(Procedure<? super T> procedure) {
            this.forEach(procedure);
            return this;
        }

        public MutableBag<T> select(Predicate<? super T> predicate) {
            return this.getDelegate().select(predicate);
        }

        public <P> MutableBag<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.getDelegate().selectWith(predicate, parameter);
        }

        public MutableBag<T> selectByOccurrences(IntPredicate predicate) {
            return this.getDelegate().selectByOccurrences(predicate);
        }

        public <S> MutableBag<S> selectInstancesOf(Class<S> clazz) {
            return this.getDelegate().selectInstancesOf(clazz);
        }

        public void forEachWithOccurrences(ObjectIntProcedure<? super T> procedure) {
            this.getDelegate().forEachWithOccurrences(procedure);
        }

        public PartitionMutableBag<T> partition(Predicate<? super T> predicate) {
            return this.getDelegate().partition(predicate);
        }

        public <P> PartitionMutableBag<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.getDelegate().partitionWith(predicate, parameter);
        }

        @Deprecated
        public <S> MutableBag<Pair<T, S>> zip(Iterable<S> that) {
            return this.getDelegate().zip(that);
        }

        @Deprecated
        public MutableSet<Pair<T, Integer>> zipWithIndex() {
            return this.getDelegate().zipWithIndex();
        }

        public MutableMap<T, Integer> toMapOfItemToCount() {
            return this.getDelegate().toMapOfItemToCount();
        }

        public String toStringOfItemToCount() {
            return this.getDelegate().toStringOfItemToCount();
        }

        private MutableBag<T> getDelegate() {
            return (MutableBag)this.delegate;
        }

        public MutableSet<T> selectUnique() {
            return this.getDelegate().selectUnique();
        }
    }
}

