/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.jsonld;

import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import no.hasmac.jsonld.JsonLd;
import no.hasmac.jsonld.JsonLdError;
import no.hasmac.jsonld.JsonLdOptions;
import no.hasmac.jsonld.api.ToRdfApi;
import no.hasmac.jsonld.document.Document;
import no.hasmac.jsonld.document.JsonDocument;
import no.hasmac.jsonld.loader.DocumentLoader;
import no.hasmac.rdf.RdfConsumer;
import no.hasmac.rdf.RdfValueFactory;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFParser;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.jsonld.CachingDocumentLoader;
import org.eclipse.rdf4j.rio.jsonld.JSONLDSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONLDParser
extends AbstractRDFParser {
    private static final Logger logger = LoggerFactory.getLogger(JSONLDParser.class);

    public JSONLDParser() {
    }

    public JSONLDParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.JSONLD;
    }

    public Collection<RioSetting<?>> getSupportedSettings() {
        Collection result = super.getSupportedSettings();
        result.add(JSONLDSettings.EXPAND_CONTEXT);
        result.add(JSONLDSettings.EXCEPTION_ON_WARNING);
        result.add(JSONLDSettings.SECURE_MODE);
        result.add(JSONLDSettings.WHITELIST);
        result.add(JSONLDSettings.DOCUMENT_LOADER);
        result.add(JSONLDSettings.DOCUMENT_LOADER_CACHE);
        result.add(org.eclipse.rdf4j.rio.helpers.JSONLDSettings.SECURE_MODE);
        result.add(org.eclipse.rdf4j.rio.helpers.JSONLDSettings.WHITELIST);
        result.add(org.eclipse.rdf4j.rio.helpers.JSONLDSettings.DOCUMENT_LOADER_CACHE);
        return result;
    }

    public void parse(InputStream in, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        this.parse(in, null, baseURI);
    }

    public void parse(Reader reader, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        this.parse(null, reader, baseURI);
    }

    private void parse(InputStream in, Reader reader, String baseURI) throws RDFParseException, RDFHandlerException, IOException {
        this.clear();
        if (this.rdfHandler != null) {
            this.rdfHandler.startRDF();
        }
        try {
            RDFHandler rdfHandler;
            Document document = this.getDocument(in, reader);
            if (((Boolean)this.getParserConfig().get((RioSetting)BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES)).booleanValue()) {
                logger.warn("JSON-LD parser does not support the {} setting", (Object)BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES);
            }
            boolean secureMode = (Boolean)this.getParserConfig().get((RioSetting)JSONLDSettings.SECURE_MODE);
            Set whitelist = (Set)this.getParserConfig().get(JSONLDSettings.WHITELIST);
            boolean documentLoaderCache = (Boolean)this.getParserConfig().get((RioSetting)JSONLDSettings.DOCUMENT_LOADER_CACHE);
            JsonLdOptions opts = new JsonLdOptions();
            opts.setUriValidation(false);
            opts.setExceptionOnWarning(((Boolean)this.getParserConfig().get((RioSetting)JSONLDSettings.EXCEPTION_ON_WARNING)).booleanValue());
            Document context = (Document)this.getParserConfig().get(JSONLDSettings.EXPAND_CONTEXT);
            DocumentLoader defaultDocumentLoader = opts.getDocumentLoader();
            DocumentLoader documentLoader = this.getParserConfig().get(JSONLDSettings.DOCUMENT_LOADER) == null ? new CachingDocumentLoader(secureMode, whitelist, documentLoaderCache) : (DocumentLoader)this.getParserConfig().get(JSONLDSettings.DOCUMENT_LOADER);
            if (context != null) {
                opts.setExpandContext(context);
                if (context.getDocumentUrl() != null) {
                    Optional jsonContent = context.getJsonContent();
                    if (jsonContent.isEmpty()) {
                        throw new RDFParseException("Expand context is not a valid JSON document");
                    }
                    opts.getContextCache().put((Object)context.getDocumentUrl().toString(), (Object)((JsonValue)jsonContent.get()));
                    opts.setDocumentLoader((uri, options) -> {
                        if (uri.equals(context.getDocumentUrl())) {
                            return context;
                        }
                        return documentLoader.loadDocument(uri, options);
                    });
                }
            }
            if (opts.getDocumentLoader() == defaultDocumentLoader) {
                opts.setDocumentLoader(documentLoader);
            }
            if (baseURI != null && !baseURI.isEmpty()) {
                URI uri2 = new URI(baseURI);
                opts.setBase(uri2);
            }
            if ((rdfHandler = this.getRDFHandler()) != null) {
                JSONLDParser.extractPrefixes(document, (arg_0, arg_1) -> ((RDFHandler)rdfHandler).handleNamespace(arg_0, arg_1));
            }
            ((ToRdfApi)JsonLd.toRdf((Document)document).options(opts).base(baseURI)).get((RdfConsumer)new RdfConsumer<Statement, Statement>(){

                public void handleTriple(Statement statement) {
                    if (rdfHandler != null) {
                        rdfHandler.handleStatement(statement);
                    }
                }

                public void handleQuad(Statement statement) {
                    if (rdfHandler != null) {
                        rdfHandler.handleStatement(statement);
                    }
                }
            }, (RdfValueFactory)new RdfValueFactory<Statement, Statement, IRI, Resource, Resource, Literal, Value>(){

                public Statement createTriple(Resource subject, IRI predicate, Value object) {
                    return JSONLDParser.this.createStatement(subject, predicate, object);
                }

                public Statement createQuad(Resource subject, IRI predicate, Value object, Resource graphName) {
                    return JSONLDParser.this.createStatement(subject, predicate, object, graphName);
                }

                public Statement createQuad(Statement statement, Resource graphName) {
                    return JSONLDParser.this.createStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), graphName);
                }

                public IRI createIRI(String value) {
                    return JSONLDParser.this.createURI(value);
                }

                public Resource createBlankNode(String value) {
                    if (value.startsWith("_:")) {
                        return JSONLDParser.this.createNode(value.substring(2));
                    }
                    return JSONLDParser.this.createNode(value);
                }

                public Literal createTypedLiteral(String value, String datatype) {
                    return JSONLDParser.this.createLiteral(value, null, JSONLDParser.this.valueFactory.createIRI(datatype));
                }

                public Literal createString(String value) {
                    return JSONLDParser.this.createLiteral(value, null, null);
                }

                public Literal createLangString(String value, String lang) {
                    return JSONLDParser.this.createLiteral(value, lang, null);
                }
            });
            if (rdfHandler != null) {
                rdfHandler.endRDF();
            }
        }
        catch (JsonLdError e) {
            throw new RDFParseException("Could not parse JSONLD", (Throwable)e);
        }
        catch (RuntimeException e) {
            if (e.getCause() != null && e.getCause() instanceof RDFParseException) {
                throw (RDFParseException)e.getCause();
            }
            throw e;
        }
        catch (URISyntaxException e) {
            throw new RDFParseException("Base uri is not a valid URI, " + baseURI, (Throwable)e);
        }
        finally {
            this.clear();
        }
    }

    protected Document getDocument(InputStream in, Reader reader) throws JsonLdError, IOException {
        JsonDocument document;
        if (in == null && reader != null) {
            document = JsonDocument.of((Reader)reader);
        } else if (in != null && reader == null) {
            document = JsonDocument.of((InputStream)in);
        } else {
            throw new IllegalArgumentException("Either in or reader must be set");
        }
        return document;
    }

    private static void extractPrefixes(Document document, BiConsumer<String, String> prefixConsumer) {
        try {
            JSONLDParser.extractPrefixes(document.getJsonContent().orElse(null), prefixConsumer);
        }
        catch (Exception e) {
            logger.error("Error extracting prefixes from JSON-LD", (Throwable)e);
        }
    }

    private static void extractPrefixes(JsonValue jsonValue, BiConsumer<String, String> prefixConsumer) {
        if (jsonValue == null) {
            return;
        }
        switch (jsonValue.getValueType()) {
            case ARRAY: {
                jsonValue.asJsonArray().forEach(jv -> JSONLDParser.extractPrefixes(jv, prefixConsumer));
                break;
            }
            case OBJECT: {
                JSONLDParser.extractPrefixes(jsonValue.asJsonObject(), prefixConsumer);
                break;
            }
        }
    }

    private static void extractPrefixes(JsonObject jsonObject, BiConsumer<String, String> prefixConsumer) {
        jsonObject.forEach((key, jsonValue) -> {
            if ("@context".equals(key) && JsonValue.ValueType.OBJECT == jsonValue.getValueType()) {
                JSONLDParser.extractPrefixes(jsonValue, prefixConsumer);
            } else if (JsonValue.ValueType.STRING == jsonValue.getValueType()) {
                String prefix = key;
                if ("@vocab".equals(key)) {
                    prefix = "";
                } else if (key.startsWith("@")) {
                    return;
                }
                String iri = ((JsonString)jsonValue).getString();
                if (iri.endsWith("#") || iri.endsWith("/") || iri.endsWith(":")) {
                    prefixConsumer.accept(prefix, iri);
                }
            }
        });
    }
}

