/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.internal.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.ecl.core.LiteralParameter;
import org.eclipse.rcptt.ecl.runtime.IParamConverter;

public class ObjectParamConverter
implements IParamConverter<Object> {
    private static final Map<String, IConverter> CONVERTERS = new HashMap<String, IConverter>();
    private static String[] DEFAULT_CONVERTERS;

    static {
        ObjectParamConverter.multiPut(CONVERTERS, new IConverter(){

            @Override
            public Object convert(String value) {
                try {
                    return Integer.decode(value);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }, "int", "Integer", Integer.class.getName());
        ObjectParamConverter.multiPut(CONVERTERS, new IConverter(){

            @Override
            public Object convert(String value) {
                try {
                    return Double.valueOf(value);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }, "double", "Double", Double.class.getName());
        ObjectParamConverter.multiPut(CONVERTERS, new IConverter(){

            @Override
            public Object convert(String value) {
                return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false") ? Boolean.valueOf(value) : null;
            }
        }, "boolean", "Boolean", Boolean.class.getName());
        ObjectParamConverter.multiPut(CONVERTERS, new IConverter(){

            @Override
            public Object convert(String value) {
                return value;
            }
        }, "string", "String", String.class.getName());
        DEFAULT_CONVERTERS = new String[]{"int", "double", "boolean", "string"};
    }

    @Override
    public Object convert(LiteralParameter parameter, List<String> allowedTypes) throws CoreException {
        String literal = parameter.getLiteral();
        if (literal == null) {
            return null;
        }
        if (allowedTypes == null) {
            String[] stringArray = DEFAULT_CONVERTERS;
            int n = DEFAULT_CONVERTERS.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                IConverter c = CONVERTERS.get(s);
                assert (c != null);
                Object converted = c.convert(literal);
                if (converted != null) {
                    return converted;
                }
                ++n2;
            }
            return literal;
        }
        for (String t : allowedTypes) {
            IConverter converter = CONVERTERS.get(t);
            if (converter == null) {
                if (t.contains(".")) continue;
                return ObjectParamConverter.error("No converter for type " + t);
            }
            Object converted = converter.convert(literal);
            if (converted == null) continue;
            return converted;
        }
        return ObjectParamConverter.error("Unable to convert \"" + literal + "\"");
    }

    @Override
    public Class<Object> forType() {
        return Object.class;
    }

    private static Object error(String message) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.ecl.core", message));
    }

    private static <K, V> void multiPut(Map<K, V> map, V value, K ... keys) {
        K[] KArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            K k = KArray[n2];
            map.put(k, value);
            ++n2;
        }
    }

    @Override
    public String convertToCode(Object value) {
        return String.valueOf(value);
    }

    private static interface IConverter {
        public Object convert(String var1);
    }
}

