/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.site;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.PDEUIStateWrapper;
import org.eclipse.pde.internal.build.site.BuildTimeSite;
import org.eclipse.pde.internal.build.site.PluginPathFinder;

public class BuildTimeSiteContentProvider
implements IPDEBuildConstants {
    private final String installedBaseURL;
    private final List<File> files;
    private final PDEUIStateWrapper pdeUIState;
    private BuildTimeSite site;
    private boolean filterP2Base = false;

    public BuildTimeSiteContentProvider(List<File> urls, String installedBaseURL, PDEUIStateWrapper initialState) {
        this.installedBaseURL = installedBaseURL;
        this.files = urls;
        this.pdeUIState = initialState;
    }

    public String getInstalledBaseURL() {
        return this.installedBaseURL;
    }

    public Collection<File> getPluginPaths() {
        Collection<File> pluginsToCompile = this.findPluginXML(this.files);
        if (this.installedBaseURL != null) {
            pluginsToCompile.addAll(PluginPathFinder.getPluginPaths(this.installedBaseURL, this.filterP2Base));
        }
        return pluginsToCompile;
    }

    public URL getURL() {
        throw new RuntimeException();
    }

    private Collection<File> findPluginXML(List<File> location) {
        ArrayList<File> collectedElements = new ArrayList<File>(10);
        for (File element : location) {
            File f = new File(element, "plugins");
            if (f.exists()) {
                collectedElements.addAll(Arrays.asList(f.listFiles()));
                continue;
            }
            if (new File(element, "META-INF/MANIFEST.MF").exists() || new File(element, "plugin.xml").exists() || new File(element, "fragment.xml").exists()) {
                collectedElements.add(element);
                continue;
            }
            if (element.isDirectory()) {
                if (new File(element, ".settings/org.eclipse.pde.core.prefs").exists()) {
                    try {
                        File actualRoot;
                        Properties properties = AbstractScriptGenerator.readProperties(element.getAbsolutePath(), ".settings/org.eclipse.pde.core.prefs", 0);
                        String root = properties.getProperty("BUNDLE_ROOT_PATH");
                        if (root == null || !(actualRoot = new File(element, root)).exists()) continue;
                        collectedElements.add(actualRoot);
                    }
                    catch (CoreException coreException) {}
                    continue;
                }
                collectedElements.addAll(Arrays.asList(element.listFiles()));
                continue;
            }
            if (!element.isFile() || !element.getName().endsWith(".jar")) continue;
            collectedElements.add(element);
        }
        return collectedElements;
    }

    public File getBaseProfile() {
        if (this.installedBaseURL == null) {
            return null;
        }
        File configurationFolder = new File(this.installedBaseURL, "configuration");
        if (configurationFolder.exists()) {
            try {
                Properties config = AbstractScriptGenerator.readProperties(configurationFolder.getAbsolutePath(), "config.ini", 0);
                Object dataArea = config.getProperty("eclipse.p2.data.area");
                String profileName = config.getProperty("eclipse.p2.profile");
                if (dataArea != null && profileName != null) {
                    File profileArea;
                    int idx = ((String)dataArea).indexOf("@config.dir");
                    if (idx != -1) {
                        dataArea = ((String)dataArea).substring(0, idx) + configurationFolder.getAbsolutePath() + ((String)dataArea).substring(idx + 11);
                    }
                    if ((profileArea = new File((String)dataArea, "org.eclipse.equinox.p2.engine/profileRegistry/" + profileName + ".profile")).exists()) {
                        return profileArea;
                    }
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    public PDEUIStateWrapper getInitialState() {
        return this.pdeUIState;
    }

    public URL getArchiveReference(String id) {
        return null;
    }

    public BuildTimeSite getSite() {
        return this.site;
    }

    public void setSite(BuildTimeSite site) {
        this.site = site;
    }

    public void setFilterP2Base(boolean filter) {
        this.filterP2Base = filter;
    }
}

