/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.internal.core.IModelChangeProviderExtension;
import org.eclipse.pde.internal.core.IModelChangedListenerFilter;
import org.xml.sax.SAXException;

public abstract class AbstractModel
extends PlatformObject
implements IModel,
IModelChangeProviderExtension,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient List<IModelChangedListener> fListeners = Collections.synchronizedList(new ArrayList());
    private boolean fLoaded;
    protected boolean fDisposed;
    private long fTimestamp;
    private Exception fException;

    protected static String getLineDelimiterPreference(IFile file) {
        ITextFileBufferManager manager;
        ITextFileBuffer buffer;
        if (file != null && (buffer = (manager = FileBuffers.getTextFileBufferManager()).getTextFileBuffer(file.getFullPath(), LocationKind.IFILE)) != null) {
            return TextUtilities.getDefaultLineDelimiter((IDocument)buffer.getDocument());
        }
        return Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, null);
    }

    public static String fixLineDelimiter(String string, IFile file) {
        String lineDelimiter = AbstractModel.getLineDelimiterPreference(file);
        if (lineDelimiter == null) {
            return string;
        }
        String lineSeparator = System.lineSeparator();
        if (lineDelimiter.equals(lineSeparator)) {
            return string;
        }
        return string.replace(lineSeparator, lineDelimiter);
    }

    @Override
    public void addModelChangedListener(IModelChangedListener listener) {
        this.fListeners.add(listener);
    }

    @Override
    public void transferListenersTo(IModelChangeProviderExtension target, IModelChangedListenerFilter filter) {
        ArrayList<IModelChangedListener> removed = new ArrayList<IModelChangedListener>();
        int i = 0;
        while (i < this.fListeners.size()) {
            IModelChangedListener listener = this.fListeners.get(i);
            if (filter == null || filter.accept(listener)) {
                target.addModelChangedListener(listener);
                removed.add(listener);
            }
            ++i;
        }
        this.fListeners.removeAll(removed);
    }

    @Override
    public void dispose() {
        this.fDisposed = true;
    }

    @Override
    public void fireModelChanged(IModelChangedEvent event) {
        IModelChangedListener[] list;
        IModelChangedListener[] iModelChangedListenerArray = list = this.fListeners.toArray(new IModelChangedListener[this.fListeners.size()]);
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            IModelChangedListener listener = iModelChangedListenerArray[n2];
            listener.modelChanged(event);
            ++n2;
        }
    }

    @Override
    public void fireModelObjectChanged(Object object, String property, Object oldValue, Object newValue) {
        this.fireModelChanged(new ModelChangedEvent(this, object, property, oldValue, newValue));
    }

    @Override
    public String getResourceString(String key) {
        return key;
    }

    @Override
    public IResource getUnderlyingResource() {
        return null;
    }

    protected final boolean isResourceInSync() {
        Long timeStamp = this.getResourceTimeStamp();
        return timeStamp != null && timeStamp.longValue() == this.getTimeStamp();
    }

    protected Long getResourceTimeStamp() {
        IResource underlyingResource = this.getUnderlyingResource();
        if (underlyingResource == null) {
            return null;
        }
        if (underlyingResource.getLocation() == null) {
            return null;
        }
        long modificationStamp = underlyingResource.getModificationStamp();
        return modificationStamp == -1L ? null : Long.valueOf(modificationStamp);
    }

    @Override
    public boolean isInSync() {
        return this.isResourceInSync();
    }

    @Override
    public boolean isValid() {
        return !this.isDisposed() && this.isLoaded();
    }

    @Override
    public final long getTimeStamp() {
        return this.fTimestamp;
    }

    protected static Long getTimeStamp(File localFile) {
        try {
            long lastModified = Files.getLastModifiedTime(localFile.toPath(), new LinkOption[0]).toMillis();
            return lastModified;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected final void updateTimeStampWith(Long resourceTimeStamp) {
        if (resourceTimeStamp != null) {
            this.fTimestamp = resourceTimeStamp;
        }
    }

    protected void updateTimeStamp() {
        this.updateTimeStampFromResource();
    }

    protected void updateTimeStampFromResource() {
        this.updateTimeStampWith(this.getResourceTimeStamp());
    }

    protected void updateTimeStamp(File localFile) {
        this.updateTimeStampWith(AbstractModel.getTimeStamp(localFile));
    }

    @Override
    public boolean isDisposed() {
        return this.fDisposed;
    }

    @Override
    public boolean isLoaded() {
        return this.fLoaded;
    }

    public void setLoaded(boolean loaded) {
        this.fLoaded = loaded;
    }

    public void setException(Exception e) {
        this.fException = e;
    }

    public Exception getException() {
        return this.fException;
    }

    @Override
    public void removeModelChangedListener(IModelChangedListener listener) {
        this.fListeners.remove(listener);
    }

    public void throwParseErrorsException(Throwable e) throws CoreException {
        throw new CoreException(Status.error((String)"Error in the manifest file", (Throwable)e));
    }

    protected SAXParser getSaxParser() throws ParserConfigurationException, SAXException, FactoryConfigurationError {
        return XmlProcessorFactory.createSAXParserWithErrorOnDOCTYPE();
    }

    @Override
    public boolean isReconcilingModel() {
        return false;
    }
}

