/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.data.apache.poi.commands.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.rcptt.ecl.core.CorePackage;
import org.eclipse.rcptt.ecl.data.apache.poi.commands.CommandsFactory;
import org.eclipse.rcptt.ecl.data.apache.poi.commands.CommandsPackage;
import org.eclipse.rcptt.ecl.data.apache.poi.commands.GetTableCells;
import org.eclipse.rcptt.ecl.data.apache.poi.commands.GetTableRange;
import org.eclipse.rcptt.ecl.data.apache.poi.commands.ReadExcelFile;
import org.eclipse.rcptt.ecl.data.apache.poi.commands.SetTableCells;
import org.eclipse.rcptt.ecl.data.apache.poi.commands.WriteExcelFile;
import org.eclipse.rcptt.ecl.data.objects.ObjectsPackage;

public class CommandsPackageImpl
extends EPackageImpl
implements CommandsPackage {
    private EClass writeExcelFileEClass = null;
    private EClass readExcelFileEClass = null;
    private EClass getTableCellsEClass = null;
    private EClass getTableRangeEClass = null;
    private EClass setTableCellsEClass = null;
    private static boolean isInited = false;
    private boolean isCreated = false;
    private boolean isInitialized = false;

    private CommandsPackageImpl() {
        super("http://www.eclipse.org/ecl/data/apache/poi/commands.ecore", (EFactory)CommandsFactory.eINSTANCE);
    }

    public static CommandsPackage init() {
        if (isInited) {
            return (CommandsPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/ecl/data/apache/poi/commands.ecore");
        }
        CommandsPackageImpl theCommandsPackage = (CommandsPackageImpl)(EPackage.Registry.INSTANCE.get((Object)"http://www.eclipse.org/ecl/data/apache/poi/commands.ecore") instanceof CommandsPackageImpl ? EPackage.Registry.INSTANCE.get((Object)"http://www.eclipse.org/ecl/data/apache/poi/commands.ecore") : new CommandsPackageImpl());
        isInited = true;
        CorePackage.eINSTANCE.eClass();
        ObjectsPackage.eINSTANCE.eClass();
        theCommandsPackage.createPackageContents();
        theCommandsPackage.initializePackageContents();
        theCommandsPackage.freeze();
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/ecl/data/apache/poi/commands.ecore", (Object)theCommandsPackage);
        return theCommandsPackage;
    }

    @Override
    public EClass getWriteExcelFile() {
        return this.writeExcelFileEClass;
    }

    @Override
    public EReference getWriteExcelFile_Tables() {
        return (EReference)this.writeExcelFileEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EAttribute getWriteExcelFile_Uri() {
        return (EAttribute)this.writeExcelFileEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EAttribute getWriteExcelFile_Append() {
        return (EAttribute)this.writeExcelFileEClass.getEStructuralFeatures().get(2);
    }

    @Override
    public EClass getReadExcelFile() {
        return this.readExcelFileEClass;
    }

    @Override
    public EAttribute getReadExcelFile_Uri() {
        return (EAttribute)this.readExcelFileEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EAttribute getReadExcelFile_Sheets() {
        return (EAttribute)this.readExcelFileEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EClass getGetTableCells() {
        return this.getTableCellsEClass;
    }

    @Override
    public EReference getGetTableCells_Table() {
        return (EReference)this.getTableCellsEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EAttribute getGetTableCells_Cells() {
        return (EAttribute)this.getTableCellsEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EClass getGetTableRange() {
        return this.getTableRangeEClass;
    }

    @Override
    public EReference getGetTableRange_Table() {
        return (EReference)this.getTableRangeEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EAttribute getGetTableRange_Range() {
        return (EAttribute)this.getTableRangeEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EClass getSetTableCells() {
        return this.setTableCellsEClass;
    }

    @Override
    public EReference getSetTableCells_Table() {
        return (EReference)this.setTableCellsEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EReference getSetTableCells_Cells() {
        return (EReference)this.setTableCellsEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public CommandsFactory getCommandsFactory() {
        return (CommandsFactory)this.getEFactoryInstance();
    }

    public void createPackageContents() {
        if (this.isCreated) {
            return;
        }
        this.isCreated = true;
        this.writeExcelFileEClass = this.createEClass(0);
        this.createEReference(this.writeExcelFileEClass, 2);
        this.createEAttribute(this.writeExcelFileEClass, 3);
        this.createEAttribute(this.writeExcelFileEClass, 4);
        this.readExcelFileEClass = this.createEClass(1);
        this.createEAttribute(this.readExcelFileEClass, 2);
        this.createEAttribute(this.readExcelFileEClass, 3);
        this.getTableCellsEClass = this.createEClass(2);
        this.createEReference(this.getTableCellsEClass, 2);
        this.createEAttribute(this.getTableCellsEClass, 3);
        this.getTableRangeEClass = this.createEClass(3);
        this.createEReference(this.getTableRangeEClass, 2);
        this.createEAttribute(this.getTableRangeEClass, 3);
        this.setTableCellsEClass = this.createEClass(4);
        this.createEReference(this.setTableCellsEClass, 2);
        this.createEReference(this.setTableCellsEClass, 3);
    }

    public void initializePackageContents() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        this.setName("commands");
        this.setNsPrefix("dataCommands");
        this.setNsURI("http://www.eclipse.org/ecl/data/apache/poi/commands.ecore");
        CorePackage theCorePackage = (CorePackage)EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/ecl/core.ecore");
        ObjectsPackage theObjectsPackage = (ObjectsPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/ecl/data/objects.ecore");
        EcorePackage theEcorePackage = (EcorePackage)EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/emf/2002/Ecore");
        this.writeExcelFileEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.readExcelFileEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.getTableCellsEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.getTableRangeEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.setTableCellsEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.initEClass(this.writeExcelFileEClass, WriteExcelFile.class, "WriteExcelFile", false, false, true);
        this.initEReference(this.getWriteExcelFile_Tables(), (EClassifier)theObjectsPackage.getTable(), null, "tables", null, 1, -1, WriteExcelFile.class, false, false, true, false, true, false, true, false, true);
        this.initEAttribute(this.getWriteExcelFile_Uri(), (EClassifier)theEcorePackage.getEString(), "uri", null, 1, 1, WriteExcelFile.class, false, false, true, false, false, true, false, true);
        this.initEAttribute(this.getWriteExcelFile_Append(), (EClassifier)theEcorePackage.getEBoolean(), "append", "false", 0, 1, WriteExcelFile.class, false, false, true, false, false, true, false, true);
        this.initEClass(this.readExcelFileEClass, ReadExcelFile.class, "ReadExcelFile", false, false, true);
        this.initEAttribute(this.getReadExcelFile_Uri(), (EClassifier)theEcorePackage.getEString(), "uri", null, 1, 1, ReadExcelFile.class, false, false, true, false, false, true, false, true);
        this.initEAttribute(this.getReadExcelFile_Sheets(), (EClassifier)theEcorePackage.getEString(), "sheets", null, 0, -1, ReadExcelFile.class, false, false, true, false, false, true, false, true);
        this.initEClass(this.getTableCellsEClass, GetTableCells.class, "GetTableCells", false, false, true);
        this.initEReference(this.getGetTableCells_Table(), (EClassifier)theObjectsPackage.getTable(), null, "table", null, 1, 1, GetTableCells.class, false, false, true, false, true, false, true, false, true);
        this.initEAttribute(this.getGetTableCells_Cells(), (EClassifier)theEcorePackage.getEString(), "cells", null, 1, -1, GetTableCells.class, false, false, true, false, false, true, false, true);
        this.initEClass(this.getTableRangeEClass, GetTableRange.class, "GetTableRange", false, false, true);
        this.initEReference(this.getGetTableRange_Table(), (EClassifier)theObjectsPackage.getTable(), null, "table", null, 1, 1, GetTableRange.class, false, false, true, false, true, false, true, false, true);
        this.initEAttribute(this.getGetTableRange_Range(), (EClassifier)theEcorePackage.getEString(), "range", null, 1, 1, GetTableRange.class, false, false, true, false, false, true, false, true);
        this.initEClass(this.setTableCellsEClass, SetTableCells.class, "SetTableCells", false, false, true);
        this.initEReference(this.getSetTableCells_Table(), (EClassifier)theObjectsPackage.getTable(), null, "table", null, 1, 1, SetTableCells.class, false, false, true, false, true, false, true, false, true);
        this.initEReference(this.getSetTableCells_Cells(), (EClassifier)theCorePackage.getEclMap(), null, "cells", null, 1, 1, SetTableCells.class, false, false, true, false, true, false, true, false, true);
        this.createResource("http://www.eclipse.org/ecl/data/apache/poi/commands.ecore");
        this.createDocsAnnotations();
        this.createInputAnnotations();
    }

    protected void createDocsAnnotations() {
        String source = "http://www.eclipse.org/ecl/docs";
        this.addAnnotation((ENamedElement)this.writeExcelFileEClass, source, new String[]{"description", "Writes tables from input pipe to into excel (xls or xlsx) file. Fails if file is not found or format is invalid.", "returns", "The value of <code>tables</code> argument", "example", "global [val supportedDevices [list\n\t[list \"Device Name\" \"Device Info\"]\n\t[list \"Device 1\" \"Info 1\"]\n\t[list \"Device 2\" \"Info 2\"]\n\t[list \"Device 3\" \"Info 3\"]\n]]\n\nglobal [val allDevices [list\n\t[list \"Device Name\" \"Device Info\"]\n\t[list \"Device 1\" \"Info 1\"]\n\t[list \"Device 2\" \"Info 2\"]\n\t[list \"Device 3\" \"Info 3\"]\n\t[list \"Device 4\" \"Info 4\"]\n\t[list \"Device 5\" \"Info 5\"]\n]]\n\n\nproc newTable [val table] [val name] {\n\t$table | list-as-table-data | set-page-name $name\n}\n\n\nemit [newTable $supportedDevices \"Supported devices\"] [newTable $allDevices \"All devices\"]\n\t| write-excel-file \"workspace:/excel/devices.xlsx\""});
        this.addAnnotation((ENamedElement)this.getWriteExcelFile_Tables(), source, new String[]{"description", "Tables to write"});
        this.addAnnotation((ENamedElement)this.getWriteExcelFile_Uri(), source, new String[]{"description", "URI to write Excel data to. Currently supported schemes are workspace:/ for files in workspace and file:/ for files on local file system"});
        this.addAnnotation((ENamedElement)this.readExcelFileEClass, source, new String[]{"description", "Parses given excel file (xls or xlsx) into tables and write them to output pipe. Fails if file is not found or format is invalid.", "returns", "List of <code>Table</code> EMF Objects", "example", "global [val devicesInfo [\n\tread-excel-file \"workspace:/excel/devices.xlsx\" \"Supported devices\" \"All devices\"\n\t\t| to-list\n]]\n\n\nclear-log-view\n\n$devicesInfo | each [val table] {\n\tlog [format \"Page name: %s\" [$table | get pageName]]\n\t$table | list [get rows] | each [val row] {\n\t\t$row | list [get values] | each [val value] {\n\t\t\tlog $value\n\t\t}\n\t}\n}\n\nread-excel-file \"workspace:/excel/devices.xlsx\" \"Additional info\"\n\t| get rows | get values | log"});
        this.addAnnotation((ENamedElement)this.getReadExcelFile_Uri(), source, new String[]{"description", "URI to read Excel data from. Currently supported schemes are workspace:/ for files in workspace and file:/ for files on local file system"});
        this.addAnnotation((ENamedElement)this.getReadExcelFile_Sheets(), source, new String[]{"description", "List of Excel sheet names to read data from"});
        this.addAnnotation((ENamedElement)this.getTableCellsEClass, source, new String[]{"description", "Gets cell values by excel names and writes them into the output pipe", "returns", "Cell values", "example", "read-excel-file \"workspace:/excel/devices.xlsx\" \"Supported devices\"\n\t| get-table-cells A1 | eq \"Device Name\" | verify-true"});
        this.addAnnotation((ENamedElement)this.getGetTableCells_Table(), source, new String[]{"description", "Table to get cells from"});
        this.addAnnotation((ENamedElement)this.getGetTableCells_Cells(), source, new String[]{"description", "Cell names"});
        this.addAnnotation((ENamedElement)this.getTableRangeEClass, source, new String[]{"description", "Gets range by excel name and writes it into the output pipe", "returns", "<code>Table</code> EMF Object", "example", "read-excel-file \"workspace:/excel/devices.xlsx\" \"Supported devices\"\n\t| get-table-range \"A2:B4\" | list [get rows] | each [val row] {\n\t\t$row | list [get values] | each [val value] {\n\t\t\tlog $value\n\t\t}\n}"});
        this.addAnnotation((ENamedElement)this.getGetTableRange_Table(), source, new String[]{"description", "Table to get range from"});
        this.addAnnotation((ENamedElement)this.getGetTableRange_Range(), source, new String[]{"description", "Range name in the excel format (for example \"A1:B2\")"});
        this.addAnnotation((ENamedElement)this.setTableCellsEClass, source, new String[]{"description", "Sets cell values to the table", "returns", "The value of 'table' argument", "example", "read-excel-file \"workspace:/excel/devices.xlsx\" \"Supported devices\"\n\t| set-table-cells [map [entry \"A1\" \"New Device Name\"] [entry \"B1\" \"New Device Target\"]]\n\t| write-excel-file \"workspace:/excel/devices.xlsx\" -append"});
        this.addAnnotation((ENamedElement)this.getSetTableCells_Table(), source, new String[]{"description", "Table to set cell values to"});
        this.addAnnotation((ENamedElement)this.getSetTableCells_Cells(), source, new String[]{"description", "Map where key is cell name and value is cell value to set"});
    }

    protected void createInputAnnotations() {
        String source = "http://www.eclipse.org/ecl/input";
        this.addAnnotation((ENamedElement)this.getWriteExcelFile_Tables(), source, new String[0]);
        this.addAnnotation((ENamedElement)this.getGetTableCells_Table(), source, new String[0]);
        this.addAnnotation((ENamedElement)this.getGetTableRange_Table(), source, new String[0]);
        this.addAnnotation((ENamedElement)this.getSetTableCells_Table(), source, new String[0]);
    }
}

