/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.platform.internal.commands;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.platform.commands.Log;
import org.eclipse.rcptt.ecl.platform.internal.PlatformPlugin;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;

public class LogService
implements ICommandService {
    public static final Map<String, Integer> severities = new HashMap<String, Integer>();

    static {
        severities.put("info", 1);
        severities.put("warning", 2);
        severities.put("warn", 2);
        severities.put("error", 4);
        severities.put("err", 4);
        severities.put("ok", 4);
        severities.put("cancel", 4);
    }

    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        if (!(command instanceof Log)) {
            return Status.CANCEL_STATUS;
        }
        Log log = (Log)command;
        String message = log.getMessage();
        String pluginId = log.getPlugin();
        int severity = this.getSeverity(log.getSeverity());
        PlatformPlugin.getDefault().getLog().log((IStatus)new Status(severity, pluginId, message, null));
        return Status.OK_STATUS;
    }

    private int getSeverity(String severityText) {
        Integer result;
        if (severityText == null) {
            severityText = "";
        }
        return (result = severities.get(severityText.toLowerCase())) == null ? 1 : result;
    }
}

