/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.workspace;

import java.io.IOException;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.archive.ArchiveURLConnection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;

public class WorkspaceSynchronizer {
    public static IFile getFile(Resource resource) {
        if (resource == null) {
            return null;
        }
        ResourceSet rset = resource.getResourceSet();
        return WorkspaceSynchronizer.getFile(resource.getURI(), rset != null ? rset.getURIConverter() : null, false);
    }

    private static IFile getFile(URI uri, URIConverter converter, boolean considerArchives) {
        IFile result = null;
        if (considerArchives && uri.isArchive()) {
            class MyArchiveURLConnection
            extends ArchiveURLConnection {
                public MyArchiveURLConnection(String url) {
                    super(url);
                }

                public String getNestedURI() {
                    try {
                        return this.getNestedURL();
                    }
                    catch (IOException exception) {
                        return "";
                    }
                }
            }
            MyArchiveURLConnection archiveURLConnection = new MyArchiveURLConnection(uri.toString());
            result = WorkspaceSynchronizer.getFile(URI.createURI((String)archiveURLConnection.getNestedURI()), converter, considerArchives);
        } else {
            URI normalized;
            if (uri.isPlatformPlugin()) {
                return result;
            }
            if (uri.isPlatformResource()) {
                Path path = new Path(uri.toPlatformString(true));
                result = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            } else if (uri.isFile() && !uri.isRelative()) {
                result = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(uri.toFileString()));
            } else if (converter != null && !uri.equals(normalized = converter.normalize(uri))) {
                result = WorkspaceSynchronizer.getFile(normalized, converter, considerArchives);
            }
        }
        if (result == null && !uri.isRelative()) {
            try {
                IFile[] files;
                java.net.URI location = new java.net.URI(uri.toString());
                if (WorkspaceSynchronizer.hasRegisteredEFS(location) && (files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(new java.net.URI(uri.toString()))).length > 0) {
                    result = files[0];
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return result;
    }

    private static boolean hasRegisteredEFS(java.net.URI location) {
        try {
            return EFS.getStore((java.net.URI)location) != null;
        }
        catch (CoreException ex) {
            return false;
        }
    }
}

