/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.refactoring.delete;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7ProjectMetadata;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.IVerification;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.ProjectMetadata;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.ui.refactoring.delete.AbstractDeleteVerificationReferenceChange;
import org.eclipse.rcptt.ui.refactoring.delete.DeleteVerificationReferenceChange;

public class UndoDeleteVerificationReferenceChange
extends AbstractDeleteVerificationReferenceChange {
    private final int index;

    public UndoDeleteVerificationReferenceChange(IQ7Element element, IFile elementFile, IVerification verification, String id, int index) {
        super(element, verification, id);
        this.index = index;
    }

    public String getName() {
        return Messages.bind((String)Messages.UndoDeleteContextReferenceChange_Name, (Object)this.getVerification().getName(), (Object)this.getElement().getName());
    }

    protected final int getIndex() {
        return this.index;
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (!this.isValid()) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.UndoDeleteContextReferenceChange_InvalidRefMsg);
        }
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        try {
            DeleteVerificationReferenceChange deleteVerificationReferenceChange;
            IQ7NamedElement e = (IQ7NamedElement)this.getElement();
            IQ7NamedElement copy = e.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            try {
                NamedElement namedElement;
                List<String> references = this.getVerificationReferences(copy);
                references.add(this.getIndex(), this.getVerificationId());
                if (copy instanceof ITestCase) {
                    ((ITestCase)copy).setVerifications(references.toArray(new String[references.size()]));
                } else if (copy instanceof IQ7ProjectMetadata && (namedElement = copy.getNamedElement()) instanceof ProjectMetadata) {
                    ProjectMetadata meta = (ProjectMetadata)namedElement;
                    meta.getVerifications().clear();
                    meta.getVerifications().addAll(references);
                }
                copy.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
                deleteVerificationReferenceChange = new DeleteVerificationReferenceChange(this.getElement(), this.getVerification(), this.getVerificationId());
            }
            catch (Throwable throwable) {
                copy.discardWorkingCopy();
                throw throwable;
            }
            copy.discardWorkingCopy();
            return deleteVerificationReferenceChange;
        }
        finally {
            pm.done();
        }
    }
}

